/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A weekly schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeeklySchedule implements SdkPojo, Serializable, ToCopyableBuilder<WeeklySchedule.Builder, WeeklySchedule> {
    private static final SdkField<List<String>> DAYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("days")
            .getter(getter(WeeklySchedule::daysAsStrings))
            .setter(setter(Builder::daysWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("days").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Time> START_TIME_FIELD = SdkField.<Time> builder(MarshallingType.SDK_POJO)
            .memberName("startTime").getter(getter(WeeklySchedule::startTime)).setter(setter(Builder::startTime))
            .constructor(Time::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> days;

    private final Time startTime;

    private WeeklySchedule(BuilderImpl builder) {
        this.days = builder.days;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The weekly schedule's days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDays} method.
     * </p>
     * 
     * @return The weekly schedule's days.
     */
    public final List<Day> days() {
        return DaysListCopier.copyStringToEnum(days);
    }

    /**
     * For responses, this returns true if the service returned a value for the Days property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasDays() {
        return days != null && !(days instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The weekly schedule's days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDays} method.
     * </p>
     * 
     * @return The weekly schedule's days.
     */
    public final List<String> daysAsStrings() {
        return days;
    }

    /**
     * <p>
     * The weekly schedule's start time.
     * </p>
     * 
     * @return The weekly schedule's start time.
     */
    public final Time startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDays() ? daysAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklySchedule)) {
            return false;
        }
        WeeklySchedule other = (WeeklySchedule) obj;
        return hasDays() == other.hasDays() && Objects.equals(daysAsStrings(), other.daysAsStrings())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeeklySchedule").add("Days", hasDays() ? daysAsStrings() : null).add("StartTime", startTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "days":
            return Optional.ofNullable(clazz.cast(daysAsStrings()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklySchedule, T> g) {
        return obj -> g.apply((WeeklySchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeeklySchedule> {
        /**
         * <p>
         * The weekly schedule's days.
         * </p>
         * 
         * @param days
         *        The weekly schedule's days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysWithStrings(Collection<String> days);

        /**
         * <p>
         * The weekly schedule's days.
         * </p>
         * 
         * @param days
         *        The weekly schedule's days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysWithStrings(String... days);

        /**
         * <p>
         * The weekly schedule's days.
         * </p>
         * 
         * @param days
         *        The weekly schedule's days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Collection<Day> days);

        /**
         * <p>
         * The weekly schedule's days.
         * </p>
         * 
         * @param days
         *        The weekly schedule's days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Day... days);

        /**
         * <p>
         * The weekly schedule's start time.
         * </p>
         * 
         * @param startTime
         *        The weekly schedule's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Time startTime);

        /**
         * <p>
         * The weekly schedule's start time.
         * </p>
         * This is a convenience method that creates an instance of the {@link Time.Builder} avoiding the need to create
         * one manually via {@link Time#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Time.Builder#build()} is called immediately and its result is
         * passed to {@link #startTime(Time)}.
         * 
         * @param startTime
         *        a consumer that will call methods on {@link Time.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTime(Time)
         */
        default Builder startTime(Consumer<Time.Builder> startTime) {
            return startTime(Time.builder().applyMutation(startTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> days = DefaultSdkAutoConstructList.getInstance();

        private Time startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklySchedule model) {
            daysWithStrings(model.days);
            startTime(model.startTime);
        }

        public final Collection<String> getDays() {
            if (days instanceof SdkAutoConstructList) {
                return null;
            }
            return days;
        }

        public final void setDays(Collection<String> days) {
            this.days = DaysListCopier.copy(days);
        }

        @Override
        public final Builder daysWithStrings(Collection<String> days) {
            this.days = DaysListCopier.copy(days);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysWithStrings(String... days) {
            daysWithStrings(Arrays.asList(days));
            return this;
        }

        @Override
        public final Builder days(Collection<Day> days) {
            this.days = DaysListCopier.copyEnumToString(days);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder days(Day... days) {
            days(Arrays.asList(days));
            return this;
        }

        public final Time.Builder getStartTime() {
            return startTime != null ? startTime.toBuilder() : null;
        }

        public final void setStartTime(Time.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(Time startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public WeeklySchedule build() {
            return new WeeklySchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
