/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of CIS scan configurations filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCisScanConfigurationsFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCisScanConfigurationsFilterCriteria.Builder, ListCisScanConfigurationsFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> SCAN_CONFIGURATION_ARN_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanConfigurationArnFilters")
            .getter(getter(ListCisScanConfigurationsFilterCriteria::scanConfigurationArnFilters))
            .setter(setter(Builder::scanConfigurationArnFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArnFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> SCAN_NAME_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanNameFilters")
            .getter(getter(ListCisScanConfigurationsFilterCriteria::scanNameFilters))
            .setter(setter(Builder::scanNameFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> TARGET_RESOURCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("targetResourceTagFilters")
            .getter(getter(ListCisScanConfigurationsFilterCriteria::targetResourceTagFilters))
            .setter(setter(Builder::targetResourceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCAN_CONFIGURATION_ARN_FILTERS_FIELD, SCAN_NAME_FILTERS_FIELD, TARGET_RESOURCE_TAG_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CisStringFilter> scanConfigurationArnFilters;

    private final List<CisStringFilter> scanNameFilters;

    private final List<TagFilter> targetResourceTagFilters;

    private ListCisScanConfigurationsFilterCriteria(BuilderImpl builder) {
        this.scanConfigurationArnFilters = builder.scanConfigurationArnFilters;
        this.scanNameFilters = builder.scanNameFilters;
        this.targetResourceTagFilters = builder.targetResourceTagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanConfigurationArnFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasScanConfigurationArnFilters() {
        return scanConfigurationArnFilters != null && !(scanConfigurationArnFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan configuration ARN filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanConfigurationArnFilters} method.
     * </p>
     * 
     * @return The list of scan configuration ARN filters.
     */
    public final List<CisStringFilter> scanConfigurationArnFilters() {
        return scanConfigurationArnFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanNameFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanNameFilters() {
        return scanNameFilters != null && !(scanNameFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan name filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanNameFilters} method.
     * </p>
     * 
     * @return The list of scan name filters.
     */
    public final List<CisStringFilter> scanNameFilters() {
        return scanNameFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceTagFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetResourceTagFilters() {
        return targetResourceTagFilters != null && !(targetResourceTagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of target resource tag filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceTagFilters} method.
     * </p>
     * 
     * @return The list of target resource tag filters.
     */
    public final List<TagFilter> targetResourceTagFilters() {
        return targetResourceTagFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScanConfigurationArnFilters() ? scanConfigurationArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanNameFilters() ? scanNameFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceTagFilters() ? targetResourceTagFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScanConfigurationsFilterCriteria)) {
            return false;
        }
        ListCisScanConfigurationsFilterCriteria other = (ListCisScanConfigurationsFilterCriteria) obj;
        return hasScanConfigurationArnFilters() == other.hasScanConfigurationArnFilters()
                && Objects.equals(scanConfigurationArnFilters(), other.scanConfigurationArnFilters())
                && hasScanNameFilters() == other.hasScanNameFilters()
                && Objects.equals(scanNameFilters(), other.scanNameFilters())
                && hasTargetResourceTagFilters() == other.hasTargetResourceTagFilters()
                && Objects.equals(targetResourceTagFilters(), other.targetResourceTagFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCisScanConfigurationsFilterCriteria")
                .add("ScanConfigurationArnFilters", hasScanConfigurationArnFilters() ? scanConfigurationArnFilters() : null)
                .add("ScanNameFilters", hasScanNameFilters() ? scanNameFilters() : null)
                .add("TargetResourceTagFilters", hasTargetResourceTagFilters() ? targetResourceTagFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArnFilters":
            return Optional.ofNullable(clazz.cast(scanConfigurationArnFilters()));
        case "scanNameFilters":
            return Optional.ofNullable(clazz.cast(scanNameFilters()));
        case "targetResourceTagFilters":
            return Optional.ofNullable(clazz.cast(targetResourceTagFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCisScanConfigurationsFilterCriteria, T> g) {
        return obj -> g.apply((ListCisScanConfigurationsFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCisScanConfigurationsFilterCriteria> {
        /**
         * <p>
         * The list of scan configuration ARN filters.
         * </p>
         * 
         * @param scanConfigurationArnFilters
         *        The list of scan configuration ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArnFilters(Collection<CisStringFilter> scanConfigurationArnFilters);

        /**
         * <p>
         * The list of scan configuration ARN filters.
         * </p>
         * 
         * @param scanConfigurationArnFilters
         *        The list of scan configuration ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArnFilters(CisStringFilter... scanConfigurationArnFilters);

        /**
         * <p>
         * The list of scan configuration ARN filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanConfigurationArnFilters(List<CisStringFilter>)}.
         * 
         * @param scanConfigurationArnFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanConfigurationArnFilters(java.util.Collection<CisStringFilter>)
         */
        Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder>... scanConfigurationArnFilters);

        /**
         * <p>
         * The list of scan name filters.
         * </p>
         * 
         * @param scanNameFilters
         *        The list of scan name filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameFilters(Collection<CisStringFilter> scanNameFilters);

        /**
         * <p>
         * The list of scan name filters.
         * </p>
         * 
         * @param scanNameFilters
         *        The list of scan name filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameFilters(CisStringFilter... scanNameFilters);

        /**
         * <p>
         * The list of scan name filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanNameFilters(List<CisStringFilter>)}.
         * 
         * @param scanNameFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanNameFilters(java.util.Collection<CisStringFilter>)
         */
        Builder scanNameFilters(Consumer<CisStringFilter.Builder>... scanNameFilters);

        /**
         * <p>
         * The list of target resource tag filters.
         * </p>
         * 
         * @param targetResourceTagFilters
         *        The list of target resource tag filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters);

        /**
         * <p>
         * The list of target resource tag filters.
         * </p>
         * 
         * @param targetResourceTagFilters
         *        The list of target resource tag filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTagFilters(TagFilter... targetResourceTagFilters);

        /**
         * <p>
         * The list of target resource tag filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #targetResourceTagFilters(List<TagFilter>)}.
         * 
         * @param targetResourceTagFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceTagFilters(java.util.Collection<TagFilter>)
         */
        Builder targetResourceTagFilters(Consumer<TagFilter.Builder>... targetResourceTagFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<CisStringFilter> scanConfigurationArnFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> scanNameFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> targetResourceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScanConfigurationsFilterCriteria model) {
            scanConfigurationArnFilters(model.scanConfigurationArnFilters);
            scanNameFilters(model.scanNameFilters);
            targetResourceTagFilters(model.targetResourceTagFilters);
        }

        public final List<CisStringFilter.Builder> getScanConfigurationArnFilters() {
            List<CisStringFilter.Builder> result = CisScanConfigurationArnFilterListCopier
                    .copyToBuilder(this.scanConfigurationArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanConfigurationArnFilters(Collection<CisStringFilter.BuilderImpl> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier
                    .copyFromBuilder(scanConfigurationArnFilters);
        }

        @Override
        public final Builder scanConfigurationArnFilters(Collection<CisStringFilter> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier.copy(scanConfigurationArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(CisStringFilter... scanConfigurationArnFilters) {
            scanConfigurationArnFilters(Arrays.asList(scanConfigurationArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder>... scanConfigurationArnFilters) {
            scanConfigurationArnFilters(Stream.of(scanConfigurationArnFilters)
                    .map(c -> CisStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanNameFilters() {
            List<CisStringFilter.Builder> result = CisScanNameFilterListCopier.copyToBuilder(this.scanNameFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanNameFilters(Collection<CisStringFilter.BuilderImpl> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copyFromBuilder(scanNameFilters);
        }

        @Override
        public final Builder scanNameFilters(Collection<CisStringFilter> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copy(scanNameFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(CisStringFilter... scanNameFilters) {
            scanNameFilters(Arrays.asList(scanNameFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(Consumer<CisStringFilter.Builder>... scanNameFilters) {
            scanNameFilters(Stream.of(scanNameFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getTargetResourceTagFilters() {
            List<TagFilter.Builder> result = ResourceTagFilterListCopier.copyToBuilder(this.targetResourceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTagFilters(Collection<TagFilter.BuilderImpl> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copyFromBuilder(targetResourceTagFilters);
        }

        @Override
        public final Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copy(targetResourceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(TagFilter... targetResourceTagFilters) {
            targetResourceTagFilters(Arrays.asList(targetResourceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(Consumer<TagFilter.Builder>... targetResourceTagFilters) {
            targetResourceTagFilters(Stream.of(targetResourceTagFilters).map(c -> TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCisScanConfigurationsFilterCriteria build() {
            return new ListCisScanConfigurationsFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
