/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCisScanReportRequest extends Inspector2Request implements
        ToCopyableBuilder<GetCisScanReportRequest.Builder, GetCisScanReportRequest> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(GetCisScanReportRequest::scanArn)).setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<List<String>> TARGET_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetAccounts")
            .getter(getter(GetCisScanReportRequest::targetAccounts))
            .setter(setter(Builder::targetAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD,
            TARGET_ACCOUNTS_FIELD));

    private final String scanArn;

    private final List<String> targetAccounts;

    private GetCisScanReportRequest(BuilderImpl builder) {
        super(builder);
        this.scanArn = builder.scanArn;
        this.targetAccounts = builder.targetAccounts;
    }

    /**
     * <p>
     * The scan ARN.
     * </p>
     * 
     * @return The scan ARN.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetAccounts() {
        return targetAccounts != null && !(targetAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetAccounts} method.
     * </p>
     * 
     * @return The target accounts.
     */
    public final List<String> targetAccounts() {
        return targetAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetAccounts() ? targetAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCisScanReportRequest)) {
            return false;
        }
        GetCisScanReportRequest other = (GetCisScanReportRequest) obj;
        return Objects.equals(scanArn(), other.scanArn()) && hasTargetAccounts() == other.hasTargetAccounts()
                && Objects.equals(targetAccounts(), other.targetAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCisScanReportRequest").add("ScanArn", scanArn())
                .add("TargetAccounts", hasTargetAccounts() ? targetAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "targetAccounts":
            return Optional.ofNullable(clazz.cast(targetAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCisScanReportRequest, T> g) {
        return obj -> g.apply((GetCisScanReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetCisScanReportRequest> {
        /**
         * <p>
         * The scan ARN.
         * </p>
         * 
         * @param scanArn
         *        The scan ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The target accounts.
         * </p>
         * 
         * @param targetAccounts
         *        The target accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccounts(Collection<String> targetAccounts);

        /**
         * <p>
         * The target accounts.
         * </p>
         * 
         * @param targetAccounts
         *        The target accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccounts(String... targetAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String scanArn;

        private List<String> targetAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCisScanReportRequest model) {
            super(model);
            scanArn(model.scanArn);
            targetAccounts(model.targetAccounts);
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final Collection<String> getTargetAccounts() {
            if (targetAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return targetAccounts;
        }

        public final void setTargetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ReportTargetAccountsCopier.copy(targetAccounts);
        }

        @Override
        public final Builder targetAccounts(Collection<String> targetAccounts) {
            this.targetAccounts = ReportTargetAccountsCopier.copy(targetAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccounts(String... targetAccounts) {
            targetAccounts(Arrays.asList(targetAccounts));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCisScanReportRequest build() {
            return new GetCisScanReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
