/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of CIS scans filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCisScansFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCisScansFilterCriteria.Builder, ListCisScansFilterCriteria> {
    private static final SdkField<List<CisNumberFilter>> FAILED_CHECKS_FILTERS_FIELD = SdkField
            .<List<CisNumberFilter>> builder(MarshallingType.LIST)
            .memberName("failedChecksFilters")
            .getter(getter(ListCisScansFilterCriteria::failedChecksFilters))
            .setter(setter(Builder::failedChecksFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecksFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> SCAN_ARN_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanArnFilters")
            .getter(getter(ListCisScansFilterCriteria::scanArnFilters))
            .setter(setter(Builder::scanArnFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArnFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisDateFilter>> SCAN_AT_FILTERS_FIELD = SdkField
            .<List<CisDateFilter>> builder(MarshallingType.LIST)
            .memberName("scanAtFilters")
            .getter(getter(ListCisScansFilterCriteria::scanAtFilters))
            .setter(setter(Builder::scanAtFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanAtFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisDateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisDateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> SCAN_CONFIGURATION_ARN_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanConfigurationArnFilters")
            .getter(getter(ListCisScansFilterCriteria::scanConfigurationArnFilters))
            .setter(setter(Builder::scanConfigurationArnFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArnFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> SCAN_NAME_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanNameFilters")
            .getter(getter(ListCisScansFilterCriteria::scanNameFilters))
            .setter(setter(Builder::scanNameFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisScanStatusFilter>> SCAN_STATUS_FILTERS_FIELD = SdkField
            .<List<CisScanStatusFilter>> builder(MarshallingType.LIST)
            .memberName("scanStatusFilters")
            .getter(getter(ListCisScansFilterCriteria::scanStatusFilters))
            .setter(setter(Builder::scanStatusFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisScanStatusFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisScanStatusFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> SCHEDULED_BY_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("scheduledByFilters")
            .getter(getter(ListCisScansFilterCriteria::scheduledByFilters))
            .setter(setter(Builder::scheduledByFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledByFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> TARGET_ACCOUNT_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("targetAccountIdFilters")
            .getter(getter(ListCisScansFilterCriteria::targetAccountIdFilters))
            .setter(setter(Builder::targetAccountIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> TARGET_RESOURCE_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("targetResourceIdFilters")
            .getter(getter(ListCisScansFilterCriteria::targetResourceIdFilters))
            .setter(setter(Builder::targetResourceIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> TARGET_RESOURCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("targetResourceTagFilters")
            .getter(getter(ListCisScansFilterCriteria::targetResourceTagFilters))
            .setter(setter(Builder::targetResourceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_CHECKS_FILTERS_FIELD,
            SCAN_ARN_FILTERS_FIELD, SCAN_AT_FILTERS_FIELD, SCAN_CONFIGURATION_ARN_FILTERS_FIELD, SCAN_NAME_FILTERS_FIELD,
            SCAN_STATUS_FILTERS_FIELD, SCHEDULED_BY_FILTERS_FIELD, TARGET_ACCOUNT_ID_FILTERS_FIELD,
            TARGET_RESOURCE_ID_FILTERS_FIELD, TARGET_RESOURCE_TAG_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CisNumberFilter> failedChecksFilters;

    private final List<CisStringFilter> scanArnFilters;

    private final List<CisDateFilter> scanAtFilters;

    private final List<CisStringFilter> scanConfigurationArnFilters;

    private final List<CisStringFilter> scanNameFilters;

    private final List<CisScanStatusFilter> scanStatusFilters;

    private final List<CisStringFilter> scheduledByFilters;

    private final List<CisStringFilter> targetAccountIdFilters;

    private final List<CisStringFilter> targetResourceIdFilters;

    private final List<TagFilter> targetResourceTagFilters;

    private ListCisScansFilterCriteria(BuilderImpl builder) {
        this.failedChecksFilters = builder.failedChecksFilters;
        this.scanArnFilters = builder.scanArnFilters;
        this.scanAtFilters = builder.scanAtFilters;
        this.scanConfigurationArnFilters = builder.scanConfigurationArnFilters;
        this.scanNameFilters = builder.scanNameFilters;
        this.scanStatusFilters = builder.scanStatusFilters;
        this.scheduledByFilters = builder.scheduledByFilters;
        this.targetAccountIdFilters = builder.targetAccountIdFilters;
        this.targetResourceIdFilters = builder.targetResourceIdFilters;
        this.targetResourceTagFilters = builder.targetResourceTagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedChecksFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedChecksFilters() {
        return failedChecksFilters != null && !(failedChecksFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of failed checks filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedChecksFilters} method.
     * </p>
     * 
     * @return The list of failed checks filters.
     */
    public final List<CisNumberFilter> failedChecksFilters() {
        return failedChecksFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanArnFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanArnFilters() {
        return scanArnFilters != null && !(scanArnFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan ARN filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanArnFilters} method.
     * </p>
     * 
     * @return The list of scan ARN filters.
     */
    public final List<CisStringFilter> scanArnFilters() {
        return scanArnFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanAtFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanAtFilters() {
        return scanAtFilters != null && !(scanAtFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan at filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanAtFilters} method.
     * </p>
     * 
     * @return The list of scan at filters.
     */
    public final List<CisDateFilter> scanAtFilters() {
        return scanAtFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanConfigurationArnFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasScanConfigurationArnFilters() {
        return scanConfigurationArnFilters != null && !(scanConfigurationArnFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan configuration ARN filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanConfigurationArnFilters} method.
     * </p>
     * 
     * @return The list of scan configuration ARN filters.
     */
    public final List<CisStringFilter> scanConfigurationArnFilters() {
        return scanConfigurationArnFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanNameFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanNameFilters() {
        return scanNameFilters != null && !(scanNameFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan name filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanNameFilters} method.
     * </p>
     * 
     * @return The list of scan name filters.
     */
    public final List<CisStringFilter> scanNameFilters() {
        return scanNameFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanStatusFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanStatusFilters() {
        return scanStatusFilters != null && !(scanStatusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scan status filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanStatusFilters} method.
     * </p>
     * 
     * @return The list of scan status filters.
     */
    public final List<CisScanStatusFilter> scanStatusFilters() {
        return scanStatusFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduledByFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduledByFilters() {
        return scheduledByFilters != null && !(scheduledByFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scheduled by filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduledByFilters} method.
     * </p>
     * 
     * @return The list of scheduled by filters.
     */
    public final List<CisStringFilter> scheduledByFilters() {
        return scheduledByFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetAccountIdFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetAccountIdFilters() {
        return targetAccountIdFilters != null && !(targetAccountIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of target account ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetAccountIdFilters} method.
     * </p>
     * 
     * @return The list of target account ID filters.
     */
    public final List<CisStringFilter> targetAccountIdFilters() {
        return targetAccountIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceIdFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetResourceIdFilters() {
        return targetResourceIdFilters != null && !(targetResourceIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of target resource ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceIdFilters} method.
     * </p>
     * 
     * @return The list of target resource ID filters.
     */
    public final List<CisStringFilter> targetResourceIdFilters() {
        return targetResourceIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceTagFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetResourceTagFilters() {
        return targetResourceTagFilters != null && !(targetResourceTagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of target resource tag filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceTagFilters} method.
     * </p>
     * 
     * @return The list of target resource tag filters.
     */
    public final List<TagFilter> targetResourceTagFilters() {
        return targetResourceTagFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedChecksFilters() ? failedChecksFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanArnFilters() ? scanArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanAtFilters() ? scanAtFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanConfigurationArnFilters() ? scanConfigurationArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanNameFilters() ? scanNameFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanStatusFilters() ? scanStatusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledByFilters() ? scheduledByFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetAccountIdFilters() ? targetAccountIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceIdFilters() ? targetResourceIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceTagFilters() ? targetResourceTagFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScansFilterCriteria)) {
            return false;
        }
        ListCisScansFilterCriteria other = (ListCisScansFilterCriteria) obj;
        return hasFailedChecksFilters() == other.hasFailedChecksFilters()
                && Objects.equals(failedChecksFilters(), other.failedChecksFilters())
                && hasScanArnFilters() == other.hasScanArnFilters() && Objects.equals(scanArnFilters(), other.scanArnFilters())
                && hasScanAtFilters() == other.hasScanAtFilters() && Objects.equals(scanAtFilters(), other.scanAtFilters())
                && hasScanConfigurationArnFilters() == other.hasScanConfigurationArnFilters()
                && Objects.equals(scanConfigurationArnFilters(), other.scanConfigurationArnFilters())
                && hasScanNameFilters() == other.hasScanNameFilters()
                && Objects.equals(scanNameFilters(), other.scanNameFilters())
                && hasScanStatusFilters() == other.hasScanStatusFilters()
                && Objects.equals(scanStatusFilters(), other.scanStatusFilters())
                && hasScheduledByFilters() == other.hasScheduledByFilters()
                && Objects.equals(scheduledByFilters(), other.scheduledByFilters())
                && hasTargetAccountIdFilters() == other.hasTargetAccountIdFilters()
                && Objects.equals(targetAccountIdFilters(), other.targetAccountIdFilters())
                && hasTargetResourceIdFilters() == other.hasTargetResourceIdFilters()
                && Objects.equals(targetResourceIdFilters(), other.targetResourceIdFilters())
                && hasTargetResourceTagFilters() == other.hasTargetResourceTagFilters()
                && Objects.equals(targetResourceTagFilters(), other.targetResourceTagFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCisScansFilterCriteria")
                .add("FailedChecksFilters", hasFailedChecksFilters() ? failedChecksFilters() : null)
                .add("ScanArnFilters", hasScanArnFilters() ? scanArnFilters() : null)
                .add("ScanAtFilters", hasScanAtFilters() ? scanAtFilters() : null)
                .add("ScanConfigurationArnFilters", hasScanConfigurationArnFilters() ? scanConfigurationArnFilters() : null)
                .add("ScanNameFilters", hasScanNameFilters() ? scanNameFilters() : null)
                .add("ScanStatusFilters", hasScanStatusFilters() ? scanStatusFilters() : null)
                .add("ScheduledByFilters", hasScheduledByFilters() ? scheduledByFilters() : null)
                .add("TargetAccountIdFilters", hasTargetAccountIdFilters() ? targetAccountIdFilters() : null)
                .add("TargetResourceIdFilters", hasTargetResourceIdFilters() ? targetResourceIdFilters() : null)
                .add("TargetResourceTagFilters", hasTargetResourceTagFilters() ? targetResourceTagFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failedChecksFilters":
            return Optional.ofNullable(clazz.cast(failedChecksFilters()));
        case "scanArnFilters":
            return Optional.ofNullable(clazz.cast(scanArnFilters()));
        case "scanAtFilters":
            return Optional.ofNullable(clazz.cast(scanAtFilters()));
        case "scanConfigurationArnFilters":
            return Optional.ofNullable(clazz.cast(scanConfigurationArnFilters()));
        case "scanNameFilters":
            return Optional.ofNullable(clazz.cast(scanNameFilters()));
        case "scanStatusFilters":
            return Optional.ofNullable(clazz.cast(scanStatusFilters()));
        case "scheduledByFilters":
            return Optional.ofNullable(clazz.cast(scheduledByFilters()));
        case "targetAccountIdFilters":
            return Optional.ofNullable(clazz.cast(targetAccountIdFilters()));
        case "targetResourceIdFilters":
            return Optional.ofNullable(clazz.cast(targetResourceIdFilters()));
        case "targetResourceTagFilters":
            return Optional.ofNullable(clazz.cast(targetResourceTagFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCisScansFilterCriteria, T> g) {
        return obj -> g.apply((ListCisScansFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCisScansFilterCriteria> {
        /**
         * <p>
         * The list of failed checks filters.
         * </p>
         * 
         * @param failedChecksFilters
         *        The list of failed checks filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecksFilters(Collection<CisNumberFilter> failedChecksFilters);

        /**
         * <p>
         * The list of failed checks filters.
         * </p>
         * 
         * @param failedChecksFilters
         *        The list of failed checks filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecksFilters(CisNumberFilter... failedChecksFilters);

        /**
         * <p>
         * The list of failed checks filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #failedChecksFilters(List<CisNumberFilter>)}.
         * 
         * @param failedChecksFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedChecksFilters(java.util.Collection<CisNumberFilter>)
         */
        Builder failedChecksFilters(Consumer<CisNumberFilter.Builder>... failedChecksFilters);

        /**
         * <p>
         * The list of scan ARN filters.
         * </p>
         * 
         * @param scanArnFilters
         *        The list of scan ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArnFilters(Collection<CisStringFilter> scanArnFilters);

        /**
         * <p>
         * The list of scan ARN filters.
         * </p>
         * 
         * @param scanArnFilters
         *        The list of scan ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArnFilters(CisStringFilter... scanArnFilters);

        /**
         * <p>
         * The list of scan ARN filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanArnFilters(List<CisStringFilter>)}.
         * 
         * @param scanArnFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanArnFilters(java.util.Collection<CisStringFilter>)
         */
        Builder scanArnFilters(Consumer<CisStringFilter.Builder>... scanArnFilters);

        /**
         * <p>
         * The list of scan at filters.
         * </p>
         * 
         * @param scanAtFilters
         *        The list of scan at filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanAtFilters(Collection<CisDateFilter> scanAtFilters);

        /**
         * <p>
         * The list of scan at filters.
         * </p>
         * 
         * @param scanAtFilters
         *        The list of scan at filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanAtFilters(CisDateFilter... scanAtFilters);

        /**
         * <p>
         * The list of scan at filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisDateFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisDateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #scanAtFilters(List<CisDateFilter>)}.
         * 
         * @param scanAtFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanAtFilters(java.util.Collection<CisDateFilter>)
         */
        Builder scanAtFilters(Consumer<CisDateFilter.Builder>... scanAtFilters);

        /**
         * <p>
         * The list of scan configuration ARN filters.
         * </p>
         * 
         * @param scanConfigurationArnFilters
         *        The list of scan configuration ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArnFilters(Collection<CisStringFilter> scanConfigurationArnFilters);

        /**
         * <p>
         * The list of scan configuration ARN filters.
         * </p>
         * 
         * @param scanConfigurationArnFilters
         *        The list of scan configuration ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArnFilters(CisStringFilter... scanConfigurationArnFilters);

        /**
         * <p>
         * The list of scan configuration ARN filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanConfigurationArnFilters(List<CisStringFilter>)}.
         * 
         * @param scanConfigurationArnFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanConfigurationArnFilters(java.util.Collection<CisStringFilter>)
         */
        Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder>... scanConfigurationArnFilters);

        /**
         * <p>
         * The list of scan name filters.
         * </p>
         * 
         * @param scanNameFilters
         *        The list of scan name filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameFilters(Collection<CisStringFilter> scanNameFilters);

        /**
         * <p>
         * The list of scan name filters.
         * </p>
         * 
         * @param scanNameFilters
         *        The list of scan name filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameFilters(CisStringFilter... scanNameFilters);

        /**
         * <p>
         * The list of scan name filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanNameFilters(List<CisStringFilter>)}.
         * 
         * @param scanNameFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanNameFilters(java.util.Collection<CisStringFilter>)
         */
        Builder scanNameFilters(Consumer<CisStringFilter.Builder>... scanNameFilters);

        /**
         * <p>
         * The list of scan status filters.
         * </p>
         * 
         * @param scanStatusFilters
         *        The list of scan status filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatusFilters(Collection<CisScanStatusFilter> scanStatusFilters);

        /**
         * <p>
         * The list of scan status filters.
         * </p>
         * 
         * @param scanStatusFilters
         *        The list of scan status filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatusFilters(CisScanStatusFilter... scanStatusFilters);

        /**
         * <p>
         * The list of scan status filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanStatusFilters(List<CisScanStatusFilter>)}.
         * 
         * @param scanStatusFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanStatusFilters(java.util.Collection<CisScanStatusFilter>)
         */
        Builder scanStatusFilters(Consumer<CisScanStatusFilter.Builder>... scanStatusFilters);

        /**
         * <p>
         * The list of scheduled by filters.
         * </p>
         * 
         * @param scheduledByFilters
         *        The list of scheduled by filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledByFilters(Collection<CisStringFilter> scheduledByFilters);

        /**
         * <p>
         * The list of scheduled by filters.
         * </p>
         * 
         * @param scheduledByFilters
         *        The list of scheduled by filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledByFilters(CisStringFilter... scheduledByFilters);

        /**
         * <p>
         * The list of scheduled by filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduledByFilters(List<CisStringFilter>)}.
         * 
         * @param scheduledByFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledByFilters(java.util.Collection<CisStringFilter>)
         */
        Builder scheduledByFilters(Consumer<CisStringFilter.Builder>... scheduledByFilters);

        /**
         * <p>
         * The list of target account ID filters.
         * </p>
         * 
         * @param targetAccountIdFilters
         *        The list of target account ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountIdFilters(Collection<CisStringFilter> targetAccountIdFilters);

        /**
         * <p>
         * The list of target account ID filters.
         * </p>
         * 
         * @param targetAccountIdFilters
         *        The list of target account ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountIdFilters(CisStringFilter... targetAccountIdFilters);

        /**
         * <p>
         * The list of target account ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #targetAccountIdFilters(List<CisStringFilter>)}.
         * 
         * @param targetAccountIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetAccountIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder targetAccountIdFilters(Consumer<CisStringFilter.Builder>... targetAccountIdFilters);

        /**
         * <p>
         * The list of target resource ID filters.
         * </p>
         * 
         * @param targetResourceIdFilters
         *        The list of target resource ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceIdFilters(Collection<CisStringFilter> targetResourceIdFilters);

        /**
         * <p>
         * The list of target resource ID filters.
         * </p>
         * 
         * @param targetResourceIdFilters
         *        The list of target resource ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceIdFilters(CisStringFilter... targetResourceIdFilters);

        /**
         * <p>
         * The list of target resource ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #targetResourceIdFilters(List<CisStringFilter>)}.
         * 
         * @param targetResourceIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder>... targetResourceIdFilters);

        /**
         * <p>
         * The list of target resource tag filters.
         * </p>
         * 
         * @param targetResourceTagFilters
         *        The list of target resource tag filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters);

        /**
         * <p>
         * The list of target resource tag filters.
         * </p>
         * 
         * @param targetResourceTagFilters
         *        The list of target resource tag filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTagFilters(TagFilter... targetResourceTagFilters);

        /**
         * <p>
         * The list of target resource tag filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #targetResourceTagFilters(List<TagFilter>)}.
         * 
         * @param targetResourceTagFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceTagFilters(java.util.Collection<TagFilter>)
         */
        Builder targetResourceTagFilters(Consumer<TagFilter.Builder>... targetResourceTagFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<CisNumberFilter> failedChecksFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> scanArnFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisDateFilter> scanAtFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> scanConfigurationArnFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> scanNameFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisScanStatusFilter> scanStatusFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> scheduledByFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> targetAccountIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> targetResourceIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> targetResourceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScansFilterCriteria model) {
            failedChecksFilters(model.failedChecksFilters);
            scanArnFilters(model.scanArnFilters);
            scanAtFilters(model.scanAtFilters);
            scanConfigurationArnFilters(model.scanConfigurationArnFilters);
            scanNameFilters(model.scanNameFilters);
            scanStatusFilters(model.scanStatusFilters);
            scheduledByFilters(model.scheduledByFilters);
            targetAccountIdFilters(model.targetAccountIdFilters);
            targetResourceIdFilters(model.targetResourceIdFilters);
            targetResourceTagFilters(model.targetResourceTagFilters);
        }

        public final List<CisNumberFilter.Builder> getFailedChecksFilters() {
            List<CisNumberFilter.Builder> result = CisNumberFilterListCopier.copyToBuilder(this.failedChecksFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedChecksFilters(Collection<CisNumberFilter.BuilderImpl> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copyFromBuilder(failedChecksFilters);
        }

        @Override
        public final Builder failedChecksFilters(Collection<CisNumberFilter> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copy(failedChecksFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(CisNumberFilter... failedChecksFilters) {
            failedChecksFilters(Arrays.asList(failedChecksFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(Consumer<CisNumberFilter.Builder>... failedChecksFilters) {
            failedChecksFilters(Stream.of(failedChecksFilters).map(c -> CisNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanArnFilters() {
            List<CisStringFilter.Builder> result = CisScanArnFilterListCopier.copyToBuilder(this.scanArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanArnFilters(Collection<CisStringFilter.BuilderImpl> scanArnFilters) {
            this.scanArnFilters = CisScanArnFilterListCopier.copyFromBuilder(scanArnFilters);
        }

        @Override
        public final Builder scanArnFilters(Collection<CisStringFilter> scanArnFilters) {
            this.scanArnFilters = CisScanArnFilterListCopier.copy(scanArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanArnFilters(CisStringFilter... scanArnFilters) {
            scanArnFilters(Arrays.asList(scanArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanArnFilters(Consumer<CisStringFilter.Builder>... scanArnFilters) {
            scanArnFilters(Stream.of(scanArnFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisDateFilter.Builder> getScanAtFilters() {
            List<CisDateFilter.Builder> result = CisScanDateFilterListCopier.copyToBuilder(this.scanAtFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanAtFilters(Collection<CisDateFilter.BuilderImpl> scanAtFilters) {
            this.scanAtFilters = CisScanDateFilterListCopier.copyFromBuilder(scanAtFilters);
        }

        @Override
        public final Builder scanAtFilters(Collection<CisDateFilter> scanAtFilters) {
            this.scanAtFilters = CisScanDateFilterListCopier.copy(scanAtFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanAtFilters(CisDateFilter... scanAtFilters) {
            scanAtFilters(Arrays.asList(scanAtFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanAtFilters(Consumer<CisDateFilter.Builder>... scanAtFilters) {
            scanAtFilters(Stream.of(scanAtFilters).map(c -> CisDateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanConfigurationArnFilters() {
            List<CisStringFilter.Builder> result = CisScanConfigurationArnFilterListCopier
                    .copyToBuilder(this.scanConfigurationArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanConfigurationArnFilters(Collection<CisStringFilter.BuilderImpl> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier
                    .copyFromBuilder(scanConfigurationArnFilters);
        }

        @Override
        public final Builder scanConfigurationArnFilters(Collection<CisStringFilter> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier.copy(scanConfigurationArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(CisStringFilter... scanConfigurationArnFilters) {
            scanConfigurationArnFilters(Arrays.asList(scanConfigurationArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder>... scanConfigurationArnFilters) {
            scanConfigurationArnFilters(Stream.of(scanConfigurationArnFilters)
                    .map(c -> CisStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanNameFilters() {
            List<CisStringFilter.Builder> result = CisScanNameFilterListCopier.copyToBuilder(this.scanNameFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanNameFilters(Collection<CisStringFilter.BuilderImpl> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copyFromBuilder(scanNameFilters);
        }

        @Override
        public final Builder scanNameFilters(Collection<CisStringFilter> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copy(scanNameFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(CisStringFilter... scanNameFilters) {
            scanNameFilters(Arrays.asList(scanNameFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(Consumer<CisStringFilter.Builder>... scanNameFilters) {
            scanNameFilters(Stream.of(scanNameFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisScanStatusFilter.Builder> getScanStatusFilters() {
            List<CisScanStatusFilter.Builder> result = CisScanStatusFilterListCopier.copyToBuilder(this.scanStatusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanStatusFilters(Collection<CisScanStatusFilter.BuilderImpl> scanStatusFilters) {
            this.scanStatusFilters = CisScanStatusFilterListCopier.copyFromBuilder(scanStatusFilters);
        }

        @Override
        public final Builder scanStatusFilters(Collection<CisScanStatusFilter> scanStatusFilters) {
            this.scanStatusFilters = CisScanStatusFilterListCopier.copy(scanStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusFilters(CisScanStatusFilter... scanStatusFilters) {
            scanStatusFilters(Arrays.asList(scanStatusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusFilters(Consumer<CisScanStatusFilter.Builder>... scanStatusFilters) {
            scanStatusFilters(Stream.of(scanStatusFilters).map(c -> CisScanStatusFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScheduledByFilters() {
            List<CisStringFilter.Builder> result = CisScheduledByFilterListCopier.copyToBuilder(this.scheduledByFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledByFilters(Collection<CisStringFilter.BuilderImpl> scheduledByFilters) {
            this.scheduledByFilters = CisScheduledByFilterListCopier.copyFromBuilder(scheduledByFilters);
        }

        @Override
        public final Builder scheduledByFilters(Collection<CisStringFilter> scheduledByFilters) {
            this.scheduledByFilters = CisScheduledByFilterListCopier.copy(scheduledByFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledByFilters(CisStringFilter... scheduledByFilters) {
            scheduledByFilters(Arrays.asList(scheduledByFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledByFilters(Consumer<CisStringFilter.Builder>... scheduledByFilters) {
            scheduledByFilters(Stream.of(scheduledByFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTargetAccountIdFilters() {
            List<CisStringFilter.Builder> result = AccountIdFilterListCopier.copyToBuilder(this.targetAccountIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetAccountIdFilters(Collection<CisStringFilter.BuilderImpl> targetAccountIdFilters) {
            this.targetAccountIdFilters = AccountIdFilterListCopier.copyFromBuilder(targetAccountIdFilters);
        }

        @Override
        public final Builder targetAccountIdFilters(Collection<CisStringFilter> targetAccountIdFilters) {
            this.targetAccountIdFilters = AccountIdFilterListCopier.copy(targetAccountIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountIdFilters(CisStringFilter... targetAccountIdFilters) {
            targetAccountIdFilters(Arrays.asList(targetAccountIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountIdFilters(Consumer<CisStringFilter.Builder>... targetAccountIdFilters) {
            targetAccountIdFilters(Stream.of(targetAccountIdFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTargetResourceIdFilters() {
            List<CisStringFilter.Builder> result = ResourceIdFilterListCopier.copyToBuilder(this.targetResourceIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceIdFilters(Collection<CisStringFilter.BuilderImpl> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copyFromBuilder(targetResourceIdFilters);
        }

        @Override
        public final Builder targetResourceIdFilters(Collection<CisStringFilter> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copy(targetResourceIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(CisStringFilter... targetResourceIdFilters) {
            targetResourceIdFilters(Arrays.asList(targetResourceIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder>... targetResourceIdFilters) {
            targetResourceIdFilters(Stream.of(targetResourceIdFilters)
                    .map(c -> CisStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getTargetResourceTagFilters() {
            List<TagFilter.Builder> result = ResourceTagFilterListCopier.copyToBuilder(this.targetResourceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTagFilters(Collection<TagFilter.BuilderImpl> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copyFromBuilder(targetResourceTagFilters);
        }

        @Override
        public final Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copy(targetResourceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(TagFilter... targetResourceTagFilters) {
            targetResourceTagFilters(Arrays.asList(targetResourceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(Consumer<TagFilter.Builder>... targetResourceTagFilters) {
            targetResourceTagFilters(Stream.of(targetResourceTagFilters).map(c -> TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCisScansFilterCriteria build() {
            return new ListCisScansFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
