/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendCisSessionTelemetryRequest extends Inspector2Request implements
        ToCopyableBuilder<SendCisSessionTelemetryRequest.Builder, SendCisSessionTelemetryRequest> {
    private static final SdkField<List<CisSessionMessage>> MESSAGES_FIELD = SdkField
            .<List<CisSessionMessage>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(SendCisSessionTelemetryRequest::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisSessionMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisSessionMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanJobId").getter(getter(SendCisSessionTelemetryRequest::scanJobId)).setter(setter(Builder::scanJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanJobId").build()).build();

    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionToken").getter(getter(SendCisSessionTelemetryRequest::sessionToken))
            .setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD,
            SCAN_JOB_ID_FIELD, SESSION_TOKEN_FIELD));

    private final List<CisSessionMessage> messages;

    private final String scanJobId;

    private final String sessionToken;

    private SendCisSessionTelemetryRequest(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.scanJobId = builder.scanJobId;
        this.sessionToken = builder.sessionToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIS session telemetry messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return The CIS session telemetry messages.
     */
    public final List<CisSessionMessage> messages() {
        return messages;
    }

    /**
     * <p>
     * A unique identifier for the scan job.
     * </p>
     * 
     * @return A unique identifier for the scan job.
     */
    public final String scanJobId() {
        return scanJobId;
    }

    /**
     * <p>
     * The unique token that identifies the CIS session.
     * </p>
     * 
     * @return The unique token that identifies the CIS session.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCisSessionTelemetryRequest)) {
            return false;
        }
        SendCisSessionTelemetryRequest other = (SendCisSessionTelemetryRequest) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && Objects.equals(scanJobId(), other.scanJobId()) && Objects.equals(sessionToken(), other.sessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendCisSessionTelemetryRequest").add("Messages", hasMessages() ? messages() : null)
                .add("ScanJobId", scanJobId()).add("SessionToken", sessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "scanJobId":
            return Optional.ofNullable(clazz.cast(scanJobId()));
        case "sessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendCisSessionTelemetryRequest, T> g) {
        return obj -> g.apply((SendCisSessionTelemetryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, SendCisSessionTelemetryRequest> {
        /**
         * <p>
         * The CIS session telemetry messages.
         * </p>
         * 
         * @param messages
         *        The CIS session telemetry messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<CisSessionMessage> messages);

        /**
         * <p>
         * The CIS session telemetry messages.
         * </p>
         * 
         * @param messages
         *        The CIS session telemetry messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(CisSessionMessage... messages);

        /**
         * <p>
         * The CIS session telemetry messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisSessionMessage.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CisSessionMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisSessionMessage.Builder#build()} is called
         * immediately and its result is passed to {@link #messages(List<CisSessionMessage>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisSessionMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<CisSessionMessage>)
         */
        Builder messages(Consumer<CisSessionMessage.Builder>... messages);

        /**
         * <p>
         * A unique identifier for the scan job.
         * </p>
         * 
         * @param scanJobId
         *        A unique identifier for the scan job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobId(String scanJobId);

        /**
         * <p>
         * The unique token that identifies the CIS session.
         * </p>
         * 
         * @param sessionToken
         *        The unique token that identifies the CIS session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private List<CisSessionMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private String scanJobId;

        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCisSessionTelemetryRequest model) {
            super(model);
            messages(model.messages);
            scanJobId(model.scanJobId);
            sessionToken(model.sessionToken);
        }

        public final List<CisSessionMessage.Builder> getMessages() {
            List<CisSessionMessage.Builder> result = CisSessionMessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<CisSessionMessage.BuilderImpl> messages) {
            this.messages = CisSessionMessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<CisSessionMessage> messages) {
            this.messages = CisSessionMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(CisSessionMessage... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<CisSessionMessage.Builder>... messages) {
            messages(Stream.of(messages).map(c -> CisSessionMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getScanJobId() {
            return scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCisSessionTelemetryRequest build() {
            return new SendCisSessionTelemetryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
