/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCisScanResultsAggregatedByTargetResourceResponse extends Inspector2Response
        implements
        ToCopyableBuilder<ListCisScanResultsAggregatedByTargetResourceResponse.Builder, ListCisScanResultsAggregatedByTargetResourceResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCisScanResultsAggregatedByTargetResourceResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CisTargetResourceAggregation>> TARGET_RESOURCE_AGGREGATIONS_FIELD = SdkField
            .<List<CisTargetResourceAggregation>> builder(MarshallingType.LIST)
            .memberName("targetResourceAggregations")
            .getter(getter(ListCisScanResultsAggregatedByTargetResourceResponse::targetResourceAggregations))
            .setter(setter(Builder::targetResourceAggregations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceAggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisTargetResourceAggregation> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisTargetResourceAggregation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TARGET_RESOURCE_AGGREGATIONS_FIELD));

    private final String nextToken;

    private final List<CisTargetResourceAggregation> targetResourceAggregations;

    private ListCisScanResultsAggregatedByTargetResourceResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.targetResourceAggregations = builder.targetResourceAggregations;
    }

    /**
     * <p>
     * The pagination token from a previous request that's used to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token from a previous request that's used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceAggregations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetResourceAggregations() {
        return targetResourceAggregations != null && !(targetResourceAggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource aggregations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceAggregations} method.
     * </p>
     * 
     * @return The resource aggregations.
     */
    public final List<CisTargetResourceAggregation> targetResourceAggregations() {
        return targetResourceAggregations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceAggregations() ? targetResourceAggregations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScanResultsAggregatedByTargetResourceResponse)) {
            return false;
        }
        ListCisScanResultsAggregatedByTargetResourceResponse other = (ListCisScanResultsAggregatedByTargetResourceResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasTargetResourceAggregations() == other.hasTargetResourceAggregations()
                && Objects.equals(targetResourceAggregations(), other.targetResourceAggregations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCisScanResultsAggregatedByTargetResourceResponse").add("NextToken", nextToken())
                .add("TargetResourceAggregations", hasTargetResourceAggregations() ? targetResourceAggregations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "targetResourceAggregations":
            return Optional.ofNullable(clazz.cast(targetResourceAggregations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCisScanResultsAggregatedByTargetResourceResponse, T> g) {
        return obj -> g.apply((ListCisScanResultsAggregatedByTargetResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCisScanResultsAggregatedByTargetResourceResponse> {
        /**
         * <p>
         * The pagination token from a previous request that's used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from a previous request that's used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The resource aggregations.
         * </p>
         * 
         * @param targetResourceAggregations
         *        The resource aggregations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceAggregations(Collection<CisTargetResourceAggregation> targetResourceAggregations);

        /**
         * <p>
         * The resource aggregations.
         * </p>
         * 
         * @param targetResourceAggregations
         *        The resource aggregations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceAggregations(CisTargetResourceAggregation... targetResourceAggregations);

        /**
         * <p>
         * The resource aggregations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #targetResourceAggregations(List<CisTargetResourceAggregation>)}.
         * 
         * @param targetResourceAggregations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceAggregations(java.util.Collection<CisTargetResourceAggregation>)
         */
        Builder targetResourceAggregations(Consumer<CisTargetResourceAggregation.Builder>... targetResourceAggregations);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CisTargetResourceAggregation> targetResourceAggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScanResultsAggregatedByTargetResourceResponse model) {
            super(model);
            nextToken(model.nextToken);
            targetResourceAggregations(model.targetResourceAggregations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CisTargetResourceAggregation.Builder> getTargetResourceAggregations() {
            List<CisTargetResourceAggregation.Builder> result = CisTargetResourceAggregationListCopier
                    .copyToBuilder(this.targetResourceAggregations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceAggregations(
                Collection<CisTargetResourceAggregation.BuilderImpl> targetResourceAggregations) {
            this.targetResourceAggregations = CisTargetResourceAggregationListCopier.copyFromBuilder(targetResourceAggregations);
        }

        @Override
        public final Builder targetResourceAggregations(Collection<CisTargetResourceAggregation> targetResourceAggregations) {
            this.targetResourceAggregations = CisTargetResourceAggregationListCopier.copy(targetResourceAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceAggregations(CisTargetResourceAggregation... targetResourceAggregations) {
            targetResourceAggregations(Arrays.asList(targetResourceAggregations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceAggregations(
                Consumer<CisTargetResourceAggregation.Builder>... targetResourceAggregations) {
            targetResourceAggregations(Stream.of(targetResourceAggregations)
                    .map(c -> CisTargetResourceAggregation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCisScanResultsAggregatedByTargetResourceResponse build() {
            return new ListCisScanResultsAggregatedByTargetResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
