/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details the status of Amazon Inspector for each resource type Amazon Inspector scans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceStatus implements SdkPojo, Serializable, ToCopyableBuilder<ResourceStatus.Builder, ResourceStatus> {
    private static final SdkField<String> EC2_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ec2")
            .getter(getter(ResourceStatus::ec2AsString)).setter(setter(Builder::ec2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()).build();

    private static final SdkField<String> ECR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ecr")
            .getter(getter(ResourceStatus::ecrAsString)).setter(setter(Builder::ecr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()).build();

    private static final SdkField<String> LAMBDA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lambda")
            .getter(getter(ResourceStatus::lambdaAsString)).setter(setter(Builder::lambda))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final SdkField<String> LAMBDA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaCode").getter(getter(ResourceStatus::lambdaCodeAsString)).setter(setter(Builder::lambdaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_FIELD,
            LAMBDA_FIELD, LAMBDA_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ec2;

    private final String ecr;

    private final String lambda;

    private final String lambdaCode;

    private ResourceStatus(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
        this.lambda = builder.lambda;
        this.lambdaCode = builder.lambdaCode;
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for Amazon EC2 resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2} will return
     * {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ec2AsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for Amazon EC2 resources.
     * @see Status
     */
    public final Status ec2() {
        return Status.fromValue(ec2);
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for Amazon EC2 resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2} will return
     * {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ec2AsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for Amazon EC2 resources.
     * @see Status
     */
    public final String ec2AsString() {
        return ec2;
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for Amazon ECR resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ecr} will return
     * {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ecrAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for Amazon ECR resources.
     * @see Status
     */
    public final Status ecr() {
        return Status.fromValue(ecr);
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for Amazon ECR resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ecr} will return
     * {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ecrAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for Amazon ECR resources.
     * @see Status
     */
    public final String ecrAsString() {
        return ecr;
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lambda} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lambdaAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
     * @see Status
     */
    public final Status lambda() {
        return Status.fromValue(lambda);
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lambda} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lambdaAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
     * @see Status
     */
    public final String lambdaAsString() {
        return lambda;
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lambdaCode} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lambdaCodeAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda
     *         functions.
     * @see Status
     */
    public final Status lambdaCode() {
        return Status.fromValue(lambdaCode);
    }

    /**
     * <p>
     * The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lambdaCode} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lambdaCodeAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda
     *         functions.
     * @see Status
     */
    public final String lambdaCodeAsString() {
        return lambdaCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2AsString());
        hashCode = 31 * hashCode + Objects.hashCode(ecrAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatus)) {
            return false;
        }
        ResourceStatus other = (ResourceStatus) obj;
        return Objects.equals(ec2AsString(), other.ec2AsString()) && Objects.equals(ecrAsString(), other.ecrAsString())
                && Objects.equals(lambdaAsString(), other.lambdaAsString())
                && Objects.equals(lambdaCodeAsString(), other.lambdaCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceStatus").add("Ec2", ec2AsString()).add("Ecr", ecrAsString())
                .add("Lambda", lambdaAsString()).add("LambdaCode", lambdaCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2":
            return Optional.ofNullable(clazz.cast(ec2AsString()));
        case "ecr":
            return Optional.ofNullable(clazz.cast(ecrAsString()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambdaAsString()));
        case "lambdaCode":
            return Optional.ofNullable(clazz.cast(lambdaCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatus, T> g) {
        return obj -> g.apply((ResourceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceStatus> {
        /**
         * <p>
         * The status of Amazon Inspector scanning for Amazon EC2 resources.
         * </p>
         * 
         * @param ec2
         *        The status of Amazon Inspector scanning for Amazon EC2 resources.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder ec2(String ec2);

        /**
         * <p>
         * The status of Amazon Inspector scanning for Amazon EC2 resources.
         * </p>
         * 
         * @param ec2
         *        The status of Amazon Inspector scanning for Amazon EC2 resources.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder ec2(Status ec2);

        /**
         * <p>
         * The status of Amazon Inspector scanning for Amazon ECR resources.
         * </p>
         * 
         * @param ecr
         *        The status of Amazon Inspector scanning for Amazon ECR resources.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder ecr(String ecr);

        /**
         * <p>
         * The status of Amazon Inspector scanning for Amazon ECR resources.
         * </p>
         * 
         * @param ecr
         *        The status of Amazon Inspector scanning for Amazon ECR resources.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder ecr(Status ecr);

        /**
         * <p>
         * The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
         * </p>
         * 
         * @param lambda
         *        The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder lambda(String lambda);

        /**
         * <p>
         * The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
         * </p>
         * 
         * @param lambda
         *        The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder lambda(Status lambda);

        /**
         * <p>
         * The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions.
         * </p>
         * 
         * @param lambdaCode
         *        The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda
         *        functions.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder lambdaCode(String lambdaCode);

        /**
         * <p>
         * The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions.
         * </p>
         * 
         * @param lambdaCode
         *        The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda
         *        functions.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder lambdaCode(Status lambdaCode);
    }

    static final class BuilderImpl implements Builder {
        private String ec2;

        private String ecr;

        private String lambda;

        private String lambdaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatus model) {
            ec2(model.ec2);
            ecr(model.ecr);
            lambda(model.lambda);
            lambdaCode(model.lambdaCode);
        }

        public final String getEc2() {
            return ec2;
        }

        public final void setEc2(String ec2) {
            this.ec2 = ec2;
        }

        @Override
        public final Builder ec2(String ec2) {
            this.ec2 = ec2;
            return this;
        }

        @Override
        public final Builder ec2(Status ec2) {
            this.ec2(ec2 == null ? null : ec2.toString());
            return this;
        }

        public final String getEcr() {
            return ecr;
        }

        public final void setEcr(String ecr) {
            this.ecr = ecr;
        }

        @Override
        public final Builder ecr(String ecr) {
            this.ecr = ecr;
            return this;
        }

        @Override
        public final Builder ecr(Status ecr) {
            this.ecr(ecr == null ? null : ecr.toString());
            return this;
        }

        public final String getLambda() {
            return lambda;
        }

        public final void setLambda(String lambda) {
            this.lambda = lambda;
        }

        @Override
        public final Builder lambda(String lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public final Builder lambda(Status lambda) {
            this.lambda(lambda == null ? null : lambda.toString());
            return this;
        }

        public final String getLambdaCode() {
            return lambdaCode;
        }

        public final void setLambdaCode(String lambdaCode) {
            this.lambdaCode = lambdaCode;
        }

        @Override
        public final Builder lambdaCode(String lambdaCode) {
            this.lambdaCode = lambdaCode;
            return this;
        }

        @Override
        public final Builder lambdaCode(Status lambdaCode) {
            this.lambdaCode(lambdaCode == null ? null : lambdaCode.toString());
            return this;
        }

        @Override
        public ResourceStatus build() {
            return new ResourceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
