/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCisSessionRequest extends Inspector2Request implements
        ToCopyableBuilder<StartCisSessionRequest.Builder, StartCisSessionRequest> {
    private static final SdkField<StartCisSessionMessage> MESSAGE_FIELD = SdkField
            .<StartCisSessionMessage> builder(MarshallingType.SDK_POJO).memberName("message")
            .getter(getter(StartCisSessionRequest::message)).setter(setter(Builder::message))
            .constructor(StartCisSessionMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanJobId").getter(getter(StartCisSessionRequest::scanJobId)).setter(setter(Builder::scanJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            SCAN_JOB_ID_FIELD));

    private final StartCisSessionMessage message;

    private final String scanJobId;

    private StartCisSessionRequest(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.scanJobId = builder.scanJobId;
    }

    /**
     * <p>
     * The start CIS session message.
     * </p>
     * 
     * @return The start CIS session message.
     */
    public final StartCisSessionMessage message() {
        return message;
    }

    /**
     * <p>
     * A unique identifier for the scan job.
     * </p>
     * 
     * @return A unique identifier for the scan job.
     */
    public final String scanJobId() {
        return scanJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(scanJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCisSessionRequest)) {
            return false;
        }
        StartCisSessionRequest other = (StartCisSessionRequest) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(scanJobId(), other.scanJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCisSessionRequest").add("Message", message()).add("ScanJobId", scanJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "scanJobId":
            return Optional.ofNullable(clazz.cast(scanJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCisSessionRequest, T> g) {
        return obj -> g.apply((StartCisSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartCisSessionRequest> {
        /**
         * <p>
         * The start CIS session message.
         * </p>
         * 
         * @param message
         *        The start CIS session message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(StartCisSessionMessage message);

        /**
         * <p>
         * The start CIS session message.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartCisSessionMessage.Builder} avoiding
         * the need to create one manually via {@link StartCisSessionMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartCisSessionMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #message(StartCisSessionMessage)}.
         * 
         * @param message
         *        a consumer that will call methods on {@link StartCisSessionMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #message(StartCisSessionMessage)
         */
        default Builder message(Consumer<StartCisSessionMessage.Builder> message) {
            return message(StartCisSessionMessage.builder().applyMutation(message).build());
        }

        /**
         * <p>
         * A unique identifier for the scan job.
         * </p>
         * 
         * @param scanJobId
         *        A unique identifier for the scan job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobId(String scanJobId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private StartCisSessionMessage message;

        private String scanJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCisSessionRequest model) {
            super(model);
            message(model.message);
            scanJobId(model.scanJobId);
        }

        public final StartCisSessionMessage.Builder getMessage() {
            return message != null ? message.toBuilder() : null;
        }

        public final void setMessage(StartCisSessionMessage.BuilderImpl message) {
            this.message = message != null ? message.build() : null;
        }

        @Override
        public final Builder message(StartCisSessionMessage message) {
            this.message = message;
            return this;
        }

        public final String getScanJobId() {
            return scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCisSessionRequest build() {
            return new StartCisSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
