/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Time implements SdkPojo, Serializable, ToCopyableBuilder<Time.Builder, Time> {
    private static final SdkField<String> TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeOfDay").getter(getter(Time::timeOfDay)).setter(setter(Builder::timeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOfDay").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(Time::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_OF_DAY_FIELD,
            TIMEZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeOfDay;

    private final String timezone;

    private Time(BuilderImpl builder) {
        this.timeOfDay = builder.timeOfDay;
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The time of day in 24-hour format (00:00).
     * </p>
     * 
     * @return The time of day in 24-hour format (00:00).
     */
    public final String timeOfDay() {
        return timeOfDay;
    }

    /**
     * <p>
     * The timezone.
     * </p>
     * 
     * @return The timezone.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        Time other = (Time) obj;
        return Objects.equals(timeOfDay(), other.timeOfDay()) && Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Time").add("TimeOfDay", timeOfDay()).add("Timezone", timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeOfDay":
            return Optional.ofNullable(clazz.cast(timeOfDay()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Time, T> g) {
        return obj -> g.apply((Time) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Time> {
        /**
         * <p>
         * The time of day in 24-hour format (00:00).
         * </p>
         * 
         * @param timeOfDay
         *        The time of day in 24-hour format (00:00).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfDay(String timeOfDay);

        /**
         * <p>
         * The timezone.
         * </p>
         * 
         * @param timezone
         *        The timezone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl implements Builder {
        private String timeOfDay;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(Time model) {
            timeOfDay(model.timeOfDay);
            timezone(model.timezone);
        }

        public final String getTimeOfDay() {
            return timeOfDay;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public Time build() {
            return new Time(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
