/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS session message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisSessionMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<CisSessionMessage.Builder, CisSessionMessage> {
    private static final SdkField<SdkBytes> CIS_RULE_DETAILS_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("cisRuleDetails").getter(getter(CisSessionMessage::cisRuleDetails))
            .setter(setter(Builder::cisRuleDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cisRuleDetails").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(CisSessionMessage::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CisSessionMessage::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIS_RULE_DETAILS_FIELD,
            RULE_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes cisRuleDetails;

    private final String ruleId;

    private final String status;

    private CisSessionMessage(BuilderImpl builder) {
        this.cisRuleDetails = builder.cisRuleDetails;
        this.ruleId = builder.ruleId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The CIS rule details for the CIS session message.
     * </p>
     * 
     * @return The CIS rule details for the CIS session message.
     */
    public final SdkBytes cisRuleDetails() {
        return cisRuleDetails;
    }

    /**
     * <p>
     * The rule ID for the CIS session message.
     * </p>
     * 
     * @return The rule ID for the CIS session message.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The status of the CIS session message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CisRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the CIS session message.
     * @see CisRuleStatus
     */
    public final CisRuleStatus status() {
        return CisRuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the CIS session message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CisRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the CIS session message.
     * @see CisRuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cisRuleDetails());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisSessionMessage)) {
            return false;
        }
        CisSessionMessage other = (CisSessionMessage) obj;
        return Objects.equals(cisRuleDetails(), other.cisRuleDetails()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisSessionMessage").add("CisRuleDetails", cisRuleDetails()).add("RuleId", ruleId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cisRuleDetails":
            return Optional.ofNullable(clazz.cast(cisRuleDetails()));
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CisSessionMessage, T> g) {
        return obj -> g.apply((CisSessionMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisSessionMessage> {
        /**
         * <p>
         * The CIS rule details for the CIS session message.
         * </p>
         * 
         * @param cisRuleDetails
         *        The CIS rule details for the CIS session message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cisRuleDetails(SdkBytes cisRuleDetails);

        /**
         * <p>
         * The rule ID for the CIS session message.
         * </p>
         * 
         * @param ruleId
         *        The rule ID for the CIS session message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The status of the CIS session message.
         * </p>
         * 
         * @param status
         *        The status of the CIS session message.
         * @see CisRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisRuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the CIS session message.
         * </p>
         * 
         * @param status
         *        The status of the CIS session message.
         * @see CisRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisRuleStatus
         */
        Builder status(CisRuleStatus status);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes cisRuleDetails;

        private String ruleId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CisSessionMessage model) {
            cisRuleDetails(model.cisRuleDetails);
            ruleId(model.ruleId);
            status(model.status);
        }

        public final ByteBuffer getCisRuleDetails() {
            return cisRuleDetails == null ? null : cisRuleDetails.asByteBuffer();
        }

        public final void setCisRuleDetails(ByteBuffer cisRuleDetails) {
            cisRuleDetails(cisRuleDetails == null ? null : SdkBytes.fromByteBuffer(cisRuleDetails));
        }

        @Override
        public final Builder cisRuleDetails(SdkBytes cisRuleDetails) {
            this.cisRuleDetails = cisRuleDetails;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CisRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CisSessionMessage build() {
            return new CisSessionMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
