/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<DailySchedule> DAILY_FIELD = SdkField.<DailySchedule> builder(MarshallingType.SDK_POJO)
            .memberName("daily").getter(getter(Schedule::daily)).setter(setter(Builder::daily))
            .constructor(DailySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("daily").build()).build();

    private static final SdkField<MonthlySchedule> MONTHLY_FIELD = SdkField.<MonthlySchedule> builder(MarshallingType.SDK_POJO)
            .memberName("monthly").getter(getter(Schedule::monthly)).setter(setter(Builder::monthly))
            .constructor(MonthlySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthly").build()).build();

    private static final SdkField<OneTimeSchedule> ONE_TIME_FIELD = SdkField.<OneTimeSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("oneTime").getter(getter(Schedule::oneTime)).setter(setter(Builder::oneTime))
            .constructor(OneTimeSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oneTime").build()).build();

    private static final SdkField<WeeklySchedule> WEEKLY_FIELD = SdkField.<WeeklySchedule> builder(MarshallingType.SDK_POJO)
            .memberName("weekly").getter(getter(Schedule::weekly)).setter(setter(Builder::weekly))
            .constructor(WeeklySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weekly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_FIELD, MONTHLY_FIELD,
            ONE_TIME_FIELD, WEEKLY_FIELD));

    private static final long serialVersionUID = 1L;

    private final DailySchedule daily;

    private final MonthlySchedule monthly;

    private final OneTimeSchedule oneTime;

    private final WeeklySchedule weekly;

    private final Type type;

    private Schedule(BuilderImpl builder) {
        this.daily = builder.daily;
        this.monthly = builder.monthly;
        this.oneTime = builder.oneTime;
        this.weekly = builder.weekly;
        this.type = builder.type;
    }

    /**
     * <p>
     * The schedule's daily.
     * </p>
     * 
     * @return The schedule's daily.
     */
    public final DailySchedule daily() {
        return daily;
    }

    /**
     * <p>
     * The schedule's monthly.
     * </p>
     * 
     * @return The schedule's monthly.
     */
    public final MonthlySchedule monthly() {
        return monthly;
    }

    /**
     * <p>
     * The schedule's one time.
     * </p>
     * 
     * @return The schedule's one time.
     */
    public final OneTimeSchedule oneTime() {
        return oneTime;
    }

    /**
     * <p>
     * The schedule's weekly.
     * </p>
     * 
     * @return The schedule's weekly.
     */
    public final WeeklySchedule weekly() {
        return weekly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(daily());
        hashCode = 31 * hashCode + Objects.hashCode(monthly());
        hashCode = 31 * hashCode + Objects.hashCode(oneTime());
        hashCode = 31 * hashCode + Objects.hashCode(weekly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(daily(), other.daily()) && Objects.equals(monthly(), other.monthly())
                && Objects.equals(oneTime(), other.oneTime()) && Objects.equals(weekly(), other.weekly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Schedule").add("Daily", daily()).add("Monthly", monthly()).add("OneTime", oneTime())
                .add("Weekly", weekly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "daily":
            return Optional.ofNullable(clazz.cast(daily()));
        case "monthly":
            return Optional.ofNullable(clazz.cast(monthly()));
        case "oneTime":
            return Optional.ofNullable(clazz.cast(oneTime()));
        case "weekly":
            return Optional.ofNullable(clazz.cast(weekly()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #daily()} initialized to the given value.
     *
     * <p>
     * The schedule's daily.
     * </p>
     * 
     * @param daily
     *        The schedule's daily.
     */
    public static Schedule fromDaily(DailySchedule daily) {
        return builder().daily(daily).build();
    }

    /**
     * Create an instance of this class with {@link #daily()} initialized to the given value.
     *
     * <p>
     * The schedule's daily.
     * </p>
     * 
     * @param daily
     *        The schedule's daily.
     */
    public static Schedule fromDaily(Consumer<DailySchedule.Builder> daily) {
        DailySchedule.Builder builder = DailySchedule.builder();
        daily.accept(builder);
        return fromDaily(builder.build());
    }

    /**
     * Create an instance of this class with {@link #monthly()} initialized to the given value.
     *
     * <p>
     * The schedule's monthly.
     * </p>
     * 
     * @param monthly
     *        The schedule's monthly.
     */
    public static Schedule fromMonthly(MonthlySchedule monthly) {
        return builder().monthly(monthly).build();
    }

    /**
     * Create an instance of this class with {@link #monthly()} initialized to the given value.
     *
     * <p>
     * The schedule's monthly.
     * </p>
     * 
     * @param monthly
     *        The schedule's monthly.
     */
    public static Schedule fromMonthly(Consumer<MonthlySchedule.Builder> monthly) {
        MonthlySchedule.Builder builder = MonthlySchedule.builder();
        monthly.accept(builder);
        return fromMonthly(builder.build());
    }

    /**
     * Create an instance of this class with {@link #oneTime()} initialized to the given value.
     *
     * <p>
     * The schedule's one time.
     * </p>
     * 
     * @param oneTime
     *        The schedule's one time.
     */
    public static Schedule fromOneTime(OneTimeSchedule oneTime) {
        return builder().oneTime(oneTime).build();
    }

    /**
     * Create an instance of this class with {@link #oneTime()} initialized to the given value.
     *
     * <p>
     * The schedule's one time.
     * </p>
     * 
     * @param oneTime
     *        The schedule's one time.
     */
    public static Schedule fromOneTime(Consumer<OneTimeSchedule.Builder> oneTime) {
        OneTimeSchedule.Builder builder = OneTimeSchedule.builder();
        oneTime.accept(builder);
        return fromOneTime(builder.build());
    }

    /**
     * Create an instance of this class with {@link #weekly()} initialized to the given value.
     *
     * <p>
     * The schedule's weekly.
     * </p>
     * 
     * @param weekly
     *        The schedule's weekly.
     */
    public static Schedule fromWeekly(WeeklySchedule weekly) {
        return builder().weekly(weekly).build();
    }

    /**
     * Create an instance of this class with {@link #weekly()} initialized to the given value.
     *
     * <p>
     * The schedule's weekly.
     * </p>
     * 
     * @param weekly
     *        The schedule's weekly.
     */
    public static Schedule fromWeekly(Consumer<WeeklySchedule.Builder> weekly) {
        WeeklySchedule.Builder builder = WeeklySchedule.builder();
        weekly.accept(builder);
        return fromWeekly(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The schedule's daily.
         * </p>
         * 
         * @param daily
         *        The schedule's daily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daily(DailySchedule daily);

        /**
         * <p>
         * The schedule's daily.
         * </p>
         * This is a convenience method that creates an instance of the {@link DailySchedule.Builder} avoiding the need
         * to create one manually via {@link DailySchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DailySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #daily(DailySchedule)}.
         * 
         * @param daily
         *        a consumer that will call methods on {@link DailySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #daily(DailySchedule)
         */
        default Builder daily(Consumer<DailySchedule.Builder> daily) {
            return daily(DailySchedule.builder().applyMutation(daily).build());
        }

        /**
         * <p>
         * The schedule's monthly.
         * </p>
         * 
         * @param monthly
         *        The schedule's monthly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthly(MonthlySchedule monthly);

        /**
         * <p>
         * The schedule's monthly.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonthlySchedule.Builder} avoiding the
         * need to create one manually via {@link MonthlySchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonthlySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #monthly(MonthlySchedule)}.
         * 
         * @param monthly
         *        a consumer that will call methods on {@link MonthlySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monthly(MonthlySchedule)
         */
        default Builder monthly(Consumer<MonthlySchedule.Builder> monthly) {
            return monthly(MonthlySchedule.builder().applyMutation(monthly).build());
        }

        /**
         * <p>
         * The schedule's one time.
         * </p>
         * 
         * @param oneTime
         *        The schedule's one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneTime(OneTimeSchedule oneTime);

        /**
         * <p>
         * The schedule's one time.
         * </p>
         * This is a convenience method that creates an instance of the {@link OneTimeSchedule.Builder} avoiding the
         * need to create one manually via {@link OneTimeSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OneTimeSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #oneTime(OneTimeSchedule)}.
         * 
         * @param oneTime
         *        a consumer that will call methods on {@link OneTimeSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oneTime(OneTimeSchedule)
         */
        default Builder oneTime(Consumer<OneTimeSchedule.Builder> oneTime) {
            return oneTime(OneTimeSchedule.builder().applyMutation(oneTime).build());
        }

        /**
         * <p>
         * The schedule's weekly.
         * </p>
         * 
         * @param weekly
         *        The schedule's weekly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weekly(WeeklySchedule weekly);

        /**
         * <p>
         * The schedule's weekly.
         * </p>
         * This is a convenience method that creates an instance of the {@link WeeklySchedule.Builder} avoiding the need
         * to create one manually via {@link WeeklySchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WeeklySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #weekly(WeeklySchedule)}.
         * 
         * @param weekly
         *        a consumer that will call methods on {@link WeeklySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weekly(WeeklySchedule)
         */
        default Builder weekly(Consumer<WeeklySchedule.Builder> weekly) {
            return weekly(WeeklySchedule.builder().applyMutation(weekly).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DailySchedule daily;

        private MonthlySchedule monthly;

        private OneTimeSchedule oneTime;

        private WeeklySchedule weekly;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            daily(model.daily);
            monthly(model.monthly);
            oneTime(model.oneTime);
            weekly(model.weekly);
        }

        public final DailySchedule.Builder getDaily() {
            return daily != null ? daily.toBuilder() : null;
        }

        public final void setDaily(DailySchedule.BuilderImpl daily) {
            Object oldValue = this.daily;
            this.daily = daily != null ? daily.build() : null;
            handleUnionValueChange(Type.DAILY, oldValue, this.daily);
        }

        @Override
        public final Builder daily(DailySchedule daily) {
            Object oldValue = this.daily;
            this.daily = daily;
            handleUnionValueChange(Type.DAILY, oldValue, this.daily);
            return this;
        }

        public final MonthlySchedule.Builder getMonthly() {
            return monthly != null ? monthly.toBuilder() : null;
        }

        public final void setMonthly(MonthlySchedule.BuilderImpl monthly) {
            Object oldValue = this.monthly;
            this.monthly = monthly != null ? monthly.build() : null;
            handleUnionValueChange(Type.MONTHLY, oldValue, this.monthly);
        }

        @Override
        public final Builder monthly(MonthlySchedule monthly) {
            Object oldValue = this.monthly;
            this.monthly = monthly;
            handleUnionValueChange(Type.MONTHLY, oldValue, this.monthly);
            return this;
        }

        public final OneTimeSchedule.Builder getOneTime() {
            return oneTime != null ? oneTime.toBuilder() : null;
        }

        public final void setOneTime(OneTimeSchedule.BuilderImpl oneTime) {
            Object oldValue = this.oneTime;
            this.oneTime = oneTime != null ? oneTime.build() : null;
            handleUnionValueChange(Type.ONE_TIME, oldValue, this.oneTime);
        }

        @Override
        public final Builder oneTime(OneTimeSchedule oneTime) {
            Object oldValue = this.oneTime;
            this.oneTime = oneTime;
            handleUnionValueChange(Type.ONE_TIME, oldValue, this.oneTime);
            return this;
        }

        public final WeeklySchedule.Builder getWeekly() {
            return weekly != null ? weekly.toBuilder() : null;
        }

        public final void setWeekly(WeeklySchedule.BuilderImpl weekly) {
            Object oldValue = this.weekly;
            this.weekly = weekly != null ? weekly.build() : null;
            handleUnionValueChange(Type.WEEKLY, oldValue, this.weekly);
        }

        @Override
        public final Builder weekly(WeeklySchedule weekly) {
            Object oldValue = this.weekly;
            this.weekly = weekly;
            handleUnionValueChange(Type.WEEKLY, oldValue, this.weekly);
            return this;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Schedule#type()
     */
    public enum Type {
        DAILY,

        MONTHLY,

        ONE_TIME,

        WEEKLY,

        UNKNOWN_TO_SDK_VERSION
    }
}
