/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables agent-based scanning, which scans instances that are not managed by SSM.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2Configuration implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2Configuration.Builder, Ec2Configuration> {
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanMode").getter(getter(Ec2Configuration::scanModeAsString)).setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scanMode;

    private Ec2Configuration(BuilderImpl builder) {
        this.scanMode = builder.scanMode;
    }

    /**
     * <p>
     * The scan method that is applied to the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link Ec2ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The scan method that is applied to the instance.
     * @see Ec2ScanMode
     */
    public final Ec2ScanMode scanMode() {
        return Ec2ScanMode.fromValue(scanMode);
    }

    /**
     * <p>
     * The scan method that is applied to the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link Ec2ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The scan method that is applied to the instance.
     * @see Ec2ScanMode
     */
    public final String scanModeAsString() {
        return scanMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Configuration)) {
            return false;
        }
        Ec2Configuration other = (Ec2Configuration) obj;
        return Objects.equals(scanModeAsString(), other.scanModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2Configuration").add("ScanMode", scanModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanMode":
            return Optional.ofNullable(clazz.cast(scanModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2Configuration, T> g) {
        return obj -> g.apply((Ec2Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2Configuration> {
        /**
         * <p>
         * The scan method that is applied to the instance.
         * </p>
         * 
         * @param scanMode
         *        The scan method that is applied to the instance.
         * @see Ec2ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2ScanMode
         */
        Builder scanMode(String scanMode);

        /**
         * <p>
         * The scan method that is applied to the instance.
         * </p>
         * 
         * @param scanMode
         *        The scan method that is applied to the instance.
         * @see Ec2ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2ScanMode
         */
        Builder scanMode(Ec2ScanMode scanMode);
    }

    static final class BuilderImpl implements Builder {
        private String scanMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Configuration model) {
            scanMode(model.scanMode);
        }

        public final String getScanMode() {
            return scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(Ec2ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        @Override
        public Ec2Configuration build() {
            return new Ec2Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
