/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of your Amazon EC2 scan mode configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2ScanModeState implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2ScanModeState.Builder, Ec2ScanModeState> {
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanMode").getter(getter(Ec2ScanModeState::scanModeAsString)).setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build()).build();

    private static final SdkField<String> SCAN_MODE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanModeStatus").getter(getter(Ec2ScanModeState::scanModeStatusAsString))
            .setter(setter(Builder::scanModeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanModeStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_MODE_FIELD,
            SCAN_MODE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scanMode;

    private final String scanModeStatus;

    private Ec2ScanModeState(BuilderImpl builder) {
        this.scanMode = builder.scanMode;
        this.scanModeStatus = builder.scanModeStatus;
    }

    /**
     * <p>
     * The scan method that is applied to the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link Ec2ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The scan method that is applied to the instance.
     * @see Ec2ScanMode
     */
    public final Ec2ScanMode scanMode() {
        return Ec2ScanMode.fromValue(scanMode);
    }

    /**
     * <p>
     * The scan method that is applied to the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link Ec2ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The scan method that is applied to the instance.
     * @see Ec2ScanMode
     */
    public final String scanModeAsString() {
        return scanMode;
    }

    /**
     * <p>
     * The status of the Amazon EC2 scan mode setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanModeStatus}
     * will return {@link Ec2ScanModeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanModeStatusAsString}.
     * </p>
     * 
     * @return The status of the Amazon EC2 scan mode setting.
     * @see Ec2ScanModeStatus
     */
    public final Ec2ScanModeStatus scanModeStatus() {
        return Ec2ScanModeStatus.fromValue(scanModeStatus);
    }

    /**
     * <p>
     * The status of the Amazon EC2 scan mode setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanModeStatus}
     * will return {@link Ec2ScanModeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanModeStatusAsString}.
     * </p>
     * 
     * @return The status of the Amazon EC2 scan mode setting.
     * @see Ec2ScanModeStatus
     */
    public final String scanModeStatusAsString() {
        return scanModeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanModeStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2ScanModeState)) {
            return false;
        }
        Ec2ScanModeState other = (Ec2ScanModeState) obj;
        return Objects.equals(scanModeAsString(), other.scanModeAsString())
                && Objects.equals(scanModeStatusAsString(), other.scanModeStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2ScanModeState").add("ScanMode", scanModeAsString())
                .add("ScanModeStatus", scanModeStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanMode":
            return Optional.ofNullable(clazz.cast(scanModeAsString()));
        case "scanModeStatus":
            return Optional.ofNullable(clazz.cast(scanModeStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2ScanModeState, T> g) {
        return obj -> g.apply((Ec2ScanModeState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2ScanModeState> {
        /**
         * <p>
         * The scan method that is applied to the instance.
         * </p>
         * 
         * @param scanMode
         *        The scan method that is applied to the instance.
         * @see Ec2ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2ScanMode
         */
        Builder scanMode(String scanMode);

        /**
         * <p>
         * The scan method that is applied to the instance.
         * </p>
         * 
         * @param scanMode
         *        The scan method that is applied to the instance.
         * @see Ec2ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2ScanMode
         */
        Builder scanMode(Ec2ScanMode scanMode);

        /**
         * <p>
         * The status of the Amazon EC2 scan mode setting.
         * </p>
         * 
         * @param scanModeStatus
         *        The status of the Amazon EC2 scan mode setting.
         * @see Ec2ScanModeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2ScanModeStatus
         */
        Builder scanModeStatus(String scanModeStatus);

        /**
         * <p>
         * The status of the Amazon EC2 scan mode setting.
         * </p>
         * 
         * @param scanModeStatus
         *        The status of the Amazon EC2 scan mode setting.
         * @see Ec2ScanModeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2ScanModeStatus
         */
        Builder scanModeStatus(Ec2ScanModeStatus scanModeStatus);
    }

    static final class BuilderImpl implements Builder {
        private String scanMode;

        private String scanModeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2ScanModeState model) {
            scanMode(model.scanMode);
            scanModeStatus(model.scanModeStatus);
        }

        public final String getScanMode() {
            return scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(Ec2ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final String getScanModeStatus() {
            return scanModeStatus;
        }

        public final void setScanModeStatus(String scanModeStatus) {
            this.scanModeStatus = scanModeStatus;
        }

        @Override
        public final Builder scanModeStatus(String scanModeStatus) {
            this.scanModeStatus = scanModeStatus;
            return this;
        }

        @Override
        public final Builder scanModeStatus(Ec2ScanModeStatus scanModeStatus) {
            this.scanModeStatus(scanModeStatus == null ? null : scanModeStatus.toString());
            return this;
        }

        @Override
        public Ec2ScanModeState build() {
            return new Ec2ScanModeState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
