/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon Inspector finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Finding implements SdkPojo, Serializable, ToCopyableBuilder<Finding.Builder, Finding> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(Finding::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<CodeVulnerabilityDetails> CODE_VULNERABILITY_DETAILS_FIELD = SdkField
            .<CodeVulnerabilityDetails> builder(MarshallingType.SDK_POJO).memberName("codeVulnerabilityDetails")
            .getter(getter(Finding::codeVulnerabilityDetails)).setter(setter(Builder::codeVulnerabilityDetails))
            .constructor(CodeVulnerabilityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeVulnerabilityDetails").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Finding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<EpssDetails> EPSS_FIELD = SdkField.<EpssDetails> builder(MarshallingType.SDK_POJO)
            .memberName("epss").getter(getter(Finding::epss)).setter(setter(Builder::epss)).constructor(EpssDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epss").build()).build();

    private static final SdkField<String> EXPLOIT_AVAILABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exploitAvailable").getter(getter(Finding::exploitAvailableAsString))
            .setter(setter(Builder::exploitAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailable").build()).build();

    private static final SdkField<ExploitabilityDetails> EXPLOITABILITY_DETAILS_FIELD = SdkField
            .<ExploitabilityDetails> builder(MarshallingType.SDK_POJO).memberName("exploitabilityDetails")
            .getter(getter(Finding::exploitabilityDetails)).setter(setter(Builder::exploitabilityDetails))
            .constructor(ExploitabilityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitabilityDetails").build())
            .build();

    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingArn").getter(getter(Finding::findingArn)).setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()).build();

    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstObservedAt").getter(getter(Finding::firstObservedAt)).setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()).build();

    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fixAvailable").getter(getter(Finding::fixAvailableAsString)).setter(setter(Builder::fixAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailable").build()).build();

    private static final SdkField<Double> INSPECTOR_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("inspectorScore").getter(getter(Finding::inspectorScore)).setter(setter(Builder::inspectorScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScore").build()).build();

    private static final SdkField<InspectorScoreDetails> INSPECTOR_SCORE_DETAILS_FIELD = SdkField
            .<InspectorScoreDetails> builder(MarshallingType.SDK_POJO).memberName("inspectorScoreDetails")
            .getter(getter(Finding::inspectorScoreDetails)).setter(setter(Builder::inspectorScoreDetails))
            .constructor(InspectorScoreDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScoreDetails").build())
            .build();

    private static final SdkField<Instant> LAST_OBSERVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastObservedAt").getter(getter(Finding::lastObservedAt)).setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastObservedAt").build()).build();

    private static final SdkField<NetworkReachabilityDetails> NETWORK_REACHABILITY_DETAILS_FIELD = SdkField
            .<NetworkReachabilityDetails> builder(MarshallingType.SDK_POJO)
            .memberName("networkReachabilityDetails")
            .getter(getter(Finding::networkReachabilityDetails))
            .setter(setter(Builder::networkReachabilityDetails))
            .constructor(NetworkReachabilityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkReachabilityDetails").build())
            .build();

    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField
            .<PackageVulnerabilityDetails> builder(MarshallingType.SDK_POJO)
            .memberName("packageVulnerabilityDetails")
            .getter(getter(Finding::packageVulnerabilityDetails))
            .setter(setter(Builder::packageVulnerabilityDetails))
            .constructor(PackageVulnerabilityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails")
                    .build()).build();

    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.<Remediation> builder(MarshallingType.SDK_POJO)
            .memberName("remediation").getter(getter(Finding::remediation)).setter(setter(Builder::remediation))
            .constructor(Remediation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(Finding::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(Finding::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Finding::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Finding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Finding::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Finding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            CODE_VULNERABILITY_DETAILS_FIELD, DESCRIPTION_FIELD, EPSS_FIELD, EXPLOIT_AVAILABLE_FIELD,
            EXPLOITABILITY_DETAILS_FIELD, FINDING_ARN_FIELD, FIRST_OBSERVED_AT_FIELD, FIX_AVAILABLE_FIELD, INSPECTOR_SCORE_FIELD,
            INSPECTOR_SCORE_DETAILS_FIELD, LAST_OBSERVED_AT_FIELD, NETWORK_REACHABILITY_DETAILS_FIELD,
            PACKAGE_VULNERABILITY_DETAILS_FIELD, REMEDIATION_FIELD, RESOURCES_FIELD, SEVERITY_FIELD, STATUS_FIELD, TITLE_FIELD,
            TYPE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final CodeVulnerabilityDetails codeVulnerabilityDetails;

    private final String description;

    private final EpssDetails epss;

    private final String exploitAvailable;

    private final ExploitabilityDetails exploitabilityDetails;

    private final String findingArn;

    private final Instant firstObservedAt;

    private final String fixAvailable;

    private final Double inspectorScore;

    private final InspectorScoreDetails inspectorScoreDetails;

    private final Instant lastObservedAt;

    private final NetworkReachabilityDetails networkReachabilityDetails;

    private final PackageVulnerabilityDetails packageVulnerabilityDetails;

    private final Remediation remediation;

    private final List<Resource> resources;

    private final String severity;

    private final String status;

    private final String title;

    private final String type;

    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.codeVulnerabilityDetails = builder.codeVulnerabilityDetails;
        this.description = builder.description;
        this.epss = builder.epss;
        this.exploitAvailable = builder.exploitAvailable;
        this.exploitabilityDetails = builder.exploitabilityDetails;
        this.findingArn = builder.findingArn;
        this.firstObservedAt = builder.firstObservedAt;
        this.fixAvailable = builder.fixAvailable;
        this.inspectorScore = builder.inspectorScore;
        this.inspectorScoreDetails = builder.inspectorScoreDetails;
        this.lastObservedAt = builder.lastObservedAt;
        this.networkReachabilityDetails = builder.networkReachabilityDetails;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.remediation = builder.remediation;
        this.resources = builder.resources;
        this.severity = builder.severity;
        this.status = builder.status;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the finding.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the finding.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * Details about the code vulnerability identified in a Lambda function used to filter findings.
     * </p>
     * 
     * @return Details about the code vulnerability identified in a Lambda function used to filter findings.
     */
    public final CodeVulnerabilityDetails codeVulnerabilityDetails() {
        return codeVulnerabilityDetails;
    }

    /**
     * <p>
     * The description of the finding.
     * </p>
     * 
     * @return The description of the finding.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The finding's EPSS score.
     * </p>
     * 
     * @return The finding's EPSS score.
     */
    public final EpssDetails epss() {
        return epss;
    }

    /**
     * <p>
     * If a finding discovered in your environment has an exploit available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exploitAvailable}
     * will return {@link ExploitAvailable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exploitAvailableAsString}.
     * </p>
     * 
     * @return If a finding discovered in your environment has an exploit available.
     * @see ExploitAvailable
     */
    public final ExploitAvailable exploitAvailable() {
        return ExploitAvailable.fromValue(exploitAvailable);
    }

    /**
     * <p>
     * If a finding discovered in your environment has an exploit available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exploitAvailable}
     * will return {@link ExploitAvailable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exploitAvailableAsString}.
     * </p>
     * 
     * @return If a finding discovered in your environment has an exploit available.
     * @see ExploitAvailable
     */
    public final String exploitAvailableAsString() {
        return exploitAvailable;
    }

    /**
     * <p>
     * The details of an exploit available for a finding discovered in your environment.
     * </p>
     * 
     * @return The details of an exploit available for a finding discovered in your environment.
     */
    public final ExploitabilityDetails exploitabilityDetails() {
        return exploitabilityDetails;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the finding.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the finding.
     */
    public final String findingArn() {
        return findingArn;
    }

    /**
     * <p>
     * The date and time that the finding was first observed.
     * </p>
     * 
     * @return The date and time that the finding was first observed.
     */
    public final Instant firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * <p>
     * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
     * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
     * packages identified in the finding have fixes available through updated versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixAvailable} will
     * return {@link FixAvailable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixAvailableAsString}.
     * </p>
     * 
     * @return Details on whether a fix is available through a version update. This value can be <code>YES</code>,
     *         <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
     *         packages identified in the finding have fixes available through updated versions.
     * @see FixAvailable
     */
    public final FixAvailable fixAvailable() {
        return FixAvailable.fromValue(fixAvailable);
    }

    /**
     * <p>
     * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
     * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
     * packages identified in the finding have fixes available through updated versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixAvailable} will
     * return {@link FixAvailable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixAvailableAsString}.
     * </p>
     * 
     * @return Details on whether a fix is available through a version update. This value can be <code>YES</code>,
     *         <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
     *         packages identified in the finding have fixes available through updated versions.
     * @see FixAvailable
     */
    public final String fixAvailableAsString() {
        return fixAvailable;
    }

    /**
     * <p>
     * The Amazon Inspector score given to the finding.
     * </p>
     * 
     * @return The Amazon Inspector score given to the finding.
     */
    public final Double inspectorScore() {
        return inspectorScore;
    }

    /**
     * <p>
     * An object that contains details of the Amazon Inspector score.
     * </p>
     * 
     * @return An object that contains details of the Amazon Inspector score.
     */
    public final InspectorScoreDetails inspectorScoreDetails() {
        return inspectorScoreDetails;
    }

    /**
     * <p>
     * The date and time the finding was last observed. This timestamp for this field remains unchanged until a finding
     * is updated.
     * </p>
     * 
     * @return The date and time the finding was last observed. This timestamp for this field remains unchanged until a
     *         finding is updated.
     */
    public final Instant lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * <p>
     * An object that contains the details of a network reachability finding.
     * </p>
     * 
     * @return An object that contains the details of a network reachability finding.
     */
    public final NetworkReachabilityDetails networkReachabilityDetails() {
        return networkReachabilityDetails;
    }

    /**
     * <p>
     * An object that contains the details of a package vulnerability finding.
     * </p>
     * 
     * @return An object that contains the details of a package vulnerability finding.
     */
    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return packageVulnerabilityDetails;
    }

    /**
     * <p>
     * An object that contains the details about how to remediate a finding.
     * </p>
     * 
     * @return An object that contains the details about how to remediate a finding.
     */
    public final Remediation remediation() {
        return remediation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information on the resources involved in a finding. The <code>resource</code> value determines the valid
     * values for <code>type</code> in your request. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
     * Inspector user guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Contains information on the resources involved in a finding. The <code>resource</code> value determines
     *         the valid values for <code>type</code> in your request. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
     *         Amazon Inspector user guide.
     */
    public final List<Resource> resources() {
        return resources;
    }

    /**
     * <p>
     * The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type findings
     * that the vendor has not assigned a severity yet. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity levels for
     * findings</a> in the Amazon Inspector user guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type
     *         findings that the vendor has not assigned a severity yet. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity
     *         levels for findings</a> in the Amazon Inspector user guide.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type findings
     * that the vendor has not assigned a severity yet. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity levels for
     * findings</a> in the Amazon Inspector user guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type
     *         findings that the vendor has not assigned a severity yet. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity
     *         levels for findings</a> in the Amazon Inspector user guide.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the finding.
     * @see FindingStatus
     */
    public final FindingStatus status() {
        return FindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the finding.
     * @see FindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The title of the finding.
     * </p>
     * 
     * @return The title of the finding.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The type of the finding. The <code>type</code> value determines the valid values for <code>resource</code> in
     * your request. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
     * Inspector user guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the finding. The <code>type</code> value determines the valid values for
     *         <code>resource</code> in your request. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
     *         Amazon Inspector user guide.
     * @see FindingType
     */
    public final FindingType type() {
        return FindingType.fromValue(type);
    }

    /**
     * <p>
     * The type of the finding. The <code>type</code> value determines the valid values for <code>resource</code> in
     * your request. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
     * Inspector user guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the finding. The <code>type</code> value determines the valid values for
     *         <code>resource</code> in your request. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
     *         Amazon Inspector user guide.
     * @see FindingType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date and time the finding was last updated at.
     * </p>
     * 
     * @return The date and time the finding was last updated at.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(codeVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(epss());
        hashCode = 31 * hashCode + Objects.hashCode(exploitAvailableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exploitabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(fixAvailableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inspectorScore());
        hashCode = 31 * hashCode + Objects.hashCode(inspectorScoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(networkReachabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(codeVulnerabilityDetails(), other.codeVulnerabilityDetails())
                && Objects.equals(description(), other.description()) && Objects.equals(epss(), other.epss())
                && Objects.equals(exploitAvailableAsString(), other.exploitAvailableAsString())
                && Objects.equals(exploitabilityDetails(), other.exploitabilityDetails())
                && Objects.equals(findingArn(), other.findingArn()) && Objects.equals(firstObservedAt(), other.firstObservedAt())
                && Objects.equals(fixAvailableAsString(), other.fixAvailableAsString())
                && Objects.equals(inspectorScore(), other.inspectorScore())
                && Objects.equals(inspectorScoreDetails(), other.inspectorScoreDetails())
                && Objects.equals(lastObservedAt(), other.lastObservedAt())
                && Objects.equals(networkReachabilityDetails(), other.networkReachabilityDetails())
                && Objects.equals(packageVulnerabilityDetails(), other.packageVulnerabilityDetails())
                && Objects.equals(remediation(), other.remediation()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources()) && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(title(), other.title())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Finding").add("AwsAccountId", awsAccountId())
                .add("CodeVulnerabilityDetails", codeVulnerabilityDetails()).add("Description", description())
                .add("Epss", epss()).add("ExploitAvailable", exploitAvailableAsString())
                .add("ExploitabilityDetails", exploitabilityDetails()).add("FindingArn", findingArn())
                .add("FirstObservedAt", firstObservedAt()).add("FixAvailable", fixAvailableAsString())
                .add("InspectorScore", inspectorScore()).add("InspectorScoreDetails", inspectorScoreDetails())
                .add("LastObservedAt", lastObservedAt()).add("NetworkReachabilityDetails", networkReachabilityDetails())
                .add("PackageVulnerabilityDetails", packageVulnerabilityDetails()).add("Remediation", remediation())
                .add("Resources", hasResources() ? resources() : null).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("Title", title()).add("Type", typeAsString()).add("UpdatedAt", updatedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "codeVulnerabilityDetails":
            return Optional.ofNullable(clazz.cast(codeVulnerabilityDetails()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "epss":
            return Optional.ofNullable(clazz.cast(epss()));
        case "exploitAvailable":
            return Optional.ofNullable(clazz.cast(exploitAvailableAsString()));
        case "exploitabilityDetails":
            return Optional.ofNullable(clazz.cast(exploitabilityDetails()));
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        case "firstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "fixAvailable":
            return Optional.ofNullable(clazz.cast(fixAvailableAsString()));
        case "inspectorScore":
            return Optional.ofNullable(clazz.cast(inspectorScore()));
        case "inspectorScoreDetails":
            return Optional.ofNullable(clazz.cast(inspectorScoreDetails()));
        case "lastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "networkReachabilityDetails":
            return Optional.ofNullable(clazz.cast(networkReachabilityDetails()));
        case "packageVulnerabilityDetails":
            return Optional.ofNullable(clazz.cast(packageVulnerabilityDetails()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Finding> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the finding.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * Details about the code vulnerability identified in a Lambda function used to filter findings.
         * </p>
         * 
         * @param codeVulnerabilityDetails
         *        Details about the code vulnerability identified in a Lambda function used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeVulnerabilityDetails(CodeVulnerabilityDetails codeVulnerabilityDetails);

        /**
         * <p>
         * Details about the code vulnerability identified in a Lambda function used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeVulnerabilityDetails.Builder}
         * avoiding the need to create one manually via {@link CodeVulnerabilityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeVulnerabilityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #codeVulnerabilityDetails(CodeVulnerabilityDetails)}.
         * 
         * @param codeVulnerabilityDetails
         *        a consumer that will call methods on {@link CodeVulnerabilityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeVulnerabilityDetails(CodeVulnerabilityDetails)
         */
        default Builder codeVulnerabilityDetails(Consumer<CodeVulnerabilityDetails.Builder> codeVulnerabilityDetails) {
            return codeVulnerabilityDetails(CodeVulnerabilityDetails.builder().applyMutation(codeVulnerabilityDetails).build());
        }

        /**
         * <p>
         * The description of the finding.
         * </p>
         * 
         * @param description
         *        The description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The finding's EPSS score.
         * </p>
         * 
         * @param epss
         *        The finding's EPSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epss(EpssDetails epss);

        /**
         * <p>
         * The finding's EPSS score.
         * </p>
         * This is a convenience method that creates an instance of the {@link EpssDetails.Builder} avoiding the need to
         * create one manually via {@link EpssDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EpssDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #epss(EpssDetails)}.
         * 
         * @param epss
         *        a consumer that will call methods on {@link EpssDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #epss(EpssDetails)
         */
        default Builder epss(Consumer<EpssDetails.Builder> epss) {
            return epss(EpssDetails.builder().applyMutation(epss).build());
        }

        /**
         * <p>
         * If a finding discovered in your environment has an exploit available.
         * </p>
         * 
         * @param exploitAvailable
         *        If a finding discovered in your environment has an exploit available.
         * @see ExploitAvailable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExploitAvailable
         */
        Builder exploitAvailable(String exploitAvailable);

        /**
         * <p>
         * If a finding discovered in your environment has an exploit available.
         * </p>
         * 
         * @param exploitAvailable
         *        If a finding discovered in your environment has an exploit available.
         * @see ExploitAvailable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExploitAvailable
         */
        Builder exploitAvailable(ExploitAvailable exploitAvailable);

        /**
         * <p>
         * The details of an exploit available for a finding discovered in your environment.
         * </p>
         * 
         * @param exploitabilityDetails
         *        The details of an exploit available for a finding discovered in your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exploitabilityDetails(ExploitabilityDetails exploitabilityDetails);

        /**
         * <p>
         * The details of an exploit available for a finding discovered in your environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExploitabilityDetails.Builder} avoiding
         * the need to create one manually via {@link ExploitabilityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExploitabilityDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #exploitabilityDetails(ExploitabilityDetails)}.
         * 
         * @param exploitabilityDetails
         *        a consumer that will call methods on {@link ExploitabilityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exploitabilityDetails(ExploitabilityDetails)
         */
        default Builder exploitabilityDetails(Consumer<ExploitabilityDetails.Builder> exploitabilityDetails) {
            return exploitabilityDetails(ExploitabilityDetails.builder().applyMutation(exploitabilityDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the finding.
         * </p>
         * 
         * @param findingArn
         *        The Amazon Resource Number (ARN) of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(String findingArn);

        /**
         * <p>
         * The date and time that the finding was first observed.
         * </p>
         * 
         * @param firstObservedAt
         *        The date and time that the finding was first observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(Instant firstObservedAt);

        /**
         * <p>
         * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
         * packages identified in the finding have fixes available through updated versions.
         * </p>
         * 
         * @param fixAvailable
         *        Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         *        <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of
         *        the packages identified in the finding have fixes available through updated versions.
         * @see FixAvailable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixAvailable
         */
        Builder fixAvailable(String fixAvailable);

        /**
         * <p>
         * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
         * packages identified in the finding have fixes available through updated versions.
         * </p>
         * 
         * @param fixAvailable
         *        Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         *        <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of
         *        the packages identified in the finding have fixes available through updated versions.
         * @see FixAvailable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixAvailable
         */
        Builder fixAvailable(FixAvailable fixAvailable);

        /**
         * <p>
         * The Amazon Inspector score given to the finding.
         * </p>
         * 
         * @param inspectorScore
         *        The Amazon Inspector score given to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectorScore(Double inspectorScore);

        /**
         * <p>
         * An object that contains details of the Amazon Inspector score.
         * </p>
         * 
         * @param inspectorScoreDetails
         *        An object that contains details of the Amazon Inspector score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails);

        /**
         * <p>
         * An object that contains details of the Amazon Inspector score.
         * </p>
         * This is a convenience method that creates an instance of the {@link InspectorScoreDetails.Builder} avoiding
         * the need to create one manually via {@link InspectorScoreDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InspectorScoreDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #inspectorScoreDetails(InspectorScoreDetails)}.
         * 
         * @param inspectorScoreDetails
         *        a consumer that will call methods on {@link InspectorScoreDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inspectorScoreDetails(InspectorScoreDetails)
         */
        default Builder inspectorScoreDetails(Consumer<InspectorScoreDetails.Builder> inspectorScoreDetails) {
            return inspectorScoreDetails(InspectorScoreDetails.builder().applyMutation(inspectorScoreDetails).build());
        }

        /**
         * <p>
         * The date and time the finding was last observed. This timestamp for this field remains unchanged until a
         * finding is updated.
         * </p>
         * 
         * @param lastObservedAt
         *        The date and time the finding was last observed. This timestamp for this field remains unchanged until
         *        a finding is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(Instant lastObservedAt);

        /**
         * <p>
         * An object that contains the details of a network reachability finding.
         * </p>
         * 
         * @param networkReachabilityDetails
         *        An object that contains the details of a network reachability finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkReachabilityDetails(NetworkReachabilityDetails networkReachabilityDetails);

        /**
         * <p>
         * An object that contains the details of a network reachability finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkReachabilityDetails.Builder}
         * avoiding the need to create one manually via {@link NetworkReachabilityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkReachabilityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #networkReachabilityDetails(NetworkReachabilityDetails)}.
         * 
         * @param networkReachabilityDetails
         *        a consumer that will call methods on {@link NetworkReachabilityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkReachabilityDetails(NetworkReachabilityDetails)
         */
        default Builder networkReachabilityDetails(Consumer<NetworkReachabilityDetails.Builder> networkReachabilityDetails) {
            return networkReachabilityDetails(NetworkReachabilityDetails.builder().applyMutation(networkReachabilityDetails)
                    .build());
        }

        /**
         * <p>
         * An object that contains the details of a package vulnerability finding.
         * </p>
         * 
         * @param packageVulnerabilityDetails
         *        An object that contains the details of a package vulnerability finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails);

        /**
         * <p>
         * An object that contains the details of a package vulnerability finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVulnerabilityDetails.Builder}
         * avoiding the need to create one manually via {@link PackageVulnerabilityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageVulnerabilityDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #packageVulnerabilityDetails(PackageVulnerabilityDetails)}.
         * 
         * @param packageVulnerabilityDetails
         *        a consumer that will call methods on {@link PackageVulnerabilityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVulnerabilityDetails(PackageVulnerabilityDetails)
         */
        default Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return packageVulnerabilityDetails(PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)
                    .build());
        }

        /**
         * <p>
         * An object that contains the details about how to remediate a finding.
         * </p>
         * 
         * @param remediation
         *        An object that contains the details about how to remediate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(Remediation remediation);

        /**
         * <p>
         * An object that contains the details about how to remediate a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Remediation.Builder} avoiding the need to
         * create one manually via {@link Remediation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Remediation.Builder#build()} is called immediately and its result
         * is passed to {@link #remediation(Remediation)}.
         * 
         * @param remediation
         *        a consumer that will call methods on {@link Remediation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediation(Remediation)
         */
        default Builder remediation(Consumer<Remediation.Builder> remediation) {
            return remediation(Remediation.builder().applyMutation(remediation).build());
        }

        /**
         * <p>
         * Contains information on the resources involved in a finding. The <code>resource</code> value determines the
         * valid values for <code>type</code> in your request. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
         * Inspector user guide.
         * </p>
         * 
         * @param resources
         *        Contains information on the resources involved in a finding. The <code>resource</code> value
         *        determines the valid values for <code>type</code> in your request. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
         *        Amazon Inspector user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * Contains information on the resources involved in a finding. The <code>resource</code> value determines the
         * valid values for <code>type</code> in your request. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
         * Inspector user guide.
         * </p>
         * 
         * @param resources
         *        Contains information on the resources involved in a finding. The <code>resource</code> value
         *        determines the valid values for <code>type</code> in your request. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
         *        Amazon Inspector user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * Contains information on the resources involved in a finding. The <code>resource</code> value determines the
         * valid values for <code>type</code> in your request. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
         * Inspector user guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.Resource.Builder#build()} is called immediately and
         * its result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type
         * findings that the vendor has not assigned a severity yet. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity levels
         * for findings</a> in the Amazon Inspector user guide.
         * </p>
         * 
         * @param severity
         *        The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type
         *        findings that the vendor has not assigned a severity yet. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity
         *        levels for findings</a> in the Amazon Inspector user guide.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type
         * findings that the vendor has not assigned a severity yet. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity levels
         * for findings</a> in the Amazon Inspector user guide.
         * </p>
         * 
         * @param severity
         *        The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type
         *        findings that the vendor has not assigned a severity yet. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity
         *        levels for findings</a> in the Amazon Inspector user guide.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(FindingStatus status);

        /**
         * <p>
         * The title of the finding.
         * </p>
         * 
         * @param title
         *        The title of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The type of the finding. The <code>type</code> value determines the valid values for <code>resource</code> in
         * your request. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
         * Inspector user guide.
         * </p>
         * 
         * @param type
         *        The type of the finding. The <code>type</code> value determines the valid values for
         *        <code>resource</code> in your request. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
         *        Amazon Inspector user guide.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the finding. The <code>type</code> value determines the valid values for <code>resource</code> in
         * your request. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon
         * Inspector user guide.
         * </p>
         * 
         * @param type
         *        The type of the finding. The <code>type</code> value determines the valid values for
         *        <code>resource</code> in your request. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the
         *        Amazon Inspector user guide.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder type(FindingType type);

        /**
         * <p>
         * The date and time the finding was last updated at.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the finding was last updated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private CodeVulnerabilityDetails codeVulnerabilityDetails;

        private String description;

        private EpssDetails epss;

        private String exploitAvailable;

        private ExploitabilityDetails exploitabilityDetails;

        private String findingArn;

        private Instant firstObservedAt;

        private String fixAvailable;

        private Double inspectorScore;

        private InspectorScoreDetails inspectorScoreDetails;

        private Instant lastObservedAt;

        private NetworkReachabilityDetails networkReachabilityDetails;

        private PackageVulnerabilityDetails packageVulnerabilityDetails;

        private Remediation remediation;

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private String severity;

        private String status;

        private String title;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            awsAccountId(model.awsAccountId);
            codeVulnerabilityDetails(model.codeVulnerabilityDetails);
            description(model.description);
            epss(model.epss);
            exploitAvailable(model.exploitAvailable);
            exploitabilityDetails(model.exploitabilityDetails);
            findingArn(model.findingArn);
            firstObservedAt(model.firstObservedAt);
            fixAvailable(model.fixAvailable);
            inspectorScore(model.inspectorScore);
            inspectorScoreDetails(model.inspectorScoreDetails);
            lastObservedAt(model.lastObservedAt);
            networkReachabilityDetails(model.networkReachabilityDetails);
            packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            remediation(model.remediation);
            resources(model.resources);
            severity(model.severity);
            status(model.status);
            title(model.title);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final CodeVulnerabilityDetails.Builder getCodeVulnerabilityDetails() {
            return codeVulnerabilityDetails != null ? codeVulnerabilityDetails.toBuilder() : null;
        }

        public final void setCodeVulnerabilityDetails(CodeVulnerabilityDetails.BuilderImpl codeVulnerabilityDetails) {
            this.codeVulnerabilityDetails = codeVulnerabilityDetails != null ? codeVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder codeVulnerabilityDetails(CodeVulnerabilityDetails codeVulnerabilityDetails) {
            this.codeVulnerabilityDetails = codeVulnerabilityDetails;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EpssDetails.Builder getEpss() {
            return epss != null ? epss.toBuilder() : null;
        }

        public final void setEpss(EpssDetails.BuilderImpl epss) {
            this.epss = epss != null ? epss.build() : null;
        }

        @Override
        public final Builder epss(EpssDetails epss) {
            this.epss = epss;
            return this;
        }

        public final String getExploitAvailable() {
            return exploitAvailable;
        }

        public final void setExploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
        }

        @Override
        public final Builder exploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
            return this;
        }

        @Override
        public final Builder exploitAvailable(ExploitAvailable exploitAvailable) {
            this.exploitAvailable(exploitAvailable == null ? null : exploitAvailable.toString());
            return this;
        }

        public final ExploitabilityDetails.Builder getExploitabilityDetails() {
            return exploitabilityDetails != null ? exploitabilityDetails.toBuilder() : null;
        }

        public final void setExploitabilityDetails(ExploitabilityDetails.BuilderImpl exploitabilityDetails) {
            this.exploitabilityDetails = exploitabilityDetails != null ? exploitabilityDetails.build() : null;
        }

        @Override
        public final Builder exploitabilityDetails(ExploitabilityDetails exploitabilityDetails) {
            this.exploitabilityDetails = exploitabilityDetails;
            return this;
        }

        public final String getFindingArn() {
            return findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Instant getFirstObservedAt() {
            return firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final String getFixAvailable() {
            return fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        @Override
        public final Builder fixAvailable(FixAvailable fixAvailable) {
            this.fixAvailable(fixAvailable == null ? null : fixAvailable.toString());
            return this;
        }

        public final Double getInspectorScore() {
            return inspectorScore;
        }

        public final void setInspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
        }

        @Override
        public final Builder inspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
            return this;
        }

        public final InspectorScoreDetails.Builder getInspectorScoreDetails() {
            return inspectorScoreDetails != null ? inspectorScoreDetails.toBuilder() : null;
        }

        public final void setInspectorScoreDetails(InspectorScoreDetails.BuilderImpl inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails != null ? inspectorScoreDetails.build() : null;
        }

        @Override
        public final Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails;
            return this;
        }

        public final Instant getLastObservedAt() {
            return lastObservedAt;
        }

        public final void setLastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final NetworkReachabilityDetails.Builder getNetworkReachabilityDetails() {
            return networkReachabilityDetails != null ? networkReachabilityDetails.toBuilder() : null;
        }

        public final void setNetworkReachabilityDetails(NetworkReachabilityDetails.BuilderImpl networkReachabilityDetails) {
            this.networkReachabilityDetails = networkReachabilityDetails != null ? networkReachabilityDetails.build() : null;
        }

        @Override
        public final Builder networkReachabilityDetails(NetworkReachabilityDetails networkReachabilityDetails) {
            this.networkReachabilityDetails = networkReachabilityDetails;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return packageVulnerabilityDetails != null ? packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return remediation != null ? remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FindingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Finding build() {
            return new Finding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
