/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEc2DeepInspectionConfigurationRequest extends Inspector2Request implements
        ToCopyableBuilder<UpdateEc2DeepInspectionConfigurationRequest.Builder, UpdateEc2DeepInspectionConfigurationRequest> {
    private static final SdkField<Boolean> ACTIVATE_DEEP_INSPECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("activateDeepInspection")
            .getter(getter(UpdateEc2DeepInspectionConfigurationRequest::activateDeepInspection))
            .setter(setter(Builder::activateDeepInspection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activateDeepInspection").build())
            .build();

    private static final SdkField<List<String>> PACKAGE_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("packagePaths")
            .getter(getter(UpdateEc2DeepInspectionConfigurationRequest::packagePaths))
            .setter(setter(Builder::packagePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVATE_DEEP_INSPECTION_FIELD, PACKAGE_PATHS_FIELD));

    private final Boolean activateDeepInspection;

    private final List<String> packagePaths;

    private UpdateEc2DeepInspectionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.activateDeepInspection = builder.activateDeepInspection;
        this.packagePaths = builder.packagePaths;
    }

    /**
     * <p>
     * Specify <code>TRUE</code> to activate Amazon Inspector deep inspection in your account, or <code>FALSE</code> to
     * deactivate. Member accounts in an organization cannot deactivate deep inspection, instead the delegated
     * administrator for the organization can deactivate a member account using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchUpdateMemberEc2DeepInspectionStatus.html"
     * >BatchUpdateMemberEc2DeepInspectionStatus</a>.
     * </p>
     * 
     * @return Specify <code>TRUE</code> to activate Amazon Inspector deep inspection in your account, or
     *         <code>FALSE</code> to deactivate. Member accounts in an organization cannot deactivate deep inspection,
     *         instead the delegated administrator for the organization can deactivate a member account using <a href=
     *         "https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchUpdateMemberEc2DeepInspectionStatus.html"
     *         >BatchUpdateMemberEc2DeepInspectionStatus</a>.
     */
    public final Boolean activateDeepInspection() {
        return activateDeepInspection;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackagePaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackagePaths() {
        return packagePaths != null && !(packagePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Inspector deep inspection custom paths you are adding for your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackagePaths} method.
     * </p>
     * 
     * @return The Amazon Inspector deep inspection custom paths you are adding for your account.
     */
    public final List<String> packagePaths() {
        return packagePaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activateDeepInspection());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackagePaths() ? packagePaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEc2DeepInspectionConfigurationRequest)) {
            return false;
        }
        UpdateEc2DeepInspectionConfigurationRequest other = (UpdateEc2DeepInspectionConfigurationRequest) obj;
        return Objects.equals(activateDeepInspection(), other.activateDeepInspection())
                && hasPackagePaths() == other.hasPackagePaths() && Objects.equals(packagePaths(), other.packagePaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEc2DeepInspectionConfigurationRequest")
                .add("ActivateDeepInspection", activateDeepInspection())
                .add("PackagePaths", hasPackagePaths() ? packagePaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activateDeepInspection":
            return Optional.ofNullable(clazz.cast(activateDeepInspection()));
        case "packagePaths":
            return Optional.ofNullable(clazz.cast(packagePaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEc2DeepInspectionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateEc2DeepInspectionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEc2DeepInspectionConfigurationRequest> {
        /**
         * <p>
         * Specify <code>TRUE</code> to activate Amazon Inspector deep inspection in your account, or <code>FALSE</code>
         * to deactivate. Member accounts in an organization cannot deactivate deep inspection, instead the delegated
         * administrator for the organization can deactivate a member account using <a href=
         * "https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchUpdateMemberEc2DeepInspectionStatus.html"
         * >BatchUpdateMemberEc2DeepInspectionStatus</a>.
         * </p>
         * 
         * @param activateDeepInspection
         *        Specify <code>TRUE</code> to activate Amazon Inspector deep inspection in your account, or
         *        <code>FALSE</code> to deactivate. Member accounts in an organization cannot deactivate deep
         *        inspection, instead the delegated administrator for the organization can deactivate a member account
         *        using <a href=
         *        "https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchUpdateMemberEc2DeepInspectionStatus.html"
         *        >BatchUpdateMemberEc2DeepInspectionStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activateDeepInspection(Boolean activateDeepInspection);

        /**
         * <p>
         * The Amazon Inspector deep inspection custom paths you are adding for your account.
         * </p>
         * 
         * @param packagePaths
         *        The Amazon Inspector deep inspection custom paths you are adding for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagePaths(Collection<String> packagePaths);

        /**
         * <p>
         * The Amazon Inspector deep inspection custom paths you are adding for your account.
         * </p>
         * 
         * @param packagePaths
         *        The Amazon Inspector deep inspection custom paths you are adding for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagePaths(String... packagePaths);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private Boolean activateDeepInspection;

        private List<String> packagePaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEc2DeepInspectionConfigurationRequest model) {
            super(model);
            activateDeepInspection(model.activateDeepInspection);
            packagePaths(model.packagePaths);
        }

        public final Boolean getActivateDeepInspection() {
            return activateDeepInspection;
        }

        public final void setActivateDeepInspection(Boolean activateDeepInspection) {
            this.activateDeepInspection = activateDeepInspection;
        }

        @Override
        public final Builder activateDeepInspection(Boolean activateDeepInspection) {
            this.activateDeepInspection = activateDeepInspection;
            return this;
        }

        public final Collection<String> getPackagePaths() {
            if (packagePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return packagePaths;
        }

        public final void setPackagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
        }

        @Override
        public final Builder packagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagePaths(String... packagePaths) {
            packagePaths(Arrays.asList(packagePaths));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEc2DeepInspectionConfigurationRequest build() {
            return new UpdateEc2DeepInspectionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
