/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteCisScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteCisScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.DisableRequest;
import software.amazon.awssdk.services.inspector2.model.DisableResponse;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.EnableRequest;
import software.amazon.awssdk.services.inspector2.model.EnableResponse;
import software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest;
import software.amazon.awssdk.services.inspector2.model.GetCisScanReportResponse;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse;
import software.amazon.awssdk.services.inspector2.model.GetMemberRequest;
import software.amazon.awssdk.services.inspector2.model.GetMemberResponse;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListCisScansRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScansResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFiltersRequest;
import software.amazon.awssdk.services.inspector2.model.ListFiltersResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector2.model.ListMembersRequest;
import software.amazon.awssdk.services.inspector2.model.ListMembersResponse;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthResponse;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest;
import software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryResponse;
import software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest;
import software.amazon.awssdk.services.inspector2.model.StartCisSessionResponse;
import software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest;
import software.amazon.awssdk.services.inspector2.model.StopCisSessionResponse;
import software.amazon.awssdk.services.inspector2.model.TagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.TagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.UntagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.UntagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourcePublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListCisScansPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListCoveragePublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListFiltersPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsPublisher;
import software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesPublisher;

/**
 * Service client for accessing Inspector2 asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities
 * within your Amazon EC2, Amazon ECR, and Amazon Web Services Lambda environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Inspector2AsyncClient extends AwsClient {
    String SERVICE_NAME = "inspector2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "inspector2";

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     *
     * @param associateMemberRequest
     * @return A Java Future containing the result of the AssociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateMemberResponse> associateMember(AssociateMemberRequest associateMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateMemberRequest#builder()}
     * </p>
     *
     * @param associateMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateMemberResponse> associateMember(
            Consumer<AssociateMemberRequest.Builder> associateMemberRequest) {
        return associateMember(AssociateMemberRequest.builder().applyMutation(associateMemberRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     *
     * @param batchGetAccountStatusRequest
     * @return A Java Future containing the result of the BatchGetAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAccountStatusResponse> batchGetAccountStatus(
            BatchGetAccountStatusRequest batchGetAccountStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAccountStatusRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetAccountStatusRequest#builder()}
     * </p>
     *
     * @param batchGetAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAccountStatusResponse> batchGetAccountStatus(
            Consumer<BatchGetAccountStatusRequest.Builder> batchGetAccountStatusRequest) {
        return batchGetAccountStatus(BatchGetAccountStatusRequest.builder().applyMutation(batchGetAccountStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     * @return A Java Future containing the result of the BatchGetCodeSnippet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCodeSnippetResponse> batchGetCodeSnippet(
            BatchGetCodeSnippetRequest batchGetCodeSnippetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCodeSnippetRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetCodeSnippetRequest#builder()}
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetCodeSnippet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCodeSnippetResponse> batchGetCodeSnippet(
            Consumer<BatchGetCodeSnippetRequest.Builder> batchGetCodeSnippetRequest) {
        return batchGetCodeSnippet(BatchGetCodeSnippetRequest.builder().applyMutation(batchGetCodeSnippetRequest).build());
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     * @return A Java Future containing the result of the BatchGetFindingDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetFindingDetailsResponse> batchGetFindingDetails(
            BatchGetFindingDetailsRequest batchGetFindingDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFindingDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetFindingDetailsRequest#builder()}
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetFindingDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetFindingDetailsResponse> batchGetFindingDetails(
            Consumer<BatchGetFindingDetailsRequest.Builder> batchGetFindingDetailsRequest) {
        return batchGetFindingDetails(BatchGetFindingDetailsRequest.builder().applyMutation(batchGetFindingDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     * @return A Java Future containing the result of the BatchGetFreeTrialInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetFreeTrialInfoResponse> batchGetFreeTrialInfo(
            BatchGetFreeTrialInfoRequest batchGetFreeTrialInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFreeTrialInfoRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetFreeTrialInfoRequest#builder()}
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetFreeTrialInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetFreeTrialInfoResponse> batchGetFreeTrialInfo(
            Consumer<BatchGetFreeTrialInfoRequest.Builder> batchGetFreeTrialInfoRequest) {
        return batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest.builder().applyMutation(batchGetFreeTrialInfoRequest).build());
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     * @return A Java Future containing the result of the BatchGetMemberEc2DeepInspectionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetMemberEc2DeepInspectionStatusResponse> batchGetMemberEc2DeepInspectionStatus(
            BatchGetMemberEc2DeepInspectionStatusRequest batchGetMemberEc2DeepInspectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetMemberEc2DeepInspectionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetMemberEc2DeepInspectionStatusRequest#builder()}
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetMemberEc2DeepInspectionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetMemberEc2DeepInspectionStatusResponse> batchGetMemberEc2DeepInspectionStatus(
            Consumer<BatchGetMemberEc2DeepInspectionStatusRequest.Builder> batchGetMemberEc2DeepInspectionStatusRequest) {
        return batchGetMemberEc2DeepInspectionStatus(BatchGetMemberEc2DeepInspectionStatusRequest.builder()
                .applyMutation(batchGetMemberEc2DeepInspectionStatusRequest).build());
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     * @return A Java Future containing the result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateMemberEc2DeepInspectionStatusResponse> batchUpdateMemberEc2DeepInspectionStatus(
            BatchUpdateMemberEc2DeepInspectionStatusRequest batchUpdateMemberEc2DeepInspectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateMemberEc2DeepInspectionStatusRequest#builder()}
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateMemberEc2DeepInspectionStatusResponse> batchUpdateMemberEc2DeepInspectionStatus(
            Consumer<BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder> batchUpdateMemberEc2DeepInspectionStatusRequest) {
        return batchUpdateMemberEc2DeepInspectionStatus(BatchUpdateMemberEc2DeepInspectionStatusRequest.builder()
                .applyMutation(batchUpdateMemberEc2DeepInspectionStatusRequest).build());
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     *
     * @param cancelFindingsReportRequest
     * @return A Java Future containing the result of the CancelFindingsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelFindingsReportResponse> cancelFindingsReport(
            CancelFindingsReportRequest cancelFindingsReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelFindingsReportRequest.Builder} avoiding the
     * need to create one manually via {@link CancelFindingsReportRequest#builder()}
     * </p>
     *
     * @param cancelFindingsReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelFindingsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelFindingsReportResponse> cancelFindingsReport(
            Consumer<CancelFindingsReportRequest.Builder> cancelFindingsReportRequest) {
        return cancelFindingsReport(CancelFindingsReportRequest.builder().applyMutation(cancelFindingsReportRequest).build());
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     *
     * @param cancelSbomExportRequest
     * @return A Java Future containing the result of the CancelSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSbomExportResponse> cancelSbomExport(CancelSbomExportRequest cancelSbomExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSbomExportRequest.Builder} avoiding the need
     * to create one manually via {@link CancelSbomExportRequest#builder()}
     * </p>
     *
     * @param cancelSbomExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSbomExportResponse> cancelSbomExport(
            Consumer<CancelSbomExportRequest.Builder> cancelSbomExportRequest) {
        return cancelSbomExport(CancelSbomExportRequest.builder().applyMutation(cancelSbomExportRequest).build());
    }

    /**
     * <p>
     * Creates a CIS scan configuration.
     * </p>
     *
     * @param createCisScanConfigurationRequest
     * @return A Java Future containing the result of the CreateCisScanConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCisScanConfigurationResponse> createCisScanConfiguration(
            CreateCisScanConfigurationRequest createCisScanConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a CIS scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCisScanConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCisScanConfigurationRequest#builder()}
     * </p>
     *
     * @param createCisScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateCisScanConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCisScanConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCisScanConfigurationResponse> createCisScanConfiguration(
            Consumer<CreateCisScanConfigurationRequest.Builder> createCisScanConfigurationRequest) {
        return createCisScanConfiguration(CreateCisScanConfigurationRequest.builder()
                .applyMutation(createCisScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria. When the filter action is set to <code>SUPPRESS</code>
     * this action creates a suppression rule.
     * </p>
     *
     * @param createFilterRequest
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>BadRequestException One or more tags submitted as part of the request is not valid.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFilterResponse> createFilter(CreateFilterRequest createFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria. When the filter action is set to <code>SUPPRESS</code>
     * this action creates a suppression rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFilterRequest#builder()}
     * </p>
     *
     * @param createFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>BadRequestException One or more tags submitted as part of the request is not valid.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFilterResponse> createFilter(Consumer<CreateFilterRequest.Builder> createFilterRequest) {
        return createFilter(CreateFilterRequest.builder().applyMutation(createFilterRequest).build());
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     *
     * @param createFindingsReportRequest
     * @return A Java Future containing the result of the CreateFindingsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFindingsReportResponse> createFindingsReport(
            CreateFindingsReportRequest createFindingsReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFindingsReportRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFindingsReportRequest#builder()}
     * </p>
     *
     * @param createFindingsReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFindingsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFindingsReportResponse> createFindingsReport(
            Consumer<CreateFindingsReportRequest.Builder> createFindingsReportRequest) {
        return createFindingsReport(CreateFindingsReportRequest.builder().applyMutation(createFindingsReportRequest).build());
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     *
     * @param createSbomExportRequest
     * @return A Java Future containing the result of the CreateSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSbomExportResponse> createSbomExport(CreateSbomExportRequest createSbomExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSbomExportRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSbomExportRequest#builder()}
     * </p>
     *
     * @param createSbomExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSbomExportResponse> createSbomExport(
            Consumer<CreateSbomExportRequest.Builder> createSbomExportRequest) {
        return createSbomExport(CreateSbomExportRequest.builder().applyMutation(createSbomExportRequest).build());
    }

    /**
     * <p>
     * Deletes a CIS scan configuration.
     * </p>
     *
     * @param deleteCisScanConfigurationRequest
     * @return A Java Future containing the result of the DeleteCisScanConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DeleteCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCisScanConfigurationResponse> deleteCisScanConfiguration(
            DeleteCisScanConfigurationRequest deleteCisScanConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CIS scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCisScanConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCisScanConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteCisScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DeleteCisScanConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCisScanConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DeleteCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCisScanConfigurationResponse> deleteCisScanConfiguration(
            Consumer<DeleteCisScanConfigurationRequest.Builder> deleteCisScanConfigurationRequest) {
        return deleteCisScanConfiguration(DeleteCisScanConfigurationRequest.builder()
                .applyMutation(deleteCisScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     *
     * @param deleteFilterRequest
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFilterResponse> deleteFilter(DeleteFilterRequest deleteFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFilterRequest#builder()}
     * </p>
     *
     * @param deleteFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFilterResponse> deleteFilter(Consumer<DeleteFilterRequest.Builder> deleteFilterRequest) {
        return deleteFilter(DeleteFilterRequest.builder().applyMutation(deleteFilterRequest).build());
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest) {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     *
     * @param disableRequest
     * @return A Java Future containing the result of the Disable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableResponse> disable(DisableRequest disableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRequest.Builder} avoiding the need to create
     * one manually via {@link DisableRequest#builder()}
     * </p>
     *
     * @param disableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DisableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Disable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableResponse> disable(Consumer<DisableRequest.Builder> disableRequest) {
        return disable(DisableRequest.builder().applyMutation(disableRequest).build());
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     * @return A Java Future containing the result of the DisableDelegatedAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDelegatedAdminAccountResponse> disableDelegatedAdminAccount(
            DisableDelegatedAdminAccountRequest disableDelegatedAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDelegatedAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableDelegatedAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDelegatedAdminAccountResponse> disableDelegatedAdminAccount(
            Consumer<DisableDelegatedAdminAccountRequest.Builder> disableDelegatedAdminAccountRequest) {
        return disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest.builder()
                .applyMutation(disableDelegatedAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberResponse> disassociateMember(DisassociateMemberRequest disassociateMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMemberRequest#builder()}
     * </p>
     *
     * @param disassociateMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberResponse> disassociateMember(
            Consumer<DisassociateMemberRequest.Builder> disassociateMemberRequest) {
        return disassociateMember(DisassociateMemberRequest.builder().applyMutation(disassociateMemberRequest).build());
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     *
     * @param enableRequest
     * @return A Java Future containing the result of the Enable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableResponse> enable(EnableRequest enableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRequest.Builder} avoiding the need to create
     * one manually via {@link EnableRequest#builder()}
     * </p>
     *
     * @param enableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.EnableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Enable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableResponse> enable(Consumer<EnableRequest.Builder> enableRequest) {
        return enable(EnableRequest.builder().applyMutation(enableRequest).build());
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     * @return A Java Future containing the result of the EnableDelegatedAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDelegatedAdminAccountResponse> enableDelegatedAdminAccount(
            EnableDelegatedAdminAccountRequest enableDelegatedAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDelegatedAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableDelegatedAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDelegatedAdminAccountResponse> enableDelegatedAdminAccount(
            Consumer<EnableDelegatedAdminAccountRequest.Builder> enableDelegatedAdminAccountRequest) {
        return enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest.builder()
                .applyMutation(enableDelegatedAdminAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves a CIS scan report.
     * </p>
     *
     * @param getCisScanReportRequest
     * @return A Java Future containing the result of the GetCisScanReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetCisScanReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCisScanReportResponse> getCisScanReport(GetCisScanReportRequest getCisScanReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a CIS scan report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCisScanReportRequest.Builder} avoiding the need
     * to create one manually via {@link GetCisScanReportRequest#builder()}
     * </p>
     *
     * @param getCisScanReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCisScanReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCisScanReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetCisScanReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCisScanReportResponse> getCisScanReport(
            Consumer<GetCisScanReportRequest.Builder> getCisScanReportRequest) {
        return getCisScanReport(GetCisScanReportRequest.builder().applyMutation(getCisScanReportRequest).build());
    }

    /**
     * <p>
     * Retrieves CIS scan result details.
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     * @return A Java Future containing the result of the GetCisScanResultDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCisScanResultDetailsResponse> getCisScanResultDetails(
            GetCisScanResultDetailsRequest getCisScanResultDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves CIS scan result details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCisScanResultDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCisScanResultDetailsRequest#builder()}
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetCisScanResultDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCisScanResultDetailsResponse> getCisScanResultDetails(
            Consumer<GetCisScanResultDetailsRequest.Builder> getCisScanResultDetailsRequest) {
        return getCisScanResultDetails(GetCisScanResultDetailsRequest.builder().applyMutation(getCisScanResultDetailsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsPublisher publisher = client.getCisScanResultDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsPublisher publisher = client.getCisScanResultDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCisScanResultDetailsPublisher getCisScanResultDetailsPaginator(
            GetCisScanResultDetailsRequest getCisScanResultDetailsRequest) {
        return new GetCisScanResultDetailsPublisher(this, getCisScanResultDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsPublisher publisher = client.getCisScanResultDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.GetCisScanResultDetailsPublisher publisher = client.getCisScanResultDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCisScanResultDetails(software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCisScanResultDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCisScanResultDetailsRequest#builder()}
     * </p>
     *
     * @param getCisScanResultDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetCisScanResultDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCisScanResultDetailsPublisher getCisScanResultDetailsPaginator(
            Consumer<GetCisScanResultDetailsRequest.Builder> getCisScanResultDetailsRequest) {
        return getCisScanResultDetailsPaginator(GetCisScanResultDetailsRequest.builder()
                .applyMutation(getCisScanResultDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     *
     * @param getConfigurationRequest
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConfigurationResponse> getConfiguration(GetConfigurationRequest getConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConfigurationResponse> getConfiguration(
            Consumer<GetConfigurationRequest.Builder> getConfigurationRequest) {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     * @return A Java Future containing the result of the GetDelegatedAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDelegatedAdminAccountResponse> getDelegatedAdminAccount(
            GetDelegatedAdminAccountRequest getDelegatedAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegatedAdminAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDelegatedAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDelegatedAdminAccountResponse> getDelegatedAdminAccount(
            Consumer<GetDelegatedAdminAccountRequest.Builder> getDelegatedAdminAccountRequest) {
        return getDelegatedAdminAccount(GetDelegatedAdminAccountRequest.builder().applyMutation(getDelegatedAdminAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     * @return A Java Future containing the result of the GetEc2DeepInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEc2DeepInspectionConfigurationResponse> getEc2DeepInspectionConfiguration(
            GetEc2DeepInspectionConfigurationRequest getEc2DeepInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEc2DeepInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEc2DeepInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEc2DeepInspectionConfigurationResponse> getEc2DeepInspectionConfiguration(
            Consumer<GetEc2DeepInspectionConfigurationRequest.Builder> getEc2DeepInspectionConfigurationRequest) {
        return getEc2DeepInspectionConfiguration(GetEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(getEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     *
     * @param getEncryptionKeyRequest
     * @return A Java Future containing the result of the GetEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEncryptionKeyResponse> getEncryptionKey(GetEncryptionKeyRequest getEncryptionKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncryptionKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param getEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEncryptionKeyResponse> getEncryptionKey(
            Consumer<GetEncryptionKeyRequest.Builder> getEncryptionKeyRequest) {
        return getEncryptionKey(GetEncryptionKeyRequest.builder().applyMutation(getEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     *
     * @param getFindingsReportStatusRequest
     * @return A Java Future containing the result of the GetFindingsReportStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFindingsReportStatusResponse> getFindingsReportStatus(
            GetFindingsReportStatusRequest getFindingsReportStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsReportStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetFindingsReportStatusRequest#builder()}
     * </p>
     *
     * @param getFindingsReportStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetFindingsReportStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFindingsReportStatusResponse> getFindingsReportStatus(
            Consumer<GetFindingsReportStatusRequest.Builder> getFindingsReportStatusRequest) {
        return getFindingsReportStatus(GetFindingsReportStatusRequest.builder().applyMutation(getFindingsReportStatusRequest)
                .build());
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     *
     * @param getMemberRequest
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMemberResponse> getMember(GetMemberRequest getMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemberRequest#builder()}
     * </p>
     *
     * @param getMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetMemberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMemberResponse> getMember(Consumer<GetMemberRequest.Builder> getMemberRequest) {
        return getMember(GetMemberRequest.builder().applyMutation(getMemberRequest).build());
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     *
     * @param getSbomExportRequest
     * @return A Java Future containing the result of the GetSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSbomExportResponse> getSbomExport(GetSbomExportRequest getSbomExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSbomExportRequest.Builder} avoiding the need to
     * create one manually via {@link GetSbomExportRequest#builder()}
     * </p>
     *
     * @param getSbomExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSbomExportResponse> getSbomExport(Consumer<GetSbomExportRequest.Builder> getSbomExportRequest) {
        return getSbomExport(GetSbomExportRequest.builder().applyMutation(getSbomExportRequest).build());
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return A Java Future containing the result of the ListAccountPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountPermissionsResponse> listAccountPermissions(
            ListAccountPermissionsRequest listAccountPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountPermissionsRequest#builder()}
     * </p>
     *
     * @param listAccountPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccountPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountPermissionsResponse> listAccountPermissions(
            Consumer<ListAccountPermissionsRequest.Builder> listAccountPermissionsRequest) {
        return listAccountPermissions(ListAccountPermissionsRequest.builder().applyMutation(listAccountPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsPublisher publisher = client.listAccountPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsPublisher publisher = client.listAccountPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsPublisher listAccountPermissionsPaginator(
            ListAccountPermissionsRequest listAccountPermissionsRequest) {
        return new ListAccountPermissionsPublisher(this, listAccountPermissionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsPublisher publisher = client.listAccountPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsPublisher publisher = client.listAccountPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountPermissionsRequest#builder()}
     * </p>
     *
     * @param listAccountPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsPublisher listAccountPermissionsPaginator(
            Consumer<ListAccountPermissionsRequest.Builder> listAccountPermissionsRequest) {
        return listAccountPermissionsPaginator(ListAccountPermissionsRequest.builder()
                .applyMutation(listAccountPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists CIS scan configurations.
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     * @return A Java Future containing the result of the ListCisScanConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCisScanConfigurationsResponse> listCisScanConfigurations(
            ListCisScanConfigurationsRequest listCisScanConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists CIS scan configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScanConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCisScanConfigurationsRequest#builder()}
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCisScanConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCisScanConfigurationsResponse> listCisScanConfigurations(
            Consumer<ListCisScanConfigurationsRequest.Builder> listCisScanConfigurationsRequest) {
        return listCisScanConfigurations(ListCisScanConfigurationsRequest.builder()
                .applyMutation(listCisScanConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsPublisher publisher = client.listCisScanConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsPublisher publisher = client.listCisScanConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanConfigurationsPublisher listCisScanConfigurationsPaginator(
            ListCisScanConfigurationsRequest listCisScanConfigurationsRequest) {
        return new ListCisScanConfigurationsPublisher(this, listCisScanConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsPublisher publisher = client.listCisScanConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanConfigurationsPublisher publisher = client.listCisScanConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanConfigurations(software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScanConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCisScanConfigurationsRequest#builder()}
     * </p>
     *
     * @param listCisScanConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanConfigurationsPublisher listCisScanConfigurationsPaginator(
            Consumer<ListCisScanConfigurationsRequest.Builder> listCisScanConfigurationsRequest) {
        return listCisScanConfigurationsPaginator(ListCisScanConfigurationsRequest.builder()
                .applyMutation(listCisScanConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists scan results aggregated by checks.
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     * @return A Java Future containing the result of the ListCisScanResultsAggregatedByChecks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCisScanResultsAggregatedByChecksResponse> listCisScanResultsAggregatedByChecks(
            ListCisScanResultsAggregatedByChecksRequest listCisScanResultsAggregatedByChecksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists scan results aggregated by checks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByChecksRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByChecksRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCisScanResultsAggregatedByChecks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCisScanResultsAggregatedByChecksResponse> listCisScanResultsAggregatedByChecks(
            Consumer<ListCisScanResultsAggregatedByChecksRequest.Builder> listCisScanResultsAggregatedByChecksRequest) {
        return listCisScanResultsAggregatedByChecks(ListCisScanResultsAggregatedByChecksRequest.builder()
                .applyMutation(listCisScanResultsAggregatedByChecksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksPublisher publisher = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksPublisher publisher = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByChecksPublisher listCisScanResultsAggregatedByChecksPaginator(
            ListCisScanResultsAggregatedByChecksRequest listCisScanResultsAggregatedByChecksRequest) {
        return new ListCisScanResultsAggregatedByChecksPublisher(this, listCisScanResultsAggregatedByChecksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksPublisher publisher = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByChecksPublisher publisher = client.listCisScanResultsAggregatedByChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByChecks(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByChecksRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByChecksRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByChecksPublisher listCisScanResultsAggregatedByChecksPaginator(
            Consumer<ListCisScanResultsAggregatedByChecksRequest.Builder> listCisScanResultsAggregatedByChecksRequest) {
        return listCisScanResultsAggregatedByChecksPaginator(ListCisScanResultsAggregatedByChecksRequest.builder()
                .applyMutation(listCisScanResultsAggregatedByChecksRequest).build());
    }

    /**
     * <p>
     * Lists scan results aggregated by a target resource.
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     * @return A Java Future containing the result of the ListCisScanResultsAggregatedByTargetResource operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCisScanResultsAggregatedByTargetResourceResponse> listCisScanResultsAggregatedByTargetResource(
            ListCisScanResultsAggregatedByTargetResourceRequest listCisScanResultsAggregatedByTargetResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists scan results aggregated by a target resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCisScanResultsAggregatedByTargetResource operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCisScanResultsAggregatedByTargetResourceResponse> listCisScanResultsAggregatedByTargetResource(
            Consumer<ListCisScanResultsAggregatedByTargetResourceRequest.Builder> listCisScanResultsAggregatedByTargetResourceRequest) {
        return listCisScanResultsAggregatedByTargetResource(ListCisScanResultsAggregatedByTargetResourceRequest.builder()
                .applyMutation(listCisScanResultsAggregatedByTargetResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourcePublisher publisher = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourcePublisher publisher = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByTargetResourcePublisher listCisScanResultsAggregatedByTargetResourcePaginator(
            ListCisScanResultsAggregatedByTargetResourceRequest listCisScanResultsAggregatedByTargetResourceRequest) {
        return new ListCisScanResultsAggregatedByTargetResourcePublisher(this,
                listCisScanResultsAggregatedByTargetResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourcePublisher publisher = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScanResultsAggregatedByTargetResourcePublisher publisher = client.listCisScanResultsAggregatedByTargetResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScanResultsAggregatedByTargetResource(software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListCisScanResultsAggregatedByTargetResourceRequest#builder()}
     * </p>
     *
     * @param listCisScanResultsAggregatedByTargetResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScanResultsAggregatedByTargetResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCisScanResultsAggregatedByTargetResourcePublisher listCisScanResultsAggregatedByTargetResourcePaginator(
            Consumer<ListCisScanResultsAggregatedByTargetResourceRequest.Builder> listCisScanResultsAggregatedByTargetResourceRequest) {
        return listCisScanResultsAggregatedByTargetResourcePaginator(ListCisScanResultsAggregatedByTargetResourceRequest
                .builder().applyMutation(listCisScanResultsAggregatedByTargetResourceRequest).build());
    }

    /**
     * <p>
     * Returns a CIS scan list.
     * </p>
     *
     * @param listCisScansRequest
     * @return A Java Future containing the result of the ListCisScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCisScansResponse> listCisScans(ListCisScansRequest listCisScansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a CIS scan list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScansRequest.Builder} avoiding the need to
     * create one manually via {@link ListCisScansRequest#builder()}
     * </p>
     *
     * @param listCisScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScansRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCisScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCisScansResponse> listCisScans(Consumer<ListCisScansRequest.Builder> listCisScansRequest) {
        return listCisScans(ListCisScansRequest.builder().applyMutation(listCisScansRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansPublisher publisher = client.listCisScansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansPublisher publisher = client.listCisScansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)} operation.</b>
     * </p>
     *
     * @param listCisScansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCisScansPublisher listCisScansPaginator(ListCisScansRequest listCisScansRequest) {
        return new ListCisScansPublisher(this, listCisScansRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansPublisher publisher = client.listCisScansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCisScansPublisher publisher = client.listCisScansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCisScansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCisScansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCisScans(software.amazon.awssdk.services.inspector2.model.ListCisScansRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCisScansRequest.Builder} avoiding the need to
     * create one manually via {@link ListCisScansRequest#builder()}
     * </p>
     *
     * @param listCisScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCisScansRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCisScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCisScansPublisher listCisScansPaginator(Consumer<ListCisScansRequest.Builder> listCisScansRequest) {
        return listCisScansPaginator(ListCisScansRequest.builder().applyMutation(listCisScansRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     *
     * @param listCoverageRequest
     * @return A Java Future containing the result of the ListCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCoverageResponse> listCoverage(ListCoverageRequest listCoverageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCoverageResponse> listCoverage(Consumer<ListCoverageRequest.Builder> listCoverageRequest) {
        return listCoverage(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCoverageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCoverageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)} operation.</b>
     * </p>
     *
     * @param listCoverageRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoveragePublisher listCoveragePaginator(ListCoverageRequest listCoverageRequest) {
        return new ListCoveragePublisher(this, listCoverageRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCoverageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCoverageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoveragePublisher listCoveragePaginator(Consumer<ListCoverageRequest.Builder> listCoverageRequest) {
        return listCoveragePaginator(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return A Java Future containing the result of the ListCoverageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoverageStatisticsResponse> listCoverageStatistics(
            ListCoverageStatisticsRequest listCoverageStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param listCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCoverageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoverageStatisticsResponse> listCoverageStatistics(
            Consumer<ListCoverageStatisticsRequest.Builder> listCoverageStatisticsRequest) {
        return listCoverageStatistics(ListCoverageStatisticsRequest.builder().applyMutation(listCoverageStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsPublisher publisher = client.listCoverageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsPublisher publisher = client.listCoverageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsPublisher listCoverageStatisticsPaginator(
            ListCoverageStatisticsRequest listCoverageStatisticsRequest) {
        return new ListCoverageStatisticsPublisher(this, listCoverageStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsPublisher publisher = client.listCoverageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsPublisher publisher = client.listCoverageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param listCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsPublisher listCoverageStatisticsPaginator(
            Consumer<ListCoverageStatisticsRequest.Builder> listCoverageStatisticsRequest) {
        return listCoverageStatisticsPaginator(ListCoverageStatisticsRequest.builder()
                .applyMutation(listCoverageStatisticsRequest).build());
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return A Java Future containing the result of the ListDelegatedAdminAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDelegatedAdminAccountsResponse> listDelegatedAdminAccounts(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDelegatedAdminAccountsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDelegatedAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDelegatedAdminAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDelegatedAdminAccountsResponse> listDelegatedAdminAccounts(
            Consumer<ListDelegatedAdminAccountsRequest.Builder> listDelegatedAdminAccountsRequest) {
        return listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest.builder()
                .applyMutation(listDelegatedAdminAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsPublisher publisher = client.listDelegatedAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsPublisher publisher = client.listDelegatedAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsPublisher listDelegatedAdminAccountsPaginator(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) {
        return new ListDelegatedAdminAccountsPublisher(this, listDelegatedAdminAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsPublisher publisher = client.listDelegatedAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsPublisher publisher = client.listDelegatedAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDelegatedAdminAccountsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDelegatedAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsPublisher listDelegatedAdminAccountsPaginator(
            Consumer<ListDelegatedAdminAccountsRequest.Builder> listDelegatedAdminAccountsRequest) {
        return listDelegatedAdminAccountsPaginator(ListDelegatedAdminAccountsRequest.builder()
                .applyMutation(listDelegatedAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     *
     * @param listFiltersRequest
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFiltersResponse> listFilters(ListFiltersRequest listFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFiltersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFiltersResponse> listFilters(Consumer<ListFiltersRequest.Builder> listFiltersRequest) {
        return listFilters(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersPublisher listFiltersPaginator(ListFiltersRequest listFiltersRequest) {
        return new ListFiltersPublisher(this, listFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFiltersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersPublisher listFiltersPaginator(Consumer<ListFiltersRequest.Builder> listFiltersRequest) {
        return listFiltersPaginator(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return A Java Future containing the result of the ListFindingAggregations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFindingAggregationsResponse> listFindingAggregations(
            ListFindingAggregationsRequest listFindingAggregationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListFindingAggregations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFindingAggregationsResponse> listFindingAggregations(
            Consumer<ListFindingAggregationsRequest.Builder> listFindingAggregationsRequest) {
        return listFindingAggregations(ListFindingAggregationsRequest.builder().applyMutation(listFindingAggregationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsPublisher publisher = client.listFindingAggregationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsPublisher publisher = client.listFindingAggregationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsPublisher listFindingAggregationsPaginator(
            ListFindingAggregationsRequest listFindingAggregationsRequest) {
        return new ListFindingAggregationsPublisher(this, listFindingAggregationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsPublisher publisher = client.listFindingAggregationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsPublisher publisher = client.listFindingAggregationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsPublisher listFindingAggregationsPaginator(
            Consumer<ListFindingAggregationsRequest.Builder> listFindingAggregationsRequest) {
        return listFindingAggregationsPaginator(ListFindingAggregationsRequest.builder()
                .applyMutation(listFindingAggregationsRequest).build());
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        return new ListFindingsPublisher(this, listFindingsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListFindingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        return new ListMembersPublisher(this, listMembersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return A Java Future containing the result of the ListUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUsageTotalsResponse> listUsageTotals(ListUsageTotalsRequest listUsageTotalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageTotalsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageTotalsRequest#builder()}
     * </p>
     *
     * @param listUsageTotalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUsageTotalsResponse> listUsageTotals(
            Consumer<ListUsageTotalsRequest.Builder> listUsageTotalsRequest) {
        return listUsageTotals(ListUsageTotalsRequest.builder().applyMutation(listUsageTotalsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsPublisher publisher = client.listUsageTotalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsPublisher publisher = client.listUsageTotalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation.</b>
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsPublisher listUsageTotalsPaginator(ListUsageTotalsRequest listUsageTotalsRequest) {
        return new ListUsageTotalsPublisher(this, listUsageTotalsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsPublisher publisher = client.listUsageTotalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsPublisher publisher = client.listUsageTotalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageTotalsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageTotalsRequest#builder()}
     * </p>
     *
     * @param listUsageTotalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsPublisher listUsageTotalsPaginator(Consumer<ListUsageTotalsRequest.Builder> listUsageTotalsRequest) {
        return listUsageTotalsPaginator(ListUsageTotalsRequest.builder().applyMutation(listUsageTotalsRequest).build());
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     *
     * @param resetEncryptionKeyRequest
     * @return A Java Future containing the result of the ResetEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetEncryptionKeyResponse> resetEncryptionKey(ResetEncryptionKeyRequest resetEncryptionKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link ResetEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param resetEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetEncryptionKeyResponse> resetEncryptionKey(
            Consumer<ResetEncryptionKeyRequest.Builder> resetEncryptionKeyRequest) {
        return resetEncryptionKey(ResetEncryptionKeyRequest.builder().applyMutation(resetEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return A Java Future containing the result of the SearchVulnerabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchVulnerabilitiesResponse> searchVulnerabilities(
            SearchVulnerabilitiesRequest searchVulnerabilitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVulnerabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVulnerabilitiesRequest#builder()}
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchVulnerabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchVulnerabilitiesResponse> searchVulnerabilities(
            Consumer<SearchVulnerabilitiesRequest.Builder> searchVulnerabilitiesRequest) {
        return searchVulnerabilities(SearchVulnerabilitiesRequest.builder().applyMutation(searchVulnerabilitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesPublisher publisher = client.searchVulnerabilitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesPublisher publisher = client.searchVulnerabilitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesPublisher searchVulnerabilitiesPaginator(
            SearchVulnerabilitiesRequest searchVulnerabilitiesRequest) {
        return new SearchVulnerabilitiesPublisher(this, searchVulnerabilitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesPublisher publisher = client.searchVulnerabilitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesPublisher publisher = client.searchVulnerabilitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVulnerabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVulnerabilitiesRequest#builder()}
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesPublisher searchVulnerabilitiesPaginator(
            Consumer<SearchVulnerabilitiesRequest.Builder> searchVulnerabilitiesRequest) {
        return searchVulnerabilitiesPaginator(SearchVulnerabilitiesRequest.builder().applyMutation(searchVulnerabilitiesRequest)
                .build());
    }

    /**
     * <p>
     * Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     *
     * @param sendCisSessionHealthRequest
     * @return A Java Future containing the result of the SendCisSessionHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SendCisSessionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCisSessionHealthResponse> sendCisSessionHealth(
            SendCisSessionHealthRequest sendCisSessionHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCisSessionHealthRequest.Builder} avoiding the
     * need to create one manually via {@link SendCisSessionHealthRequest#builder()}
     * </p>
     *
     * @param sendCisSessionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SendCisSessionHealthRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendCisSessionHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SendCisSessionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCisSessionHealthResponse> sendCisSessionHealth(
            Consumer<SendCisSessionHealthRequest.Builder> sendCisSessionHealthRequest) {
        return sendCisSessionHealth(SendCisSessionHealthRequest.builder().applyMutation(sendCisSessionHealthRequest).build());
    }

    /**
     * <p>
     * Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     *
     * @param sendCisSessionTelemetryRequest
     * @return A Java Future containing the result of the SendCisSessionTelemetry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SendCisSessionTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCisSessionTelemetryResponse> sendCisSessionTelemetry(
            SendCisSessionTelemetryRequest sendCisSessionTelemetryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCisSessionTelemetryRequest.Builder} avoiding
     * the need to create one manually via {@link SendCisSessionTelemetryRequest#builder()}
     * </p>
     *
     * @param sendCisSessionTelemetryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.SendCisSessionTelemetryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SendCisSessionTelemetry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SendCisSessionTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCisSessionTelemetryResponse> sendCisSessionTelemetry(
            Consumer<SendCisSessionTelemetryRequest.Builder> sendCisSessionTelemetryRequest) {
        return sendCisSessionTelemetry(SendCisSessionTelemetryRequest.builder().applyMutation(sendCisSessionTelemetryRequest)
                .build());
    }

    /**
     * <p>
     * Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     *
     * @param startCisSessionRequest
     * @return A Java Future containing the result of the StartCisSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.StartCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCisSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartCisSessionResponse> startCisSession(StartCisSessionRequest startCisSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon
     * Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID
     * supplied by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCisSessionRequest.Builder} avoiding the need
     * to create one manually via {@link StartCisSessionRequest#builder()}
     * </p>
     *
     * @param startCisSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.StartCisSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCisSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.StartCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCisSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartCisSessionResponse> startCisSession(
            Consumer<StartCisSessionRequest.Builder> startCisSessionRequest) {
        return startCisSession(StartCisSessionRequest.builder().applyMutation(startCisSessionRequest).build());
    }

    /**
     * <p>
     * Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector
     * service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by
     * the service.
     * </p>
     *
     * @param stopCisSessionRequest
     * @return A Java Future containing the result of the StopCisSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.StopCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StopCisSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopCisSessionResponse> stopCisSession(StopCisSessionRequest stopCisSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector
     * service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by
     * the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCisSessionRequest.Builder} avoiding the need to
     * create one manually via {@link StopCisSessionRequest#builder()}
     * </p>
     *
     * @param stopCisSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.StopCisSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopCisSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.StopCisSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StopCisSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopCisSessionResponse> stopCisSession(Consumer<StopCisSessionRequest.Builder> stopCisSessionRequest) {
        return stopCisSession(StopCisSessionRequest.builder().applyMutation(stopCisSessionRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException One or more tags submitted as part of the request is not valid.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException One or more tags submitted as part of the request is not valid.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a CIS scan configuration.
     * </p>
     *
     * @param updateCisScanConfigurationRequest
     * @return A Java Future containing the result of the UpdateCisScanConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCisScanConfigurationResponse> updateCisScanConfiguration(
            UpdateCisScanConfigurationRequest updateCisScanConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a CIS scan configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCisScanConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCisScanConfigurationRequest#builder()}
     * </p>
     *
     * @param updateCisScanConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateCisScanConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateCisScanConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateCisScanConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCisScanConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCisScanConfigurationResponse> updateCisScanConfiguration(
            Consumer<UpdateCisScanConfigurationRequest.Builder> updateCisScanConfigurationRequest) {
        return updateCisScanConfiguration(UpdateCisScanConfigurationRequest.builder()
                .applyMutation(updateCisScanConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     *
     * @param updateConfigurationRequest
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            UpdateConfigurationRequest updateConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     * @return A Java Future containing the result of the UpdateEc2DeepInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEc2DeepInspectionConfigurationResponse> updateEc2DeepInspectionConfiguration(
            UpdateEc2DeepInspectionConfigurationRequest updateEc2DeepInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateEc2DeepInspectionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateEc2DeepInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEc2DeepInspectionConfigurationResponse> updateEc2DeepInspectionConfiguration(
            Consumer<UpdateEc2DeepInspectionConfigurationRequest.Builder> updateEc2DeepInspectionConfigurationRequest) {
        return updateEc2DeepInspectionConfiguration(UpdateEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(updateEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an Amazon Web Services owned key
     * is being used for encryption.
     * </p>
     *
     * @param updateEncryptionKeyRequest
     * @return A Java Future containing the result of the UpdateEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEncryptionKeyResponse> updateEncryptionKey(
            UpdateEncryptionKeyRequest updateEncryptionKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an Amazon Web Services owned key
     * is being used for encryption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param updateEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEncryptionKeyResponse> updateEncryptionKey(
            Consumer<UpdateEncryptionKeyRequest.Builder> updateEncryptionKeyRequest) {
        return updateEncryptionKey(UpdateEncryptionKeyRequest.builder().applyMutation(updateEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     *
     * @param updateFilterRequest
     * @return A Java Future containing the result of the UpdateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFilterResponse> updateFilter(UpdateFilterRequest updateFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFilterRequest#builder()}
     * </p>
     *
     * @param updateFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFilterResponse> updateFilter(Consumer<UpdateFilterRequest.Builder> updateFilterRequest) {
        return updateFilter(UpdateFilterRequest.builder().applyMutation(updateFilterRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrgEc2DeepInspectionConfigurationResponse> updateOrgEc2DeepInspectionConfiguration(
            UpdateOrgEc2DeepInspectionConfigurationRequest updateOrgEc2DeepInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateOrgEc2DeepInspectionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateOrgEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrgEc2DeepInspectionConfigurationResponse> updateOrgEc2DeepInspectionConfiguration(
            Consumer<UpdateOrgEc2DeepInspectionConfigurationRequest.Builder> updateOrgEc2DeepInspectionConfigurationRequest) {
        return updateOrgEc2DeepInspectionConfiguration(UpdateOrgEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(updateOrgEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest) {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    @Override
    default Inspector2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link Inspector2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Inspector2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Inspector2AsyncClient}.
     */
    static Inspector2AsyncClientBuilder builder() {
        return new DefaultInspector2AsyncClientBuilder();
    }
}
