/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the state of the EC2 scan configuration for your environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2ConfigurationState implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2ConfigurationState.Builder, Ec2ConfigurationState> {
    private static final SdkField<Ec2ScanModeState> SCAN_MODE_STATE_FIELD = SdkField
            .<Ec2ScanModeState> builder(MarshallingType.SDK_POJO).memberName("scanModeState")
            .getter(getter(Ec2ConfigurationState::scanModeState)).setter(setter(Builder::scanModeState))
            .constructor(Ec2ScanModeState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanModeState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_MODE_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Ec2ScanModeState scanModeState;

    private Ec2ConfigurationState(BuilderImpl builder) {
        this.scanModeState = builder.scanModeState;
    }

    /**
     * <p>
     * An object that contains details about the state of the Amazon EC2 scan mode.
     * </p>
     * 
     * @return An object that contains details about the state of the Amazon EC2 scan mode.
     */
    public final Ec2ScanModeState scanModeState() {
        return scanModeState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanModeState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2ConfigurationState)) {
            return false;
        }
        Ec2ConfigurationState other = (Ec2ConfigurationState) obj;
        return Objects.equals(scanModeState(), other.scanModeState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2ConfigurationState").add("ScanModeState", scanModeState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanModeState":
            return Optional.ofNullable(clazz.cast(scanModeState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2ConfigurationState, T> g) {
        return obj -> g.apply((Ec2ConfigurationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2ConfigurationState> {
        /**
         * <p>
         * An object that contains details about the state of the Amazon EC2 scan mode.
         * </p>
         * 
         * @param scanModeState
         *        An object that contains details about the state of the Amazon EC2 scan mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanModeState(Ec2ScanModeState scanModeState);

        /**
         * <p>
         * An object that contains details about the state of the Amazon EC2 scan mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2ScanModeState.Builder} avoiding the
         * need to create one manually via {@link Ec2ScanModeState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2ScanModeState.Builder#build()} is called immediately and its
         * result is passed to {@link #scanModeState(Ec2ScanModeState)}.
         * 
         * @param scanModeState
         *        a consumer that will call methods on {@link Ec2ScanModeState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanModeState(Ec2ScanModeState)
         */
        default Builder scanModeState(Consumer<Ec2ScanModeState.Builder> scanModeState) {
            return scanModeState(Ec2ScanModeState.builder().applyMutation(scanModeState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Ec2ScanModeState scanModeState;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2ConfigurationState model) {
            scanModeState(model.scanModeState);
        }

        public final Ec2ScanModeState.Builder getScanModeState() {
            return scanModeState != null ? scanModeState.toBuilder() : null;
        }

        public final void setScanModeState(Ec2ScanModeState.BuilderImpl scanModeState) {
            this.scanModeState = scanModeState != null ? scanModeState.build() : null;
        }

        @Override
        public final Builder scanModeState(Ec2ScanModeState scanModeState) {
            this.scanModeState = scanModeState;
            return this;
        }

        @Override
        public Ec2ConfigurationState build() {
            return new Ec2ConfigurationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
