/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCisScanConfigurationRequest extends Inspector2Request implements
        ToCopyableBuilder<UpdateCisScanConfigurationRequest.Builder, UpdateCisScanConfigurationRequest> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(UpdateCisScanConfigurationRequest::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(UpdateCisScanConfigurationRequest::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(UpdateCisScanConfigurationRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityLevel").getter(getter(UpdateCisScanConfigurationRequest::securityLevelAsString))
            .setter(setter(Builder::securityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()).build();

    private static final SdkField<UpdateCisTargets> TARGETS_FIELD = SdkField.<UpdateCisTargets> builder(MarshallingType.SDK_POJO)
            .memberName("targets").getter(getter(UpdateCisScanConfigurationRequest::targets)).setter(setter(Builder::targets))
            .constructor(UpdateCisTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            SCAN_NAME_FIELD, SCHEDULE_FIELD, SECURITY_LEVEL_FIELD, TARGETS_FIELD));

    private final String scanConfigurationArn;

    private final String scanName;

    private final Schedule schedule;

    private final String securityLevel;

    private final UpdateCisTargets targets;

    private UpdateCisScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.scanName = builder.scanName;
        this.schedule = builder.schedule;
        this.securityLevel = builder.securityLevel;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * The CIS scan configuration ARN.
     * </p>
     * 
     * @return The CIS scan configuration ARN.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * <p>
     * The scan name for the CIS scan configuration.
     * </p>
     * 
     * @return The scan name for the CIS scan configuration.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The schedule for the CIS scan configuration.
     * </p>
     * 
     * @return The schedule for the CIS scan configuration.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS assigns
     * to a profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
     *         assigns to a profile.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(securityLevel);
    }

    /**
     * <p>
     * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS assigns
     * to a profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
     *         assigns to a profile.
     * @see CisSecurityLevel
     */
    public final String securityLevelAsString() {
        return securityLevel;
    }

    /**
     * <p>
     * The targets for the CIS scan configuration.
     * </p>
     * 
     * @return The targets for the CIS scan configuration.
     */
    public final UpdateCisTargets targets() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(securityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCisScanConfigurationRequest)) {
            return false;
        }
        UpdateCisScanConfigurationRequest other = (UpdateCisScanConfigurationRequest) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn())
                && Objects.equals(scanName(), other.scanName()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(securityLevelAsString(), other.securityLevelAsString())
                && Objects.equals(targets(), other.targets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCisScanConfigurationRequest").add("ScanConfigurationArn", scanConfigurationArn())
                .add("ScanName", scanName()).add("Schedule", schedule()).add("SecurityLevel", securityLevelAsString())
                .add("Targets", targets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "securityLevel":
            return Optional.ofNullable(clazz.cast(securityLevelAsString()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCisScanConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateCisScanConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCisScanConfigurationRequest> {
        /**
         * <p>
         * The CIS scan configuration ARN.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The CIS scan configuration ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * <p>
         * The scan name for the CIS scan configuration.
         * </p>
         * 
         * @param scanName
         *        The scan name for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The schedule for the CIS scan configuration.
         * </p>
         * 
         * @param schedule
         *        The schedule for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule for the CIS scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
         * assigns to a profile.
         * </p>
         * 
         * @param securityLevel
         *        The security level for the CIS scan configuration. Security level refers to the Benchmark levels that
         *        CIS assigns to a profile.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(String securityLevel);

        /**
         * <p>
         * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
         * assigns to a profile.
         * </p>
         * 
         * @param securityLevel
         *        The security level for the CIS scan configuration. Security level refers to the Benchmark levels that
         *        CIS assigns to a profile.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(CisSecurityLevel securityLevel);

        /**
         * <p>
         * The targets for the CIS scan configuration.
         * </p>
         * 
         * @param targets
         *        The targets for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(UpdateCisTargets targets);

        /**
         * <p>
         * The targets for the CIS scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateCisTargets.Builder} avoiding the
         * need to create one manually via {@link UpdateCisTargets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCisTargets.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(UpdateCisTargets)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link UpdateCisTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(UpdateCisTargets)
         */
        default Builder targets(Consumer<UpdateCisTargets.Builder> targets) {
            return targets(UpdateCisTargets.builder().applyMutation(targets).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private String scanName;

        private Schedule schedule;

        private String securityLevel;

        private UpdateCisTargets targets;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCisScanConfigurationRequest model) {
            super(model);
            scanConfigurationArn(model.scanConfigurationArn);
            scanName(model.scanName);
            schedule(model.schedule);
            securityLevel(model.securityLevel);
            targets(model.targets);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSecurityLevel() {
            return securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        public final UpdateCisTargets.Builder getTargets() {
            return targets != null ? targets.toBuilder() : null;
        }

        public final void setTargets(UpdateCisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(UpdateCisTargets targets) {
            this.targets = targets;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCisScanConfigurationRequest build() {
            return new UpdateCisScanConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
