/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceState> {
    private static final SdkField<State> EC2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2").getter(ResourceState.getter(ResourceState::ec2)).setter(ResourceState.setter(Builder::ec2)).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()}).build();
    private static final SdkField<State> ECR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecr").getter(ResourceState.getter(ResourceState::ecr)).setter(ResourceState.setter(Builder::ecr)).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()}).build();
    private static final SdkField<State> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(ResourceState.getter(ResourceState::lambda)).setter(ResourceState.setter(Builder::lambda)).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<State> LAMBDA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaCode").getter(ResourceState.getter(ResourceState::lambdaCode)).setter(ResourceState.setter(Builder::lambdaCode)).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_FIELD, LAMBDA_FIELD, LAMBDA_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final State ec2;
    private final State ecr;
    private final State lambda;
    private final State lambdaCode;

    private ResourceState(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
        this.lambda = builder.lambda;
        this.lambdaCode = builder.lambdaCode;
    }

    public final State ec2() {
        return this.ec2;
    }

    public final State ecr() {
        return this.ecr;
    }

    public final State lambda() {
        return this.lambda;
    }

    public final State lambdaCode() {
        return this.lambdaCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecr());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceState)) {
            return false;
        }
        ResourceState other = (ResourceState)obj;
        return Objects.equals(this.ec2(), other.ec2()) && Objects.equals(this.ecr(), other.ecr()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.lambdaCode(), other.lambdaCode());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceState").add("Ec2", (Object)this.ec2()).add("Ecr", (Object)this.ecr()).add("Lambda", (Object)this.lambda()).add("LambdaCode", (Object)this.lambdaCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2": {
                return Optional.ofNullable(clazz.cast(this.ec2()));
            }
            case "ecr": {
                return Optional.ofNullable(clazz.cast(this.ecr()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "lambdaCode": {
                return Optional.ofNullable(clazz.cast(this.lambdaCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceState, T> g) {
        return obj -> g.apply((ResourceState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private State ec2;
        private State ecr;
        private State lambda;
        private State lambdaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceState model) {
            this.ec2(model.ec2);
            this.ecr(model.ecr);
            this.lambda(model.lambda);
            this.lambdaCode(model.lambdaCode);
        }

        public final State.Builder getEc2() {
            return this.ec2 != null ? this.ec2.toBuilder() : null;
        }

        public final void setEc2(State.BuilderImpl ec2) {
            this.ec2 = ec2 != null ? ec2.build() : null;
        }

        @Override
        public final Builder ec2(State ec2) {
            this.ec2 = ec2;
            return this;
        }

        public final State.Builder getEcr() {
            return this.ecr != null ? this.ecr.toBuilder() : null;
        }

        public final void setEcr(State.BuilderImpl ecr) {
            this.ecr = ecr != null ? ecr.build() : null;
        }

        @Override
        public final Builder ecr(State ecr) {
            this.ecr = ecr;
            return this;
        }

        public final State.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(State.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(State lambda) {
            this.lambda = lambda;
            return this;
        }

        public final State.Builder getLambdaCode() {
            return this.lambdaCode != null ? this.lambdaCode.toBuilder() : null;
        }

        public final void setLambdaCode(State.BuilderImpl lambdaCode) {
            this.lambdaCode = lambdaCode != null ? lambdaCode.build() : null;
        }

        @Override
        public final Builder lambdaCode(State lambdaCode) {
            this.lambdaCode = lambdaCode;
            return this;
        }

        public ResourceState build() {
            return new ResourceState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceState> {
        public Builder ec2(State var1);

        default public Builder ec2(Consumer<State.Builder> ec2) {
            return this.ec2((State)((State.Builder)State.builder().applyMutation(ec2)).build());
        }

        public Builder ecr(State var1);

        default public Builder ecr(Consumer<State.Builder> ecr) {
            return this.ecr((State)((State.Builder)State.builder().applyMutation(ecr)).build());
        }

        public Builder lambda(State var1);

        default public Builder lambda(Consumer<State.Builder> lambda) {
            return this.lambda((State)((State.Builder)State.builder().applyMutation(lambda)).build());
        }

        public Builder lambdaCode(State var1);

        default public Builder lambdaCode(Consumer<State.Builder> lambdaCode) {
            return this.lambdaCode((State)((State.Builder)State.builder().applyMutation(lambdaCode)).build());
        }
    }
}

