/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status counts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusCounts implements SdkPojo, Serializable, ToCopyableBuilder<StatusCounts.Builder, StatusCounts> {
    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(StatusCounts::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Integer> PASSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("passed").getter(getter(StatusCounts::passed)).setter(setter(Builder::passed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passed").build()).build();

    private static final SdkField<Integer> SKIPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("skipped").getter(getter(StatusCounts::skipped)).setter(setter(Builder::skipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, PASSED_FIELD,
            SKIPPED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer failed;

    private final Integer passed;

    private final Integer skipped;

    private StatusCounts(BuilderImpl builder) {
        this.failed = builder.failed;
        this.passed = builder.passed;
        this.skipped = builder.skipped;
    }

    /**
     * <p>
     * The number of checks that failed.
     * </p>
     * 
     * @return The number of checks that failed.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of checks that passed.
     * </p>
     * 
     * @return The number of checks that passed.
     */
    public final Integer passed() {
        return passed;
    }

    /**
     * <p>
     * The number of checks that were skipped.
     * </p>
     * 
     * @return The number of checks that were skipped.
     */
    public final Integer skipped() {
        return skipped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(passed());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusCounts)) {
            return false;
        }
        StatusCounts other = (StatusCounts) obj;
        return Objects.equals(failed(), other.failed()) && Objects.equals(passed(), other.passed())
                && Objects.equals(skipped(), other.skipped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusCounts").add("Failed", failed()).add("Passed", passed()).add("Skipped", skipped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "passed":
            return Optional.ofNullable(clazz.cast(passed()));
        case "skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusCounts, T> g) {
        return obj -> g.apply((StatusCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusCounts> {
        /**
         * <p>
         * The number of checks that failed.
         * </p>
         * 
         * @param failed
         *        The number of checks that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of checks that passed.
         * </p>
         * 
         * @param passed
         *        The number of checks that passed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passed(Integer passed);

        /**
         * <p>
         * The number of checks that were skipped.
         * </p>
         * 
         * @param skipped
         *        The number of checks that were skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Integer skipped);
    }

    static final class BuilderImpl implements Builder {
        private Integer failed;

        private Integer passed;

        private Integer skipped;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusCounts model) {
            failed(model.failed);
            passed(model.passed);
            skipped(model.skipped);
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getPassed() {
            return passed;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final Integer getSkipped() {
            return skipped;
        }

        public final void setSkipped(Integer skipped) {
            this.skipped = skipped;
        }

        @Override
        public final Builder skipped(Integer skipped) {
            this.skipped = skipped;
            return this;
        }

        @Override
        public StatusCounts build() {
            return new StatusCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
