/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus;
import software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateMemberEc2DeepInspectionStatusRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, BatchUpdateMemberEc2DeepInspectionStatusRequest> {
    private static final SdkField<List<MemberAccountEc2DeepInspectionStatus>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(BatchUpdateMemberEc2DeepInspectionStatusRequest.getter(BatchUpdateMemberEc2DeepInspectionStatusRequest::accountIds)).setter(BatchUpdateMemberEc2DeepInspectionStatusRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberAccountEc2DeepInspectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountIds", ACCOUNT_IDS_FIELD);
        }
    });
    private final List<MemberAccountEc2DeepInspectionStatus> accountIds;

    private BatchUpdateMemberEc2DeepInspectionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<MemberAccountEc2DeepInspectionStatus> accountIds() {
        return this.accountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateMemberEc2DeepInspectionStatusRequest)) {
            return false;
        }
        BatchUpdateMemberEc2DeepInspectionStatusRequest other = (BatchUpdateMemberEc2DeepInspectionStatusRequest)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateMemberEc2DeepInspectionStatusRequest").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateMemberEc2DeepInspectionStatusRequest, T> g) {
        return obj -> g.apply((BatchUpdateMemberEc2DeepInspectionStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private List<MemberAccountEc2DeepInspectionStatus> accountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateMemberEc2DeepInspectionStatusRequest model) {
            super(model);
            this.accountIds(model.accountIds);
        }

        public final List<MemberAccountEc2DeepInspectionStatus.Builder> getAccountIds() {
            List<MemberAccountEc2DeepInspectionStatus.Builder> result = MemberAccountEc2DeepInspectionStatusListCopier.copyToBuilder(this.accountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIds(Collection<MemberAccountEc2DeepInspectionStatus.BuilderImpl> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusListCopier.copyFromBuilder(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatus> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(MemberAccountEc2DeepInspectionStatus ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatus.Builder> ... accountIds) {
            this.accountIds(Stream.of(accountIds).map(c -> (MemberAccountEc2DeepInspectionStatus)((MemberAccountEc2DeepInspectionStatus.Builder)MemberAccountEc2DeepInspectionStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateMemberEc2DeepInspectionStatusRequest build() {
            return new BatchUpdateMemberEc2DeepInspectionStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateMemberEc2DeepInspectionStatusRequest> {
        public Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatus> var1);

        public Builder accountIds(MemberAccountEc2DeepInspectionStatus ... var1);

        public Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatus.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

