/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::accountId)).setter(LambdaFunctionAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionName").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::functionName)).setter(LambdaFunctionAggregationResponse.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()}).build();
    private static final SdkField<Map<String, String>> LAMBDA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("lambdaTags").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::lambdaTags)).setter(LambdaFunctionAggregationResponse.setter(Builder::lambdaTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::lastModifiedAt)).setter(LambdaFunctionAggregationResponse.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::resourceId)).setter(LambdaFunctionAggregationResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::runtime)).setter(LambdaFunctionAggregationResponse.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(LambdaFunctionAggregationResponse.getter(LambdaFunctionAggregationResponse::severityCounts)).setter(LambdaFunctionAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, FUNCTION_NAME_FIELD, LAMBDA_TAGS_FIELD, LAST_MODIFIED_AT_FIELD, RESOURCE_ID_FIELD, RUNTIME_FIELD, SEVERITY_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("functionName", FUNCTION_NAME_FIELD);
            this.put("lambdaTags", LAMBDA_TAGS_FIELD);
            this.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
            this.put("resourceId", RESOURCE_ID_FIELD);
            this.put("runtime", RUNTIME_FIELD);
            this.put("severityCounts", SEVERITY_COUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String functionName;
    private final Map<String, String> lambdaTags;
    private final Instant lastModifiedAt;
    private final String resourceId;
    private final String runtime;
    private final SeverityCounts severityCounts;

    private LambdaFunctionAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.functionName = builder.functionName;
        this.lambdaTags = builder.lambdaTags;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.resourceId = builder.resourceId;
        this.runtime = builder.runtime;
        this.severityCounts = builder.severityCounts;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final boolean hasLambdaTags() {
        return this.lambdaTags != null && !(this.lambdaTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> lambdaTags() {
        return this.lambdaTags;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String runtime() {
        return this.runtime;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaTags() ? this.lambdaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAggregationResponse)) {
            return false;
        }
        LambdaFunctionAggregationResponse other = (LambdaFunctionAggregationResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.functionName(), other.functionName()) && this.hasLambdaTags() == other.hasLambdaTags() && Objects.equals(this.lambdaTags(), other.lambdaTags()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.runtime(), other.runtime()) && Objects.equals(this.severityCounts(), other.severityCounts());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionAggregationResponse").add("AccountId", (Object)this.accountId()).add("FunctionName", (Object)this.functionName()).add("LambdaTags", this.hasLambdaTags() ? this.lambdaTags() : null).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("ResourceId", (Object)this.resourceId()).add("Runtime", (Object)this.runtime()).add("SeverityCounts", (Object)this.severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "functionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "lambdaTags": {
                return Optional.ofNullable(clazz.cast(this.lambdaTags()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtime()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionAggregationResponse, T> g) {
        return obj -> g.apply((LambdaFunctionAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String functionName;
        private Map<String, String> lambdaTags = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastModifiedAt;
        private String resourceId;
        private String runtime;
        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAggregationResponse model) {
            this.accountId(model.accountId);
            this.functionName(model.functionName);
            this.lambdaTags(model.lambdaTags);
            this.lastModifiedAt(model.lastModifiedAt);
            this.resourceId(model.resourceId);
            this.runtime(model.runtime);
            this.severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Map<String, String> getLambdaTags() {
            if (this.lambdaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.lambdaTags;
        }

        public final void setLambdaTags(Map<String, String> lambdaTags) {
            this.lambdaTags = TagMapCopier.copy(lambdaTags);
        }

        @Override
        public final Builder lambdaTags(Map<String, String> lambdaTags) {
            this.lambdaTags = TagMapCopier.copy(lambdaTags);
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public LambdaFunctionAggregationResponse build() {
            return new LambdaFunctionAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionAggregationResponse> {
        public Builder accountId(String var1);

        public Builder functionName(String var1);

        public Builder lambdaTags(Map<String, String> var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder resourceId(String var1);

        public Builder runtime(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }
    }
}

