/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria;
import software.amazon.awssdk.services.inspector2.model.GroupKey;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCoverageStatisticsRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, ListCoverageStatisticsRequest> {
    private static final SdkField<CoverageFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(ListCoverageStatisticsRequest.getter(ListCoverageStatisticsRequest::filterCriteria)).setter(ListCoverageStatisticsRequest.setter(Builder::filterCriteria)).constructor(CoverageFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupBy").getter(ListCoverageStatisticsRequest.getter(ListCoverageStatisticsRequest::groupByAsString)).setter(ListCoverageStatisticsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCoverageStatisticsRequest.getter(ListCoverageStatisticsRequest::nextToken)).setter(ListCoverageStatisticsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, GROUP_BY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("filterCriteria", FILTER_CRITERIA_FIELD);
            this.put("groupBy", GROUP_BY_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final CoverageFilterCriteria filterCriteria;
    private final String groupBy;
    private final String nextToken;

    private ListCoverageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.groupBy = builder.groupBy;
        this.nextToken = builder.nextToken;
    }

    public final CoverageFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final GroupKey groupBy() {
        return GroupKey.fromValue(this.groupBy);
    }

    public final String groupByAsString() {
        return this.groupBy;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageStatisticsRequest)) {
            return false;
        }
        ListCoverageStatisticsRequest other = (ListCoverageStatisticsRequest)((Object)obj);
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.groupByAsString(), other.groupByAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCoverageStatisticsRequest").add("FilterCriteria", (Object)this.filterCriteria()).add("GroupBy", (Object)this.groupByAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageStatisticsRequest, T> g) {
        return obj -> g.apply((ListCoverageStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private CoverageFilterCriteria filterCriteria;
        private String groupBy;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageStatisticsRequest model) {
            super(model);
            this.filterCriteria(model.filterCriteria);
            this.groupBy(model.groupBy);
            this.nextToken(model.nextToken);
        }

        public final CoverageFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CoverageFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CoverageFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupKey groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCoverageStatisticsRequest build() {
            return new ListCoverageStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCoverageStatisticsRequest> {
        public Builder filterCriteria(CoverageFilterCriteria var1);

        default public Builder filterCriteria(Consumer<CoverageFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((CoverageFilterCriteria)((CoverageFilterCriteria.Builder)CoverageFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder groupBy(String var1);

        public Builder groupBy(GroupKey var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

