/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails;
import software.amazon.awssdk.services.inspector2.model.AwsEcrContainerImageDetails;
import software.amazon.awssdk.services.inspector2.model.AwsLambdaFunctionDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDetails> {
    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsEc2Instance").getter(ResourceDetails.getter(ResourceDetails::awsEc2Instance)).setter(ResourceDetails.setter(Builder::awsEc2Instance)).constructor(AwsEc2InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEc2Instance").build()}).build();
    private static final SdkField<AwsEcrContainerImageDetails> AWS_ECR_CONTAINER_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsEcrContainerImage").getter(ResourceDetails.getter(ResourceDetails::awsEcrContainerImage)).setter(ResourceDetails.setter(Builder::awsEcrContainerImage)).constructor(AwsEcrContainerImageDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcrContainerImage").build()}).build();
    private static final SdkField<AwsLambdaFunctionDetails> AWS_LAMBDA_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsLambdaFunction").getter(ResourceDetails.getter(ResourceDetails::awsLambdaFunction)).setter(ResourceDetails.setter(Builder::awsLambdaFunction)).constructor(AwsLambdaFunctionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLambdaFunction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_EC2_INSTANCE_FIELD, AWS_ECR_CONTAINER_IMAGE_FIELD, AWS_LAMBDA_FUNCTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("awsEc2Instance", AWS_EC2_INSTANCE_FIELD);
            this.put("awsEcrContainerImage", AWS_ECR_CONTAINER_IMAGE_FIELD);
            this.put("awsLambdaFunction", AWS_LAMBDA_FUNCTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AwsEc2InstanceDetails awsEc2Instance;
    private final AwsEcrContainerImageDetails awsEcrContainerImage;
    private final AwsLambdaFunctionDetails awsLambdaFunction;

    private ResourceDetails(BuilderImpl builder) {
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsEcrContainerImage = builder.awsEcrContainerImage;
        this.awsLambdaFunction = builder.awsLambdaFunction;
    }

    public final AwsEc2InstanceDetails awsEc2Instance() {
        return this.awsEc2Instance;
    }

    public final AwsEcrContainerImageDetails awsEcrContainerImage() {
        return this.awsEcrContainerImage;
    }

    public final AwsLambdaFunctionDetails awsLambdaFunction() {
        return this.awsLambdaFunction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEcrContainerImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLambdaFunction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails)obj;
        return Objects.equals(this.awsEc2Instance(), other.awsEc2Instance()) && Objects.equals(this.awsEcrContainerImage(), other.awsEcrContainerImage()) && Objects.equals(this.awsLambdaFunction(), other.awsLambdaFunction());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDetails").add("AwsEc2Instance", (Object)this.awsEc2Instance()).add("AwsEcrContainerImage", (Object)this.awsEcrContainerImage()).add("AwsLambdaFunction", (Object)this.awsLambdaFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsEc2Instance": {
                return Optional.ofNullable(clazz.cast(this.awsEc2Instance()));
            }
            case "awsEcrContainerImage": {
                return Optional.ofNullable(clazz.cast(this.awsEcrContainerImage()));
            }
            case "awsLambdaFunction": {
                return Optional.ofNullable(clazz.cast(this.awsLambdaFunction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsEc2InstanceDetails awsEc2Instance;
        private AwsEcrContainerImageDetails awsEcrContainerImage;
        private AwsLambdaFunctionDetails awsLambdaFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            this.awsEc2Instance(model.awsEc2Instance);
            this.awsEcrContainerImage(model.awsEcrContainerImage);
            this.awsLambdaFunction(model.awsLambdaFunction);
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return this.awsEc2Instance != null ? this.awsEc2Instance.toBuilder() : null;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final AwsEcrContainerImageDetails.Builder getAwsEcrContainerImage() {
            return this.awsEcrContainerImage != null ? this.awsEcrContainerImage.toBuilder() : null;
        }

        public final void setAwsEcrContainerImage(AwsEcrContainerImageDetails.BuilderImpl awsEcrContainerImage) {
            this.awsEcrContainerImage = awsEcrContainerImage != null ? awsEcrContainerImage.build() : null;
        }

        @Override
        public final Builder awsEcrContainerImage(AwsEcrContainerImageDetails awsEcrContainerImage) {
            this.awsEcrContainerImage = awsEcrContainerImage;
            return this;
        }

        public final AwsLambdaFunctionDetails.Builder getAwsLambdaFunction() {
            return this.awsLambdaFunction != null ? this.awsLambdaFunction.toBuilder() : null;
        }

        public final void setAwsLambdaFunction(AwsLambdaFunctionDetails.BuilderImpl awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction != null ? awsLambdaFunction.build() : null;
        }

        @Override
        public final Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction;
            return this;
        }

        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDetails> {
        public Builder awsEc2Instance(AwsEc2InstanceDetails var1);

        default public Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return this.awsEc2Instance((AwsEc2InstanceDetails)((AwsEc2InstanceDetails.Builder)AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance)).build());
        }

        public Builder awsEcrContainerImage(AwsEcrContainerImageDetails var1);

        default public Builder awsEcrContainerImage(Consumer<AwsEcrContainerImageDetails.Builder> awsEcrContainerImage) {
            return this.awsEcrContainerImage((AwsEcrContainerImageDetails)((AwsEcrContainerImageDetails.Builder)AwsEcrContainerImageDetails.builder().applyMutation(awsEcrContainerImage)).build());
        }

        public Builder awsLambdaFunction(AwsLambdaFunctionDetails var1);

        default public Builder awsLambdaFunction(Consumer<AwsLambdaFunctionDetails.Builder> awsLambdaFunction) {
            return this.awsLambdaFunction((AwsLambdaFunctionDetails)((AwsLambdaFunctionDetails.Builder)AwsLambdaFunctionDetails.builder().applyMutation(awsLambdaFunction)).build());
        }
    }
}

