/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.PathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEc2DeepInspectionConfigurationRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, UpdateEc2DeepInspectionConfigurationRequest> {
    private static final SdkField<Boolean> ACTIVATE_DEEP_INSPECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("activateDeepInspection").getter(UpdateEc2DeepInspectionConfigurationRequest.getter(UpdateEc2DeepInspectionConfigurationRequest::activateDeepInspection)).setter(UpdateEc2DeepInspectionConfigurationRequest.setter(Builder::activateDeepInspection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activateDeepInspection").build()}).build();
    private static final SdkField<List<String>> PACKAGE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packagePaths").getter(UpdateEc2DeepInspectionConfigurationRequest.getter(UpdateEc2DeepInspectionConfigurationRequest::packagePaths)).setter(UpdateEc2DeepInspectionConfigurationRequest.setter(Builder::packagePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATE_DEEP_INSPECTION_FIELD, PACKAGE_PATHS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("activateDeepInspection", ACTIVATE_DEEP_INSPECTION_FIELD);
            this.put("packagePaths", PACKAGE_PATHS_FIELD);
        }
    });
    private final Boolean activateDeepInspection;
    private final List<String> packagePaths;

    private UpdateEc2DeepInspectionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.activateDeepInspection = builder.activateDeepInspection;
        this.packagePaths = builder.packagePaths;
    }

    public final Boolean activateDeepInspection() {
        return this.activateDeepInspection;
    }

    public final boolean hasPackagePaths() {
        return this.packagePaths != null && !(this.packagePaths instanceof SdkAutoConstructList);
    }

    public final List<String> packagePaths() {
        return this.packagePaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activateDeepInspection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackagePaths() ? this.packagePaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEc2DeepInspectionConfigurationRequest)) {
            return false;
        }
        UpdateEc2DeepInspectionConfigurationRequest other = (UpdateEc2DeepInspectionConfigurationRequest)((Object)obj);
        return Objects.equals(this.activateDeepInspection(), other.activateDeepInspection()) && this.hasPackagePaths() == other.hasPackagePaths() && Objects.equals(this.packagePaths(), other.packagePaths());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEc2DeepInspectionConfigurationRequest").add("ActivateDeepInspection", (Object)this.activateDeepInspection()).add("PackagePaths", this.hasPackagePaths() ? this.packagePaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activateDeepInspection": {
                return Optional.ofNullable(clazz.cast(this.activateDeepInspection()));
            }
            case "packagePaths": {
                return Optional.ofNullable(clazz.cast(this.packagePaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEc2DeepInspectionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateEc2DeepInspectionConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private Boolean activateDeepInspection;
        private List<String> packagePaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEc2DeepInspectionConfigurationRequest model) {
            super(model);
            this.activateDeepInspection(model.activateDeepInspection);
            this.packagePaths(model.packagePaths);
        }

        public final Boolean getActivateDeepInspection() {
            return this.activateDeepInspection;
        }

        public final void setActivateDeepInspection(Boolean activateDeepInspection) {
            this.activateDeepInspection = activateDeepInspection;
        }

        @Override
        public final Builder activateDeepInspection(Boolean activateDeepInspection) {
            this.activateDeepInspection = activateDeepInspection;
            return this;
        }

        public final Collection<String> getPackagePaths() {
            if (this.packagePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.packagePaths;
        }

        public final void setPackagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
        }

        @Override
        public final Builder packagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagePaths(String ... packagePaths) {
            this.packagePaths(Arrays.asList(packagePaths));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEc2DeepInspectionConfigurationRequest build() {
            return new UpdateEc2DeepInspectionConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEc2DeepInspectionConfigurationRequest> {
        public Builder activateDeepInspection(Boolean var1);

        public Builder packagePaths(Collection<String> var1);

        public Builder packagePaths(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

