/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState;
import software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusStateListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState;
import software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateMemberEc2DeepInspectionStatusResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, BatchUpdateMemberEc2DeepInspectionStatusResponse> {
    private static final SdkField<List<MemberAccountEc2DeepInspectionStatusState>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(BatchUpdateMemberEc2DeepInspectionStatusResponse.getter(BatchUpdateMemberEc2DeepInspectionStatusResponse::accountIds)).setter(BatchUpdateMemberEc2DeepInspectionStatusResponse.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberAccountEc2DeepInspectionStatusState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedMemberAccountEc2DeepInspectionStatusState>> FAILED_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedAccountIds").getter(BatchUpdateMemberEc2DeepInspectionStatusResponse.getter(BatchUpdateMemberEc2DeepInspectionStatusResponse::failedAccountIds)).setter(BatchUpdateMemberEc2DeepInspectionStatusResponse.setter(Builder::failedAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedMemberAccountEc2DeepInspectionStatusState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, FAILED_ACCOUNT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountIds", ACCOUNT_IDS_FIELD);
            this.put("failedAccountIds", FAILED_ACCOUNT_IDS_FIELD);
        }
    });
    private final List<MemberAccountEc2DeepInspectionStatusState> accountIds;
    private final List<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds;

    private BatchUpdateMemberEc2DeepInspectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.failedAccountIds = builder.failedAccountIds;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<MemberAccountEc2DeepInspectionStatusState> accountIds() {
        return this.accountIds;
    }

    public final boolean hasFailedAccountIds() {
        return this.failedAccountIds != null && !(this.failedAccountIds instanceof SdkAutoConstructList);
    }

    public final List<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds() {
        return this.failedAccountIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAccountIds() ? this.failedAccountIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateMemberEc2DeepInspectionStatusResponse)) {
            return false;
        }
        BatchUpdateMemberEc2DeepInspectionStatusResponse other = (BatchUpdateMemberEc2DeepInspectionStatusResponse)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasFailedAccountIds() == other.hasFailedAccountIds() && Objects.equals(this.failedAccountIds(), other.failedAccountIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateMemberEc2DeepInspectionStatusResponse").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("FailedAccountIds", this.hasFailedAccountIds() ? this.failedAccountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "failedAccountIds": {
                return Optional.ofNullable(clazz.cast(this.failedAccountIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateMemberEc2DeepInspectionStatusResponse, T> g) {
        return obj -> g.apply((BatchUpdateMemberEc2DeepInspectionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<MemberAccountEc2DeepInspectionStatusState> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateMemberEc2DeepInspectionStatusResponse model) {
            super(model);
            this.accountIds(model.accountIds);
            this.failedAccountIds(model.failedAccountIds);
        }

        public final List<MemberAccountEc2DeepInspectionStatusState.Builder> getAccountIds() {
            List<MemberAccountEc2DeepInspectionStatusState.Builder> result = MemberAccountEc2DeepInspectionStatusStateListCopier.copyToBuilder(this.accountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIds(Collection<MemberAccountEc2DeepInspectionStatusState.BuilderImpl> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusStateListCopier.copyFromBuilder(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatusState> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusStateListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(MemberAccountEc2DeepInspectionStatusState ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatusState.Builder> ... accountIds) {
            this.accountIds(Stream.of(accountIds).map(c -> (MemberAccountEc2DeepInspectionStatusState)((MemberAccountEc2DeepInspectionStatusState.Builder)MemberAccountEc2DeepInspectionStatusState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedMemberAccountEc2DeepInspectionStatusState.Builder> getFailedAccountIds() {
            List<FailedMemberAccountEc2DeepInspectionStatusState.Builder> result = FailedMemberAccountEc2DeepInspectionStatusStateListCopier.copyToBuilder(this.failedAccountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAccountIds(Collection<FailedMemberAccountEc2DeepInspectionStatusState.BuilderImpl> failedAccountIds) {
            this.failedAccountIds = FailedMemberAccountEc2DeepInspectionStatusStateListCopier.copyFromBuilder(failedAccountIds);
        }

        @Override
        public final Builder failedAccountIds(Collection<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds) {
            this.failedAccountIds = FailedMemberAccountEc2DeepInspectionStatusStateListCopier.copy(failedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccountIds(FailedMemberAccountEc2DeepInspectionStatusState ... failedAccountIds) {
            this.failedAccountIds(Arrays.asList(failedAccountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccountIds(Consumer<FailedMemberAccountEc2DeepInspectionStatusState.Builder> ... failedAccountIds) {
            this.failedAccountIds(Stream.of(failedAccountIds).map(c -> (FailedMemberAccountEc2DeepInspectionStatusState)((FailedMemberAccountEc2DeepInspectionStatusState.Builder)FailedMemberAccountEc2DeepInspectionStatusState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateMemberEc2DeepInspectionStatusResponse build() {
            return new BatchUpdateMemberEc2DeepInspectionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateMemberEc2DeepInspectionStatusResponse> {
        public Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatusState> var1);

        public Builder accountIds(MemberAccountEc2DeepInspectionStatusState ... var1);

        public Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatusState.Builder> ... var1);

        public Builder failedAccountIds(Collection<FailedMemberAccountEc2DeepInspectionStatusState> var1);

        public Builder failedAccountIds(FailedMemberAccountEc2DeepInspectionStatusState ... var1);

        public Builder failedAccountIds(Consumer<FailedMemberAccountEc2DeepInspectionStatusState.Builder> ... var1);
    }
}

