/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.VulnIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchVulnerabilitiesFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchVulnerabilitiesFilterCriteria> {
    private static final SdkField<List<String>> VULNERABILITY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vulnerabilityIds").getter(SearchVulnerabilitiesFilterCriteria.getter(SearchVulnerabilitiesFilterCriteria::vulnerabilityIds)).setter(SearchVulnerabilitiesFilterCriteria.setter(Builder::vulnerabilityIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VULNERABILITY_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vulnerabilityIds", VULNERABILITY_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> vulnerabilityIds;

    private SearchVulnerabilitiesFilterCriteria(BuilderImpl builder) {
        this.vulnerabilityIds = builder.vulnerabilityIds;
    }

    public final boolean hasVulnerabilityIds() {
        return this.vulnerabilityIds != null && !(this.vulnerabilityIds instanceof SdkAutoConstructList);
    }

    public final List<String> vulnerabilityIds() {
        return this.vulnerabilityIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerabilityIds() ? this.vulnerabilityIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchVulnerabilitiesFilterCriteria)) {
            return false;
        }
        SearchVulnerabilitiesFilterCriteria other = (SearchVulnerabilitiesFilterCriteria)obj;
        return this.hasVulnerabilityIds() == other.hasVulnerabilityIds() && Objects.equals(this.vulnerabilityIds(), other.vulnerabilityIds());
    }

    public final String toString() {
        return ToString.builder((String)"SearchVulnerabilitiesFilterCriteria").add("VulnerabilityIds", this.hasVulnerabilityIds() ? this.vulnerabilityIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vulnerabilityIds": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilityIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchVulnerabilitiesFilterCriteria, T> g) {
        return obj -> g.apply((SearchVulnerabilitiesFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> vulnerabilityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchVulnerabilitiesFilterCriteria model) {
            this.vulnerabilityIds(model.vulnerabilityIds);
        }

        public final Collection<String> getVulnerabilityIds() {
            if (this.vulnerabilityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vulnerabilityIds;
        }

        public final void setVulnerabilityIds(Collection<String> vulnerabilityIds) {
            this.vulnerabilityIds = VulnIdListCopier.copy(vulnerabilityIds);
        }

        @Override
        public final Builder vulnerabilityIds(Collection<String> vulnerabilityIds) {
            this.vulnerabilityIds = VulnIdListCopier.copy(vulnerabilityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityIds(String ... vulnerabilityIds) {
            this.vulnerabilityIds(Arrays.asList(vulnerabilityIds));
            return this;
        }

        public SearchVulnerabilitiesFilterCriteria build() {
            return new SearchVulnerabilitiesFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchVulnerabilitiesFilterCriteria> {
        public Builder vulnerabilityIds(Collection<String> var1);

        public Builder vulnerabilityIds(String ... var1);
    }
}

