/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CisSessionMessage;
import software.amazon.awssdk.services.inspector2.model.CisSessionMessagesCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendCisSessionTelemetryRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, SendCisSessionTelemetryRequest> {
    private static final SdkField<List<CisSessionMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(SendCisSessionTelemetryRequest.getter(SendCisSessionTelemetryRequest::messages)).setter(SendCisSessionTelemetryRequest.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisSessionMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanJobId").getter(SendCisSessionTelemetryRequest.getter(SendCisSessionTelemetryRequest::scanJobId)).setter(SendCisSessionTelemetryRequest.setter(Builder::scanJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanJobId").build()}).build();
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionToken").getter(SendCisSessionTelemetryRequest.getter(SendCisSessionTelemetryRequest::sessionToken)).setter(SendCisSessionTelemetryRequest.setter(Builder::sessionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD, SCAN_JOB_ID_FIELD, SESSION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("messages", MESSAGES_FIELD);
            this.put("scanJobId", SCAN_JOB_ID_FIELD);
            this.put("sessionToken", SESSION_TOKEN_FIELD);
        }
    });
    private final List<CisSessionMessage> messages;
    private final String scanJobId;
    private final String sessionToken;

    private SendCisSessionTelemetryRequest(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.scanJobId = builder.scanJobId;
        this.sessionToken = builder.sessionToken;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<CisSessionMessage> messages() {
        return this.messages;
    }

    public final String scanJobId() {
        return this.scanJobId;
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCisSessionTelemetryRequest)) {
            return false;
        }
        SendCisSessionTelemetryRequest other = (SendCisSessionTelemetryRequest)((Object)obj);
        return this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.scanJobId(), other.scanJobId()) && Objects.equals(this.sessionToken(), other.sessionToken());
    }

    public final String toString() {
        return ToString.builder((String)"SendCisSessionTelemetryRequest").add("Messages", this.hasMessages() ? this.messages() : null).add("ScanJobId", (Object)this.scanJobId()).add("SessionToken", (Object)this.sessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "scanJobId": {
                return Optional.ofNullable(clazz.cast(this.scanJobId()));
            }
            case "sessionToken": {
                return Optional.ofNullable(clazz.cast(this.sessionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendCisSessionTelemetryRequest, T> g) {
        return obj -> g.apply((SendCisSessionTelemetryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private List<CisSessionMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private String scanJobId;
        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCisSessionTelemetryRequest model) {
            super(model);
            this.messages(model.messages);
            this.scanJobId(model.scanJobId);
            this.sessionToken(model.sessionToken);
        }

        public final List<CisSessionMessage.Builder> getMessages() {
            List<CisSessionMessage.Builder> result = CisSessionMessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<CisSessionMessage.BuilderImpl> messages) {
            this.messages = CisSessionMessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<CisSessionMessage> messages) {
            this.messages = CisSessionMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(CisSessionMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<CisSessionMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (CisSessionMessage)((CisSessionMessage.Builder)CisSessionMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScanJobId() {
            return this.scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCisSessionTelemetryRequest build() {
            return new SendCisSessionTelemetryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendCisSessionTelemetryRequest> {
        public Builder messages(Collection<CisSessionMessage> var1);

        public Builder messages(CisSessionMessage ... var1);

        public Builder messages(Consumer<CisSessionMessage.Builder> ... var1);

        public Builder scanJobId(String var1);

        public Builder sessionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

