/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AggregationFindingType;
import software.amazon.awssdk.services.inspector2.model.AggregationResourceType;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.TitleSortBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TitleAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TitleAggregation> {
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingType").getter(TitleAggregation.getter(TitleAggregation::findingTypeAsString)).setter(TitleAggregation.setter(Builder::findingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(TitleAggregation.getter(TitleAggregation::resourceTypeAsString)).setter(TitleAggregation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(TitleAggregation.getter(TitleAggregation::sortByAsString)).setter(TitleAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(TitleAggregation.getter(TitleAggregation::sortOrderAsString)).setter(TitleAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<List<StringFilter>> TITLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("titles").getter(TitleAggregation.getter(TitleAggregation::titles)).setter(TitleAggregation.setter(Builder::titles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> VULNERABILITY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vulnerabilityIds").getter(TitleAggregation.getter(TitleAggregation::vulnerabilityIds)).setter(TitleAggregation.setter(Builder::vulnerabilityIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPE_FIELD, RESOURCE_TYPE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, TITLES_FIELD, VULNERABILITY_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TitleAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String findingType;
    private final String resourceType;
    private final String sortBy;
    private final String sortOrder;
    private final List<StringFilter> titles;
    private final List<StringFilter> vulnerabilityIds;

    private TitleAggregation(BuilderImpl builder) {
        this.findingType = builder.findingType;
        this.resourceType = builder.resourceType;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.titles = builder.titles;
        this.vulnerabilityIds = builder.vulnerabilityIds;
    }

    public final AggregationFindingType findingType() {
        return AggregationFindingType.fromValue(this.findingType);
    }

    public final String findingTypeAsString() {
        return this.findingType;
    }

    public final AggregationResourceType resourceType() {
        return AggregationResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final TitleSortBy sortBy() {
        return TitleSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final boolean hasTitles() {
        return this.titles != null && !(this.titles instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> titles() {
        return this.titles;
    }

    public final boolean hasVulnerabilityIds() {
        return this.vulnerabilityIds != null && !(this.vulnerabilityIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> vulnerabilityIds() {
        return this.vulnerabilityIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTitles() ? this.titles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerabilityIds() ? this.vulnerabilityIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TitleAggregation)) {
            return false;
        }
        TitleAggregation other = (TitleAggregation)obj;
        return Objects.equals(this.findingTypeAsString(), other.findingTypeAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && this.hasTitles() == other.hasTitles() && Objects.equals(this.titles(), other.titles()) && this.hasVulnerabilityIds() == other.hasVulnerabilityIds() && Objects.equals(this.vulnerabilityIds(), other.vulnerabilityIds());
    }

    public final String toString() {
        return ToString.builder((String)"TitleAggregation").add("FindingType", (Object)this.findingTypeAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("Titles", this.hasTitles() ? this.titles() : null).add("VulnerabilityIds", this.hasVulnerabilityIds() ? this.vulnerabilityIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingType": {
                return Optional.ofNullable(clazz.cast(this.findingTypeAsString()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "titles": {
                return Optional.ofNullable(clazz.cast(this.titles()));
            }
            case "vulnerabilityIds": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilityIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingType", FINDING_TYPE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("titles", TITLES_FIELD);
        map.put("vulnerabilityIds", VULNERABILITY_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TitleAggregation, T> g) {
        return obj -> g.apply((TitleAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingType;
        private String resourceType;
        private String sortBy;
        private String sortOrder;
        private List<StringFilter> titles = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> vulnerabilityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TitleAggregation model) {
            this.findingType(model.findingType);
            this.resourceType(model.resourceType);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.titles(model.titles);
            this.vulnerabilityIds(model.vulnerabilityIds);
        }

        public final String getFindingType() {
            return this.findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(AggregationFindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(AggregationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(TitleSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final List<StringFilter.Builder> getTitles() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.titles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitles(Collection<StringFilter.BuilderImpl> titles) {
            this.titles = StringFilterListCopier.copyFromBuilder(titles);
        }

        @Override
        public final Builder titles(Collection<StringFilter> titles) {
            this.titles = StringFilterListCopier.copy(titles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titles(StringFilter ... titles) {
            this.titles(Arrays.asList(titles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titles(Consumer<StringFilter.Builder> ... titles) {
            this.titles(Stream.of(titles).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getVulnerabilityIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.vulnerabilityIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilityIds(Collection<StringFilter.BuilderImpl> vulnerabilityIds) {
            this.vulnerabilityIds = StringFilterListCopier.copyFromBuilder(vulnerabilityIds);
        }

        @Override
        public final Builder vulnerabilityIds(Collection<StringFilter> vulnerabilityIds) {
            this.vulnerabilityIds = StringFilterListCopier.copy(vulnerabilityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityIds(StringFilter ... vulnerabilityIds) {
            this.vulnerabilityIds(Arrays.asList(vulnerabilityIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityIds(Consumer<StringFilter.Builder> ... vulnerabilityIds) {
            this.vulnerabilityIds(Stream.of(vulnerabilityIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TitleAggregation build() {
            return new TitleAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TitleAggregation> {
        public Builder findingType(String var1);

        public Builder findingType(AggregationFindingType var1);

        public Builder resourceType(String var1);

        public Builder resourceType(AggregationResourceType var1);

        public Builder sortBy(String var1);

        public Builder sortBy(TitleSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder titles(Collection<StringFilter> var1);

        public Builder titles(StringFilter ... var1);

        public Builder titles(Consumer<StringFilter.Builder> ... var1);

        public Builder vulnerabilityIds(Collection<StringFilter> var1);

        public Builder vulnerabilityIds(StringFilter ... var1);

        public Builder vulnerabilityIds(Consumer<StringFilter.Builder> ... var1);
    }
}

