/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation of findings by Amazon Web Services account ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAggregationResponse.Builder, AccountAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AccountAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Long> EXPLOIT_AVAILABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("exploitAvailableCount").getter(getter(AccountAggregationResponse::exploitAvailableCount))
            .setter(setter(Builder::exploitAvailableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailableCount").build())
            .build();

    private static final SdkField<Long> FIX_AVAILABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("fixAvailableCount").getter(getter(AccountAggregationResponse::fixAvailableCount))
            .setter(setter(Builder::fixAvailableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailableCount").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(AccountAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            EXPLOIT_AVAILABLE_COUNT_FIELD, FIX_AVAILABLE_COUNT_FIELD, SEVERITY_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Long exploitAvailableCount;

    private final Long fixAvailableCount;

    private final SeverityCounts severityCounts;

    private AccountAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.exploitAvailableCount = builder.exploitAvailableCount;
        this.fixAvailableCount = builder.fixAvailableCount;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The number of findings that have an exploit available.
     * </p>
     * 
     * @return The number of findings that have an exploit available.
     */
    public final Long exploitAvailableCount() {
        return exploitAvailableCount;
    }

    /**
     * <p>
     * Details about the number of fixes.
     * </p>
     * 
     * @return Details about the number of fixes.
     */
    public final Long fixAvailableCount() {
        return fixAvailableCount;
    }

    /**
     * <p>
     * The number of findings by severity.
     * </p>
     * 
     * @return The number of findings by severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(exploitAvailableCount());
        hashCode = 31 * hashCode + Objects.hashCode(fixAvailableCount());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAggregationResponse)) {
            return false;
        }
        AccountAggregationResponse other = (AccountAggregationResponse) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(exploitAvailableCount(), other.exploitAvailableCount())
                && Objects.equals(fixAvailableCount(), other.fixAvailableCount())
                && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountAggregationResponse").add("AccountId", accountId())
                .add("ExploitAvailableCount", exploitAvailableCount()).add("FixAvailableCount", fixAvailableCount())
                .add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "exploitAvailableCount":
            return Optional.ofNullable(clazz.cast(exploitAvailableCount()));
        case "fixAvailableCount":
            return Optional.ofNullable(clazz.cast(fixAvailableCount()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("exploitAvailableCount", EXPLOIT_AVAILABLE_COUNT_FIELD);
        map.put("fixAvailableCount", FIX_AVAILABLE_COUNT_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAggregationResponse, T> g) {
        return obj -> g.apply((AccountAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAggregationResponse> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The number of findings that have an exploit available.
         * </p>
         * 
         * @param exploitAvailableCount
         *        The number of findings that have an exploit available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exploitAvailableCount(Long exploitAvailableCount);

        /**
         * <p>
         * Details about the number of fixes.
         * </p>
         * 
         * @param fixAvailableCount
         *        Details about the number of fixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixAvailableCount(Long fixAvailableCount);

        /**
         * <p>
         * The number of findings by severity.
         * </p>
         * 
         * @param severityCounts
         *        The number of findings by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * The number of findings by severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Long exploitAvailableCount;

        private Long fixAvailableCount;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAggregationResponse model) {
            accountId(model.accountId);
            exploitAvailableCount(model.exploitAvailableCount);
            fixAvailableCount(model.fixAvailableCount);
            severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Long getExploitAvailableCount() {
            return exploitAvailableCount;
        }

        public final void setExploitAvailableCount(Long exploitAvailableCount) {
            this.exploitAvailableCount = exploitAvailableCount;
        }

        @Override
        public final Builder exploitAvailableCount(Long exploitAvailableCount) {
            this.exploitAvailableCount = exploitAvailableCount;
            return this;
        }

        public final Long getFixAvailableCount() {
            return fixAvailableCount;
        }

        public final void setFixAvailableCount(Long fixAvailableCount) {
            this.fixAvailableCount = fixAvailableCount;
        }

        @Override
        public final Builder fixAvailableCount(Long fixAvailableCount) {
            this.fixAvailableCount = fixAvailableCount;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public AccountAggregationResponse build() {
            return new AccountAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
