/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Threat Intel Group (ATIG) details for a specific vulnerability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AtigData implements SdkPojo, Serializable, ToCopyableBuilder<AtigData.Builder, AtigData> {
    private static final SdkField<Instant> FIRST_SEEN_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstSeen").getter(getter(AtigData::firstSeen)).setter(setter(Builder::firstSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeen").build()).build();

    private static final SdkField<Instant> LAST_SEEN_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastSeen").getter(getter(AtigData::lastSeen)).setter(setter(Builder::lastSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeen").build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targets")
            .getter(getter(AtigData::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TTPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ttps")
            .getter(getter(AtigData::ttps))
            .setter(setter(Builder::ttps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_SEEN_FIELD,
            LAST_SEEN_FIELD, TARGETS_FIELD, TTPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant firstSeen;

    private final Instant lastSeen;

    private final List<String> targets;

    private final List<String> ttps;

    private AtigData(BuilderImpl builder) {
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
        this.targets = builder.targets;
        this.ttps = builder.ttps;
    }

    /**
     * <p>
     * The date and time this vulnerability was first observed.
     * </p>
     * 
     * @return The date and time this vulnerability was first observed.
     */
    public final Instant firstSeen() {
        return firstSeen;
    }

    /**
     * <p>
     * The date and time this vulnerability was last observed.
     * </p>
     * 
     * @return The date and time this vulnerability was last observed.
     */
    public final Instant lastSeen() {
        return lastSeen;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The commercial sectors this vulnerability targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The commercial sectors this vulnerability targets.
     */
    public final List<String> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ttps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTtps() {
        return ttps != null && !(ttps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures (TTPs)
     * associated with vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTtps} method.
     * </p>
     * 
     * @return The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures (TTPs)
     *         associated with vulnerability.
     */
    public final List<String> ttps() {
        return ttps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTtps() ? ttps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtigData)) {
            return false;
        }
        AtigData other = (AtigData) obj;
        return Objects.equals(firstSeen(), other.firstSeen()) && Objects.equals(lastSeen(), other.lastSeen())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasTtps() == other.hasTtps() && Objects.equals(ttps(), other.ttps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AtigData").add("FirstSeen", firstSeen()).add("LastSeen", lastSeen())
                .add("Targets", hasTargets() ? targets() : null).add("Ttps", hasTtps() ? ttps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "firstSeen":
            return Optional.ofNullable(clazz.cast(firstSeen()));
        case "lastSeen":
            return Optional.ofNullable(clazz.cast(lastSeen()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "ttps":
            return Optional.ofNullable(clazz.cast(ttps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("firstSeen", FIRST_SEEN_FIELD);
        map.put("lastSeen", LAST_SEEN_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("ttps", TTPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AtigData, T> g) {
        return obj -> g.apply((AtigData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AtigData> {
        /**
         * <p>
         * The date and time this vulnerability was first observed.
         * </p>
         * 
         * @param firstSeen
         *        The date and time this vulnerability was first observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSeen(Instant firstSeen);

        /**
         * <p>
         * The date and time this vulnerability was last observed.
         * </p>
         * 
         * @param lastSeen
         *        The date and time this vulnerability was last observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeen(Instant lastSeen);

        /**
         * <p>
         * The commercial sectors this vulnerability targets.
         * </p>
         * 
         * @param targets
         *        The commercial sectors this vulnerability targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The commercial sectors this vulnerability targets.
         * </p>
         * 
         * @param targets
         *        The commercial sectors this vulnerability targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures (TTPs)
         * associated with vulnerability.
         * </p>
         * 
         * @param ttps
         *        The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures
         *        (TTPs) associated with vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttps(Collection<String> ttps);

        /**
         * <p>
         * The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures (TTPs)
         * associated with vulnerability.
         * </p>
         * 
         * @param ttps
         *        The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures
         *        (TTPs) associated with vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttps(String... ttps);
    }

    static final class BuilderImpl implements Builder {
        private Instant firstSeen;

        private Instant lastSeen;

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private List<String> ttps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AtigData model) {
            firstSeen(model.firstSeen);
            lastSeen(model.lastSeen);
            targets(model.targets);
            ttps(model.ttps);
        }

        public final Instant getFirstSeen() {
            return firstSeen;
        }

        public final void setFirstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final Instant getLastSeen() {
            return lastSeen;
        }

        public final void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final Collection<String> getTtps() {
            if (ttps instanceof SdkAutoConstructList) {
                return null;
            }
            return ttps;
        }

        public final void setTtps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
        }

        @Override
        public final Builder ttps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ttps(String... ttps) {
            ttps(Arrays.asList(ttps));
            return this;
        }

        @Override
        public AtigData build() {
            return new AtigData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
