/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCodeSnippetResponse extends Inspector2Response implements
        ToCopyableBuilder<BatchGetCodeSnippetResponse.Builder, BatchGetCodeSnippetResponse> {
    private static final SdkField<List<CodeSnippetResult>> CODE_SNIPPET_RESULTS_FIELD = SdkField
            .<List<CodeSnippetResult>> builder(MarshallingType.LIST)
            .memberName("codeSnippetResults")
            .getter(getter(BatchGetCodeSnippetResponse::codeSnippetResults))
            .setter(setter(Builder::codeSnippetResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSnippetResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeSnippetResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeSnippetResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CodeSnippetError>> ERRORS_FIELD = SdkField
            .<List<CodeSnippetError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetCodeSnippetResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeSnippetError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeSnippetError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SNIPPET_RESULTS_FIELD,
            ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CodeSnippetResult> codeSnippetResults;

    private final List<CodeSnippetError> errors;

    private BatchGetCodeSnippetResponse(BuilderImpl builder) {
        super(builder);
        this.codeSnippetResults = builder.codeSnippetResults;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeSnippetResults property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCodeSnippetResults() {
        return codeSnippetResults != null && !(codeSnippetResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retrieved code snippets associated with the provided finding ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeSnippetResults} method.
     * </p>
     * 
     * @return The retrieved code snippets associated with the provided finding ARNs.
     */
    public final List<CodeSnippetResult> codeSnippetResults() {
        return codeSnippetResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
     */
    public final List<CodeSnippetError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeSnippetResults() ? codeSnippetResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCodeSnippetResponse)) {
            return false;
        }
        BatchGetCodeSnippetResponse other = (BatchGetCodeSnippetResponse) obj;
        return hasCodeSnippetResults() == other.hasCodeSnippetResults()
                && Objects.equals(codeSnippetResults(), other.codeSnippetResults()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCodeSnippetResponse")
                .add("CodeSnippetResults", hasCodeSnippetResults() ? codeSnippetResults() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeSnippetResults":
            return Optional.ofNullable(clazz.cast(codeSnippetResults()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeSnippetResults", CODE_SNIPPET_RESULTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCodeSnippetResponse, T> g) {
        return obj -> g.apply((BatchGetCodeSnippetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCodeSnippetResponse> {
        /**
         * <p>
         * The retrieved code snippets associated with the provided finding ARNs.
         * </p>
         * 
         * @param codeSnippetResults
         *        The retrieved code snippets associated with the provided finding ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSnippetResults(Collection<CodeSnippetResult> codeSnippetResults);

        /**
         * <p>
         * The retrieved code snippets associated with the provided finding ARNs.
         * </p>
         * 
         * @param codeSnippetResults
         *        The retrieved code snippets associated with the provided finding ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSnippetResults(CodeSnippetResult... codeSnippetResults);

        /**
         * <p>
         * The retrieved code snippets associated with the provided finding ARNs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetResult.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetResult.Builder#build()} is called
         * immediately and its result is passed to {@link #codeSnippetResults(List<CodeSnippetResult>)}.
         * 
         * @param codeSnippetResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSnippetResults(java.util.Collection<CodeSnippetResult>)
         */
        Builder codeSnippetResults(Consumer<CodeSnippetResult.Builder>... codeSnippetResults);

        /**
         * <p>
         * Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
         * </p>
         * 
         * @param errors
         *        Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<CodeSnippetError> errors);

        /**
         * <p>
         * Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
         * </p>
         * 
         * @param errors
         *        Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(CodeSnippetError... errors);

        /**
         * <p>
         * Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<CodeSnippetError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CodeSnippetError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<CodeSnippetError>)
         */
        Builder errors(Consumer<CodeSnippetError.Builder>... errors);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<CodeSnippetResult> codeSnippetResults = DefaultSdkAutoConstructList.getInstance();

        private List<CodeSnippetError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCodeSnippetResponse model) {
            super(model);
            codeSnippetResults(model.codeSnippetResults);
            errors(model.errors);
        }

        public final List<CodeSnippetResult.Builder> getCodeSnippetResults() {
            List<CodeSnippetResult.Builder> result = CodeSnippetResultListCopier.copyToBuilder(this.codeSnippetResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeSnippetResults(Collection<CodeSnippetResult.BuilderImpl> codeSnippetResults) {
            this.codeSnippetResults = CodeSnippetResultListCopier.copyFromBuilder(codeSnippetResults);
        }

        @Override
        public final Builder codeSnippetResults(Collection<CodeSnippetResult> codeSnippetResults) {
            this.codeSnippetResults = CodeSnippetResultListCopier.copy(codeSnippetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippetResults(CodeSnippetResult... codeSnippetResults) {
            codeSnippetResults(Arrays.asList(codeSnippetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippetResults(Consumer<CodeSnippetResult.Builder>... codeSnippetResults) {
            codeSnippetResults(Stream.of(codeSnippetResults).map(c -> CodeSnippetResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CodeSnippetError.Builder> getErrors() {
            List<CodeSnippetError.Builder> result = CodeSnippetErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CodeSnippetError.BuilderImpl> errors) {
            this.errors = CodeSnippetErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CodeSnippetError> errors) {
            this.errors = CodeSnippetErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CodeSnippetError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CodeSnippetError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> CodeSnippetError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCodeSnippetResponse build() {
            return new BatchGetCodeSnippetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
