/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFindingDetailsResponse extends Inspector2Response implements
        ToCopyableBuilder<BatchGetFindingDetailsResponse.Builder, BatchGetFindingDetailsResponse> {
    private static final SdkField<List<FindingDetailsError>> ERRORS_FIELD = SdkField
            .<List<FindingDetailsError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetFindingDetailsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingDetailsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingDetailsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FindingDetail>> FINDING_DETAILS_FIELD = SdkField
            .<List<FindingDetail>> builder(MarshallingType.LIST)
            .memberName("findingDetails")
            .getter(getter(BatchGetFindingDetailsResponse::findingDetails))
            .setter(setter(Builder::findingDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            FINDING_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FindingDetailsError> errors;

    private final List<FindingDetail> findingDetails;

    private BatchGetFindingDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.findingDetails = builder.findingDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error information for findings that details could not be returned for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Error information for findings that details could not be returned for.
     */
    public final List<FindingDetailsError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingDetails() {
        return findingDetails != null && !(findingDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding's vulnerability details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingDetails} method.
     * </p>
     * 
     * @return A finding's vulnerability details.
     */
    public final List<FindingDetail> findingDetails() {
        return findingDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingDetails() ? findingDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingDetailsResponse)) {
            return false;
        }
        BatchGetFindingDetailsResponse other = (BatchGetFindingDetailsResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasFindingDetails() == other.hasFindingDetails() && Objects.equals(findingDetails(), other.findingDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFindingDetailsResponse").add("Errors", hasErrors() ? errors() : null)
                .add("FindingDetails", hasFindingDetails() ? findingDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "findingDetails":
            return Optional.ofNullable(clazz.cast(findingDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errors", ERRORS_FIELD);
        map.put("findingDetails", FINDING_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingDetailsResponse, T> g) {
        return obj -> g.apply((BatchGetFindingDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetFindingDetailsResponse> {
        /**
         * <p>
         * Error information for findings that details could not be returned for.
         * </p>
         * 
         * @param errors
         *        Error information for findings that details could not be returned for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<FindingDetailsError> errors);

        /**
         * <p>
         * Error information for findings that details could not be returned for.
         * </p>
         * 
         * @param errors
         *        Error information for findings that details could not be returned for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(FindingDetailsError... errors);

        /**
         * <p>
         * Error information for findings that details could not be returned for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FindingDetailsError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.FindingDetailsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FindingDetailsError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<FindingDetailsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FindingDetailsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<FindingDetailsError>)
         */
        Builder errors(Consumer<FindingDetailsError.Builder>... errors);

        /**
         * <p>
         * A finding's vulnerability details.
         * </p>
         * 
         * @param findingDetails
         *        A finding's vulnerability details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingDetails(Collection<FindingDetail> findingDetails);

        /**
         * <p>
         * A finding's vulnerability details.
         * </p>
         * 
         * @param findingDetails
         *        A finding's vulnerability details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingDetails(FindingDetail... findingDetails);

        /**
         * <p>
         * A finding's vulnerability details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FindingDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.FindingDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FindingDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #findingDetails(List<FindingDetail>)}.
         * 
         * @param findingDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FindingDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingDetails(java.util.Collection<FindingDetail>)
         */
        Builder findingDetails(Consumer<FindingDetail.Builder>... findingDetails);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<FindingDetailsError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<FindingDetail> findingDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingDetailsResponse model) {
            super(model);
            errors(model.errors);
            findingDetails(model.findingDetails);
        }

        public final List<FindingDetailsError.Builder> getErrors() {
            List<FindingDetailsError.Builder> result = FindingDetailsErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FindingDetailsError.BuilderImpl> errors) {
            this.errors = FindingDetailsErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FindingDetailsError> errors) {
            this.errors = FindingDetailsErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FindingDetailsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FindingDetailsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> FindingDetailsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FindingDetail.Builder> getFindingDetails() {
            List<FindingDetail.Builder> result = FindingDetailsCopier.copyToBuilder(this.findingDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingDetails(Collection<FindingDetail.BuilderImpl> findingDetails) {
            this.findingDetails = FindingDetailsCopier.copyFromBuilder(findingDetails);
        }

        @Override
        public final Builder findingDetails(Collection<FindingDetail> findingDetails) {
            this.findingDetails = FindingDetailsCopier.copy(findingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(FindingDetail... findingDetails) {
            findingDetails(Arrays.asList(findingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(Consumer<FindingDetail.Builder>... findingDetails) {
            findingDetails(Stream.of(findingDetails).map(c -> FindingDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFindingDetailsResponse build() {
            return new BatchGetFindingDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
