/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateMemberEc2DeepInspectionStatusRequest extends Inspector2Request
        implements
        ToCopyableBuilder<BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder, BatchUpdateMemberEc2DeepInspectionStatusRequest> {
    private static final SdkField<List<MemberAccountEc2DeepInspectionStatus>> ACCOUNT_IDS_FIELD = SdkField
            .<List<MemberAccountEc2DeepInspectionStatus>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(BatchUpdateMemberEc2DeepInspectionStatusRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberAccountEc2DeepInspectionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberAccountEc2DeepInspectionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MemberAccountEc2DeepInspectionStatus> accountIds;

    private BatchUpdateMemberEc2DeepInspectionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection status
     * for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection
     *         status for.
     */
    public final List<MemberAccountEc2DeepInspectionStatus> accountIds() {
        return accountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateMemberEc2DeepInspectionStatusRequest)) {
            return false;
        }
        BatchUpdateMemberEc2DeepInspectionStatusRequest other = (BatchUpdateMemberEc2DeepInspectionStatusRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateMemberEc2DeepInspectionStatusRequest")
                .add("AccountIds", hasAccountIds() ? accountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateMemberEc2DeepInspectionStatusRequest, T> g) {
        return obj -> g.apply((BatchUpdateMemberEc2DeepInspectionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateMemberEc2DeepInspectionStatusRequest> {
        /**
         * <p>
         * The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection status
         * for.
         * </p>
         * 
         * @param accountIds
         *        The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection
         *        status for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatus> accountIds);

        /**
         * <p>
         * The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection status
         * for.
         * </p>
         * 
         * @param accountIds
         *        The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection
         *        status for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(MemberAccountEc2DeepInspectionStatus... accountIds);

        /**
         * <p>
         * The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection status
         * for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #accountIds(List<MemberAccountEc2DeepInspectionStatus>)}.
         * 
         * @param accountIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountIds(java.util.Collection<MemberAccountEc2DeepInspectionStatus>)
         */
        Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatus.Builder>... accountIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private List<MemberAccountEc2DeepInspectionStatus> accountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateMemberEc2DeepInspectionStatusRequest model) {
            super(model);
            accountIds(model.accountIds);
        }

        public final List<MemberAccountEc2DeepInspectionStatus.Builder> getAccountIds() {
            List<MemberAccountEc2DeepInspectionStatus.Builder> result = MemberAccountEc2DeepInspectionStatusListCopier
                    .copyToBuilder(this.accountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIds(Collection<MemberAccountEc2DeepInspectionStatus.BuilderImpl> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusListCopier.copyFromBuilder(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatus> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(MemberAccountEc2DeepInspectionStatus... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatus.Builder>... accountIds) {
            accountIds(Stream.of(accountIds).map(c -> MemberAccountEc2DeepInspectionStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateMemberEc2DeepInspectionStatusRequest build() {
            return new BatchUpdateMemberEc2DeepInspectionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
