/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS number filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisNumberFilter implements SdkPojo, Serializable, ToCopyableBuilder<CisNumberFilter.Builder, CisNumberFilter> {
    private static final SdkField<Integer> LOWER_INCLUSIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("lowerInclusive").getter(getter(CisNumberFilter::lowerInclusive)).setter(setter(Builder::lowerInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lowerInclusive").build()).build();

    private static final SdkField<Integer> UPPER_INCLUSIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("upperInclusive").getter(getter(CisNumberFilter::upperInclusive)).setter(setter(Builder::upperInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperInclusive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOWER_INCLUSIVE_FIELD,
            UPPER_INCLUSIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer lowerInclusive;

    private final Integer upperInclusive;

    private CisNumberFilter(BuilderImpl builder) {
        this.lowerInclusive = builder.lowerInclusive;
        this.upperInclusive = builder.upperInclusive;
    }

    /**
     * <p>
     * The CIS number filter's lower inclusive.
     * </p>
     * 
     * @return The CIS number filter's lower inclusive.
     */
    public final Integer lowerInclusive() {
        return lowerInclusive;
    }

    /**
     * <p>
     * The CIS number filter's upper inclusive.
     * </p>
     * 
     * @return The CIS number filter's upper inclusive.
     */
    public final Integer upperInclusive() {
        return upperInclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lowerInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(upperInclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisNumberFilter)) {
            return false;
        }
        CisNumberFilter other = (CisNumberFilter) obj;
        return Objects.equals(lowerInclusive(), other.lowerInclusive())
                && Objects.equals(upperInclusive(), other.upperInclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisNumberFilter").add("LowerInclusive", lowerInclusive())
                .add("UpperInclusive", upperInclusive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lowerInclusive":
            return Optional.ofNullable(clazz.cast(lowerInclusive()));
        case "upperInclusive":
            return Optional.ofNullable(clazz.cast(upperInclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lowerInclusive", LOWER_INCLUSIVE_FIELD);
        map.put("upperInclusive", UPPER_INCLUSIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisNumberFilter, T> g) {
        return obj -> g.apply((CisNumberFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisNumberFilter> {
        /**
         * <p>
         * The CIS number filter's lower inclusive.
         * </p>
         * 
         * @param lowerInclusive
         *        The CIS number filter's lower inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerInclusive(Integer lowerInclusive);

        /**
         * <p>
         * The CIS number filter's upper inclusive.
         * </p>
         * 
         * @param upperInclusive
         *        The CIS number filter's upper inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperInclusive(Integer upperInclusive);
    }

    static final class BuilderImpl implements Builder {
        private Integer lowerInclusive;

        private Integer upperInclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(CisNumberFilter model) {
            lowerInclusive(model.lowerInclusive);
            upperInclusive(model.upperInclusive);
        }

        public final Integer getLowerInclusive() {
            return lowerInclusive;
        }

        public final void setLowerInclusive(Integer lowerInclusive) {
            this.lowerInclusive = lowerInclusive;
        }

        @Override
        public final Builder lowerInclusive(Integer lowerInclusive) {
            this.lowerInclusive = lowerInclusive;
            return this;
        }

        public final Integer getUpperInclusive() {
            return upperInclusive;
        }

        public final void setUpperInclusive(Integer upperInclusive) {
            this.upperInclusive = upperInclusive;
        }

        @Override
        public final Builder upperInclusive(Integer upperInclusive) {
            this.upperInclusive = upperInclusive;
            return this;
        }

        @Override
        public CisNumberFilter build() {
            return new CisNumberFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
