/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS scan result details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisScanResultDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CisScanResultDetails.Builder, CisScanResultDetails> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CisScanResultDetails::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> CHECK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkDescription").getter(getter(CisScanResultDetails::checkDescription))
            .setter(setter(Builder::checkDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkDescription").build()).build();

    private static final SdkField<String> CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkId").getter(getter(CisScanResultDetails::checkId)).setter(setter(Builder::checkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()).build();

    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingArn").getter(getter(CisScanResultDetails::findingArn)).setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("level")
            .getter(getter(CisScanResultDetails::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(CisScanResultDetails::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> REMEDIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remediation").getter(getter(CisScanResultDetails::remediation)).setter(setter(Builder::remediation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(CisScanResultDetails::scanArn)).setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CisScanResultDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CisScanResultDetails::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceId").getter(getter(CisScanResultDetails::targetResourceId))
            .setter(setter(Builder::targetResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(CisScanResultDetails::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CHECK_DESCRIPTION_FIELD, CHECK_ID_FIELD, FINDING_ARN_FIELD, LEVEL_FIELD, PLATFORM_FIELD, REMEDIATION_FIELD,
            SCAN_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TARGET_RESOURCE_ID_FIELD, TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String checkDescription;

    private final String checkId;

    private final String findingArn;

    private final String level;

    private final String platform;

    private final String remediation;

    private final String scanArn;

    private final String status;

    private final String statusReason;

    private final String targetResourceId;

    private final String title;

    private CisScanResultDetails(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.checkDescription = builder.checkDescription;
        this.checkId = builder.checkId;
        this.findingArn = builder.findingArn;
        this.level = builder.level;
        this.platform = builder.platform;
        this.remediation = builder.remediation;
        this.scanArn = builder.scanArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.targetResourceId = builder.targetResourceId;
        this.title = builder.title;
    }

    /**
     * <p>
     * The CIS scan result details' account ID.
     * </p>
     * 
     * @return The CIS scan result details' account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The account ID that's associated with the CIS scan result details.
     * </p>
     * 
     * @return The account ID that's associated with the CIS scan result details.
     */
    public final String checkDescription() {
        return checkDescription;
    }

    /**
     * <p>
     * The CIS scan result details' check ID.
     * </p>
     * 
     * @return The CIS scan result details' check ID.
     */
    public final String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The CIS scan result details' finding ARN.
     * </p>
     * 
     * @return The CIS scan result details' finding ARN.
     */
    public final String findingArn() {
        return findingArn;
    }

    /**
     * <p>
     * The CIS scan result details' level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The CIS scan result details' level.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel level() {
        return CisSecurityLevel.fromValue(level);
    }

    /**
     * <p>
     * The CIS scan result details' level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The CIS scan result details' level.
     * @see CisSecurityLevel
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * <p>
     * The CIS scan result details' platform.
     * </p>
     * 
     * @return The CIS scan result details' platform.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The CIS scan result details' remediation.
     * </p>
     * 
     * @return The CIS scan result details' remediation.
     */
    public final String remediation() {
        return remediation;
    }

    /**
     * <p>
     * The CIS scan result details' scan ARN.
     * </p>
     * 
     * @return The CIS scan result details' scan ARN.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * <p>
     * The CIS scan result details' status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CisFindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The CIS scan result details' status.
     * @see CisFindingStatus
     */
    public final CisFindingStatus status() {
        return CisFindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The CIS scan result details' status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CisFindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The CIS scan result details' status.
     * @see CisFindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The CIS scan result details' status reason.
     * </p>
     * 
     * @return The CIS scan result details' status reason.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The CIS scan result details' target resource ID.
     * </p>
     * 
     * @return The CIS scan result details' target resource ID.
     */
    public final String targetResourceId() {
        return targetResourceId;
    }

    /**
     * <p>
     * The CIS scan result details' title.
     * </p>
     * 
     * @return The CIS scan result details' title.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(checkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultDetails)) {
            return false;
        }
        CisScanResultDetails other = (CisScanResultDetails) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(checkDescription(), other.checkDescription())
                && Objects.equals(checkId(), other.checkId()) && Objects.equals(findingArn(), other.findingArn())
                && Objects.equals(levelAsString(), other.levelAsString()) && Objects.equals(platform(), other.platform())
                && Objects.equals(remediation(), other.remediation()) && Objects.equals(scanArn(), other.scanArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(targetResourceId(), other.targetResourceId()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisScanResultDetails").add("AccountId", accountId()).add("CheckDescription", checkDescription())
                .add("CheckId", checkId()).add("FindingArn", findingArn()).add("Level", levelAsString())
                .add("Platform", platform()).add("Remediation", remediation()).add("ScanArn", scanArn())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("TargetResourceId", targetResourceId())
                .add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "checkDescription":
            return Optional.ofNullable(clazz.cast(checkDescription()));
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        case "level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "targetResourceId":
            return Optional.ofNullable(clazz.cast(targetResourceId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("checkDescription", CHECK_DESCRIPTION_FIELD);
        map.put("checkId", CHECK_ID_FIELD);
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        map.put("title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultDetails, T> g) {
        return obj -> g.apply((CisScanResultDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisScanResultDetails> {
        /**
         * <p>
         * The CIS scan result details' account ID.
         * </p>
         * 
         * @param accountId
         *        The CIS scan result details' account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The account ID that's associated with the CIS scan result details.
         * </p>
         * 
         * @param checkDescription
         *        The account ID that's associated with the CIS scan result details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkDescription(String checkDescription);

        /**
         * <p>
         * The CIS scan result details' check ID.
         * </p>
         * 
         * @param checkId
         *        The CIS scan result details' check ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The CIS scan result details' finding ARN.
         * </p>
         * 
         * @param findingArn
         *        The CIS scan result details' finding ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(String findingArn);

        /**
         * <p>
         * The CIS scan result details' level.
         * </p>
         * 
         * @param level
         *        The CIS scan result details' level.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder level(String level);

        /**
         * <p>
         * The CIS scan result details' level.
         * </p>
         * 
         * @param level
         *        The CIS scan result details' level.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder level(CisSecurityLevel level);

        /**
         * <p>
         * The CIS scan result details' platform.
         * </p>
         * 
         * @param platform
         *        The CIS scan result details' platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The CIS scan result details' remediation.
         * </p>
         * 
         * @param remediation
         *        The CIS scan result details' remediation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(String remediation);

        /**
         * <p>
         * The CIS scan result details' scan ARN.
         * </p>
         * 
         * @param scanArn
         *        The CIS scan result details' scan ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The CIS scan result details' status.
         * </p>
         * 
         * @param status
         *        The CIS scan result details' status.
         * @see CisFindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisFindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The CIS scan result details' status.
         * </p>
         * 
         * @param status
         *        The CIS scan result details' status.
         * @see CisFindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisFindingStatus
         */
        Builder status(CisFindingStatus status);

        /**
         * <p>
         * The CIS scan result details' status reason.
         * </p>
         * 
         * @param statusReason
         *        The CIS scan result details' status reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The CIS scan result details' target resource ID.
         * </p>
         * 
         * @param targetResourceId
         *        The CIS scan result details' target resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceId(String targetResourceId);

        /**
         * <p>
         * The CIS scan result details' title.
         * </p>
         * 
         * @param title
         *        The CIS scan result details' title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String checkDescription;

        private String checkId;

        private String findingArn;

        private String level;

        private String platform;

        private String remediation;

        private String scanArn;

        private String status;

        private String statusReason;

        private String targetResourceId;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultDetails model) {
            accountId(model.accountId);
            checkDescription(model.checkDescription);
            checkId(model.checkId);
            findingArn(model.findingArn);
            level(model.level);
            platform(model.platform);
            remediation(model.remediation);
            scanArn(model.scanArn);
            status(model.status);
            statusReason(model.statusReason);
            targetResourceId(model.targetResourceId);
            title(model.title);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCheckDescription() {
            return checkDescription;
        }

        public final void setCheckDescription(String checkDescription) {
            this.checkDescription = checkDescription;
        }

        @Override
        public final Builder checkDescription(String checkDescription) {
            this.checkDescription = checkDescription;
            return this;
        }

        public final String getCheckId() {
            return checkId;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final String getFindingArn() {
            return findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(CisSecurityLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getRemediation() {
            return remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CisFindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getTargetResourceId() {
            return targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public CisScanResultDetails build() {
            return new CisScanResultDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
