/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS scan result details filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisScanResultDetailsFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<CisScanResultDetailsFilterCriteria.Builder, CisScanResultDetailsFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> CHECK_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("checkIdFilters")
            .getter(getter(CisScanResultDetailsFilterCriteria::checkIdFilters))
            .setter(setter(Builder::checkIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> FINDING_ARN_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("findingArnFilters")
            .getter(getter(CisScanResultDetailsFilterCriteria::findingArnFilters))
            .setter(setter(Builder::findingArnFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArnFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisFindingStatusFilter>> FINDING_STATUS_FILTERS_FIELD = SdkField
            .<List<CisFindingStatusFilter>> builder(MarshallingType.LIST)
            .memberName("findingStatusFilters")
            .getter(getter(CisScanResultDetailsFilterCriteria::findingStatusFilters))
            .setter(setter(Builder::findingStatusFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingStatusFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisFindingStatusFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisFindingStatusFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisSecurityLevelFilter>> SECURITY_LEVEL_FILTERS_FIELD = SdkField
            .<List<CisSecurityLevelFilter>> builder(MarshallingType.LIST)
            .memberName("securityLevelFilters")
            .getter(getter(CisScanResultDetailsFilterCriteria::securityLevelFilters))
            .setter(setter(Builder::securityLevelFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevelFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisSecurityLevelFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisSecurityLevelFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> TITLE_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("titleFilters")
            .getter(getter(CisScanResultDetailsFilterCriteria::titleFilters))
            .setter(setter(Builder::titleFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_ID_FILTERS_FIELD,
            FINDING_ARN_FILTERS_FIELD, FINDING_STATUS_FILTERS_FIELD, SECURITY_LEVEL_FILTERS_FIELD, TITLE_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CisStringFilter> checkIdFilters;

    private final List<CisStringFilter> findingArnFilters;

    private final List<CisFindingStatusFilter> findingStatusFilters;

    private final List<CisSecurityLevelFilter> securityLevelFilters;

    private final List<CisStringFilter> titleFilters;

    private CisScanResultDetailsFilterCriteria(BuilderImpl builder) {
        this.checkIdFilters = builder.checkIdFilters;
        this.findingArnFilters = builder.findingArnFilters;
        this.findingStatusFilters = builder.findingStatusFilters;
        this.securityLevelFilters = builder.securityLevelFilters;
        this.titleFilters = builder.titleFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the CheckIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCheckIdFilters() {
        return checkIdFilters != null && !(checkIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's check ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCheckIdFilters} method.
     * </p>
     * 
     * @return The criteria's check ID filters.
     */
    public final List<CisStringFilter> checkIdFilters() {
        return checkIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingArnFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingArnFilters() {
        return findingArnFilters != null && !(findingArnFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's finding ARN filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingArnFilters} method.
     * </p>
     * 
     * @return The criteria's finding ARN filters.
     */
    public final List<CisStringFilter> findingArnFilters() {
        return findingArnFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingStatusFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingStatusFilters() {
        return findingStatusFilters != null && !(findingStatusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's finding status filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingStatusFilters} method.
     * </p>
     * 
     * @return The criteria's finding status filters.
     */
    public final List<CisFindingStatusFilter> findingStatusFilters() {
        return findingStatusFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityLevelFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityLevelFilters() {
        return securityLevelFilters != null && !(securityLevelFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's security level filters. . Security level refers to the Benchmark levels that CIS assigns to a
     * profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityLevelFilters} method.
     * </p>
     * 
     * @return The criteria's security level filters. . Security level refers to the Benchmark levels that CIS assigns
     *         to a profile.
     */
    public final List<CisSecurityLevelFilter> securityLevelFilters() {
        return securityLevelFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TitleFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTitleFilters() {
        return titleFilters != null && !(titleFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's title filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitleFilters} method.
     * </p>
     * 
     * @return The criteria's title filters.
     */
    public final List<CisStringFilter> titleFilters() {
        return titleFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckIdFilters() ? checkIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingArnFilters() ? findingArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingStatusFilters() ? findingStatusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityLevelFilters() ? securityLevelFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTitleFilters() ? titleFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultDetailsFilterCriteria)) {
            return false;
        }
        CisScanResultDetailsFilterCriteria other = (CisScanResultDetailsFilterCriteria) obj;
        return hasCheckIdFilters() == other.hasCheckIdFilters() && Objects.equals(checkIdFilters(), other.checkIdFilters())
                && hasFindingArnFilters() == other.hasFindingArnFilters()
                && Objects.equals(findingArnFilters(), other.findingArnFilters())
                && hasFindingStatusFilters() == other.hasFindingStatusFilters()
                && Objects.equals(findingStatusFilters(), other.findingStatusFilters())
                && hasSecurityLevelFilters() == other.hasSecurityLevelFilters()
                && Objects.equals(securityLevelFilters(), other.securityLevelFilters())
                && hasTitleFilters() == other.hasTitleFilters() && Objects.equals(titleFilters(), other.titleFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisScanResultDetailsFilterCriteria")
                .add("CheckIdFilters", hasCheckIdFilters() ? checkIdFilters() : null)
                .add("FindingArnFilters", hasFindingArnFilters() ? findingArnFilters() : null)
                .add("FindingStatusFilters", hasFindingStatusFilters() ? findingStatusFilters() : null)
                .add("SecurityLevelFilters", hasSecurityLevelFilters() ? securityLevelFilters() : null)
                .add("TitleFilters", hasTitleFilters() ? titleFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkIdFilters":
            return Optional.ofNullable(clazz.cast(checkIdFilters()));
        case "findingArnFilters":
            return Optional.ofNullable(clazz.cast(findingArnFilters()));
        case "findingStatusFilters":
            return Optional.ofNullable(clazz.cast(findingStatusFilters()));
        case "securityLevelFilters":
            return Optional.ofNullable(clazz.cast(securityLevelFilters()));
        case "titleFilters":
            return Optional.ofNullable(clazz.cast(titleFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("checkIdFilters", CHECK_ID_FILTERS_FIELD);
        map.put("findingArnFilters", FINDING_ARN_FILTERS_FIELD);
        map.put("findingStatusFilters", FINDING_STATUS_FILTERS_FIELD);
        map.put("securityLevelFilters", SECURITY_LEVEL_FILTERS_FIELD);
        map.put("titleFilters", TITLE_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultDetailsFilterCriteria, T> g) {
        return obj -> g.apply((CisScanResultDetailsFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisScanResultDetailsFilterCriteria> {
        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * 
         * @param checkIdFilters
         *        The criteria's check ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * 
         * @param checkIdFilters
         *        The criteria's check ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdFilters(CisStringFilter... checkIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #checkIdFilters(List<CisStringFilter>)}.
         * 
         * @param checkIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder checkIdFilters(Consumer<CisStringFilter.Builder>... checkIdFilters);

        /**
         * <p>
         * The criteria's finding ARN filters.
         * </p>
         * 
         * @param findingArnFilters
         *        The criteria's finding ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArnFilters(Collection<CisStringFilter> findingArnFilters);

        /**
         * <p>
         * The criteria's finding ARN filters.
         * </p>
         * 
         * @param findingArnFilters
         *        The criteria's finding ARN filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArnFilters(CisStringFilter... findingArnFilters);

        /**
         * <p>
         * The criteria's finding ARN filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #findingArnFilters(List<CisStringFilter>)}.
         * 
         * @param findingArnFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingArnFilters(java.util.Collection<CisStringFilter>)
         */
        Builder findingArnFilters(Consumer<CisStringFilter.Builder>... findingArnFilters);

        /**
         * <p>
         * The criteria's finding status filters.
         * </p>
         * 
         * @param findingStatusFilters
         *        The criteria's finding status filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatusFilters(Collection<CisFindingStatusFilter> findingStatusFilters);

        /**
         * <p>
         * The criteria's finding status filters.
         * </p>
         * 
         * @param findingStatusFilters
         *        The criteria's finding status filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatusFilters(CisFindingStatusFilter... findingStatusFilters);

        /**
         * <p>
         * The criteria's finding status filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #findingStatusFilters(List<CisFindingStatusFilter>)}.
         * 
         * @param findingStatusFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisFindingStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingStatusFilters(java.util.Collection<CisFindingStatusFilter>)
         */
        Builder findingStatusFilters(Consumer<CisFindingStatusFilter.Builder>... findingStatusFilters);

        /**
         * <p>
         * The criteria's security level filters. . Security level refers to the Benchmark levels that CIS assigns to a
         * profile.
         * </p>
         * 
         * @param securityLevelFilters
         *        The criteria's security level filters. . Security level refers to the Benchmark levels that CIS
         *        assigns to a profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityLevelFilters(Collection<CisSecurityLevelFilter> securityLevelFilters);

        /**
         * <p>
         * The criteria's security level filters. . Security level refers to the Benchmark levels that CIS assigns to a
         * profile.
         * </p>
         * 
         * @param securityLevelFilters
         *        The criteria's security level filters. . Security level refers to the Benchmark levels that CIS
         *        assigns to a profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityLevelFilters(CisSecurityLevelFilter... securityLevelFilters);

        /**
         * <p>
         * The criteria's security level filters. . Security level refers to the Benchmark levels that CIS assigns to a
         * profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #securityLevelFilters(List<CisSecurityLevelFilter>)}.
         * 
         * @param securityLevelFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityLevelFilters(java.util.Collection<CisSecurityLevelFilter>)
         */
        Builder securityLevelFilters(Consumer<CisSecurityLevelFilter.Builder>... securityLevelFilters);

        /**
         * <p>
         * The criteria's title filters.
         * </p>
         * 
         * @param titleFilters
         *        The criteria's title filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleFilters(Collection<CisStringFilter> titleFilters);

        /**
         * <p>
         * The criteria's title filters.
         * </p>
         * 
         * @param titleFilters
         *        The criteria's title filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleFilters(CisStringFilter... titleFilters);

        /**
         * <p>
         * The criteria's title filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #titleFilters(List<CisStringFilter>)}.
         * 
         * @param titleFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleFilters(java.util.Collection<CisStringFilter>)
         */
        Builder titleFilters(Consumer<CisStringFilter.Builder>... titleFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<CisStringFilter> checkIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> findingArnFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisFindingStatusFilter> findingStatusFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisSecurityLevelFilter> securityLevelFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> titleFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultDetailsFilterCriteria model) {
            checkIdFilters(model.checkIdFilters);
            findingArnFilters(model.findingArnFilters);
            findingStatusFilters(model.findingStatusFilters);
            securityLevelFilters(model.securityLevelFilters);
            titleFilters(model.titleFilters);
        }

        public final List<CisStringFilter.Builder> getCheckIdFilters() {
            List<CisStringFilter.Builder> result = CheckIdFilterListCopier.copyToBuilder(this.checkIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckIdFilters(Collection<CisStringFilter.BuilderImpl> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copyFromBuilder(checkIdFilters);
        }

        @Override
        public final Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copy(checkIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(CisStringFilter... checkIdFilters) {
            checkIdFilters(Arrays.asList(checkIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(Consumer<CisStringFilter.Builder>... checkIdFilters) {
            checkIdFilters(Stream.of(checkIdFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getFindingArnFilters() {
            List<CisStringFilter.Builder> result = CisFindingArnFilterListCopier.copyToBuilder(this.findingArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingArnFilters(Collection<CisStringFilter.BuilderImpl> findingArnFilters) {
            this.findingArnFilters = CisFindingArnFilterListCopier.copyFromBuilder(findingArnFilters);
        }

        @Override
        public final Builder findingArnFilters(Collection<CisStringFilter> findingArnFilters) {
            this.findingArnFilters = CisFindingArnFilterListCopier.copy(findingArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArnFilters(CisStringFilter... findingArnFilters) {
            findingArnFilters(Arrays.asList(findingArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArnFilters(Consumer<CisStringFilter.Builder>... findingArnFilters) {
            findingArnFilters(Stream.of(findingArnFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisFindingStatusFilter.Builder> getFindingStatusFilters() {
            List<CisFindingStatusFilter.Builder> result = CisFindingStatusFilterListCopier
                    .copyToBuilder(this.findingStatusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingStatusFilters(Collection<CisFindingStatusFilter.BuilderImpl> findingStatusFilters) {
            this.findingStatusFilters = CisFindingStatusFilterListCopier.copyFromBuilder(findingStatusFilters);
        }

        @Override
        public final Builder findingStatusFilters(Collection<CisFindingStatusFilter> findingStatusFilters) {
            this.findingStatusFilters = CisFindingStatusFilterListCopier.copy(findingStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatusFilters(CisFindingStatusFilter... findingStatusFilters) {
            findingStatusFilters(Arrays.asList(findingStatusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatusFilters(Consumer<CisFindingStatusFilter.Builder>... findingStatusFilters) {
            findingStatusFilters(Stream.of(findingStatusFilters)
                    .map(c -> CisFindingStatusFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisSecurityLevelFilter.Builder> getSecurityLevelFilters() {
            List<CisSecurityLevelFilter.Builder> result = CisSecurityLevelFilterListCopier
                    .copyToBuilder(this.securityLevelFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityLevelFilters(Collection<CisSecurityLevelFilter.BuilderImpl> securityLevelFilters) {
            this.securityLevelFilters = CisSecurityLevelFilterListCopier.copyFromBuilder(securityLevelFilters);
        }

        @Override
        public final Builder securityLevelFilters(Collection<CisSecurityLevelFilter> securityLevelFilters) {
            this.securityLevelFilters = CisSecurityLevelFilterListCopier.copy(securityLevelFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityLevelFilters(CisSecurityLevelFilter... securityLevelFilters) {
            securityLevelFilters(Arrays.asList(securityLevelFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityLevelFilters(Consumer<CisSecurityLevelFilter.Builder>... securityLevelFilters) {
            securityLevelFilters(Stream.of(securityLevelFilters)
                    .map(c -> CisSecurityLevelFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTitleFilters() {
            List<CisStringFilter.Builder> result = TitleFilterListCopier.copyToBuilder(this.titleFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitleFilters(Collection<CisStringFilter.BuilderImpl> titleFilters) {
            this.titleFilters = TitleFilterListCopier.copyFromBuilder(titleFilters);
        }

        @Override
        public final Builder titleFilters(Collection<CisStringFilter> titleFilters) {
            this.titleFilters = TitleFilterListCopier.copy(titleFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titleFilters(CisStringFilter... titleFilters) {
            titleFilters(Arrays.asList(titleFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titleFilters(Consumer<CisStringFilter.Builder>... titleFilters) {
            titleFilters(Stream.of(titleFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CisScanResultDetailsFilterCriteria build() {
            return new CisScanResultDetailsFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
