/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS security level filter. Security level refers to the Benchmark levels that CIS assigns to a profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisSecurityLevelFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CisSecurityLevelFilter.Builder, CisSecurityLevelFilter> {
    private static final SdkField<String> COMPARISON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparison").getter(getter(CisSecurityLevelFilter::comparisonAsString))
            .setter(setter(Builder::comparison))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparison").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(CisSecurityLevelFilter::valueAsString)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMPARISON_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comparison;

    private final String value;

    private CisSecurityLevelFilter(BuilderImpl builder) {
        this.comparison = builder.comparison;
        this.value = builder.value;
    }

    /**
     * <p>
     * The CIS security filter comparison value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link CisSecurityLevelComparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonAsString}.
     * </p>
     * 
     * @return The CIS security filter comparison value.
     * @see CisSecurityLevelComparison
     */
    public final CisSecurityLevelComparison comparison() {
        return CisSecurityLevelComparison.fromValue(comparison);
    }

    /**
     * <p>
     * The CIS security filter comparison value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link CisSecurityLevelComparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonAsString}.
     * </p>
     * 
     * @return The CIS security filter comparison value.
     * @see CisSecurityLevelComparison
     */
    public final String comparisonAsString() {
        return comparison;
    }

    /**
     * <p>
     * The CIS security filter value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The CIS security filter value.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel value() {
        return CisSecurityLevel.fromValue(value);
    }

    /**
     * <p>
     * The CIS security filter value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The CIS security filter value.
     * @see CisSecurityLevel
     */
    public final String valueAsString() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(valueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisSecurityLevelFilter)) {
            return false;
        }
        CisSecurityLevelFilter other = (CisSecurityLevelFilter) obj;
        return Objects.equals(comparisonAsString(), other.comparisonAsString())
                && Objects.equals(valueAsString(), other.valueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisSecurityLevelFilter").add("Comparison", comparisonAsString()).add("Value", valueAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparison":
            return Optional.ofNullable(clazz.cast(comparisonAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(valueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("comparison", COMPARISON_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisSecurityLevelFilter, T> g) {
        return obj -> g.apply((CisSecurityLevelFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisSecurityLevelFilter> {
        /**
         * <p>
         * The CIS security filter comparison value.
         * </p>
         * 
         * @param comparison
         *        The CIS security filter comparison value.
         * @see CisSecurityLevelComparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevelComparison
         */
        Builder comparison(String comparison);

        /**
         * <p>
         * The CIS security filter comparison value.
         * </p>
         * 
         * @param comparison
         *        The CIS security filter comparison value.
         * @see CisSecurityLevelComparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevelComparison
         */
        Builder comparison(CisSecurityLevelComparison comparison);

        /**
         * <p>
         * The CIS security filter value.
         * </p>
         * 
         * @param value
         *        The CIS security filter value.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder value(String value);

        /**
         * <p>
         * The CIS security filter value.
         * </p>
         * 
         * @param value
         *        The CIS security filter value.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder value(CisSecurityLevel value);
    }

    static final class BuilderImpl implements Builder {
        private String comparison;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CisSecurityLevelFilter model) {
            comparison(model.comparison);
            value(model.value);
        }

        public final String getComparison() {
            return comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        public final Builder comparison(CisSecurityLevelComparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(CisSecurityLevel value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        @Override
        public CisSecurityLevelFilter build() {
            return new CisSecurityLevelFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
