/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisaData implements SdkPojo, Serializable, ToCopyableBuilder<CisaData.Builder, CisaData> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(CisaData::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Instant> DATE_ADDED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateAdded").getter(getter(CisaData::dateAdded)).setter(setter(Builder::dateAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateAdded").build()).build();

    private static final SdkField<Instant> DATE_DUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateDue").getter(getter(CisaData::dateDue)).setter(setter(Builder::dateDue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateDue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            DATE_ADDED_FIELD, DATE_DUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final Instant dateAdded;

    private final Instant dateDue;

    private CisaData(BuilderImpl builder) {
        this.action = builder.action;
        this.dateAdded = builder.dateAdded;
        this.dateDue = builder.dateDue;
    }

    /**
     * <p>
     * The remediation action recommended by CISA for this vulnerability.
     * </p>
     * 
     * @return The remediation action recommended by CISA for this vulnerability.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The date and time CISA added this vulnerability to their catalogue.
     * </p>
     * 
     * @return The date and time CISA added this vulnerability to their catalogue.
     */
    public final Instant dateAdded() {
        return dateAdded;
    }

    /**
     * <p>
     * The date and time CISA expects a fix to have been provided vulnerability.
     * </p>
     * 
     * @return The date and time CISA expects a fix to have been provided vulnerability.
     */
    public final Instant dateDue() {
        return dateDue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(dateAdded());
        hashCode = 31 * hashCode + Objects.hashCode(dateDue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisaData)) {
            return false;
        }
        CisaData other = (CisaData) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(dateAdded(), other.dateAdded())
                && Objects.equals(dateDue(), other.dateDue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisaData").add("Action", action()).add("DateAdded", dateAdded()).add("DateDue", dateDue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "dateAdded":
            return Optional.ofNullable(clazz.cast(dateAdded()));
        case "dateDue":
            return Optional.ofNullable(clazz.cast(dateDue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("dateAdded", DATE_ADDED_FIELD);
        map.put("dateDue", DATE_DUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisaData, T> g) {
        return obj -> g.apply((CisaData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisaData> {
        /**
         * <p>
         * The remediation action recommended by CISA for this vulnerability.
         * </p>
         * 
         * @param action
         *        The remediation action recommended by CISA for this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The date and time CISA added this vulnerability to their catalogue.
         * </p>
         * 
         * @param dateAdded
         *        The date and time CISA added this vulnerability to their catalogue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateAdded(Instant dateAdded);

        /**
         * <p>
         * The date and time CISA expects a fix to have been provided vulnerability.
         * </p>
         * 
         * @param dateDue
         *        The date and time CISA expects a fix to have been provided vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateDue(Instant dateDue);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private Instant dateAdded;

        private Instant dateDue;

        private BuilderImpl() {
        }

        private BuilderImpl(CisaData model) {
            action(model.action);
            dateAdded(model.dateAdded);
            dateDue(model.dateDue);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Instant getDateAdded() {
            return dateAdded;
        }

        public final void setDateAdded(Instant dateAdded) {
            this.dateAdded = dateAdded;
        }

        @Override
        public final Builder dateAdded(Instant dateAdded) {
            this.dateAdded = dateAdded;
            return this;
        }

        public final Instant getDateDue() {
            return dateDue;
        }

        public final void setDateDue(Instant dateDue) {
            this.dateDue = dateDue;
        }

        @Override
        public final Builder dateDue(Instant dateDue) {
            this.dateDue = dateDue;
            return this;
        }

        @Override
        public CisaData build() {
            return new CisaData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
