/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about any errors encountered while trying to retrieve a code snippet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSnippetError implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSnippetError.Builder, CodeSnippetError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(CodeSnippetError::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(CodeSnippetError::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingArn").getter(getter(CodeSnippetError::findingArn)).setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, FINDING_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final String findingArn;

    private CodeSnippetError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.findingArn = builder.findingArn;
    }

    /**
     * <p>
     * The error code for the error that prevented a code snippet from being retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link CodeSnippetErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the error that prevented a code snippet from being retrieved.
     * @see CodeSnippetErrorCode
     */
    public final CodeSnippetErrorCode errorCode() {
        return CodeSnippetErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code for the error that prevented a code snippet from being retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link CodeSnippetErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the error that prevented a code snippet from being retrieved.
     * @see CodeSnippetErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The error message received when Amazon Inspector failed to retrieve a code snippet.
     * </p>
     * 
     * @return The error message received when Amazon Inspector failed to retrieve a code snippet.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The ARN of the finding that a code snippet couldn't be retrieved for.
     * </p>
     * 
     * @return The ARN of the finding that a code snippet couldn't be retrieved for.
     */
    public final String findingArn() {
        return findingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(findingArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSnippetError)) {
            return false;
        }
        CodeSnippetError other = (CodeSnippetError) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(findingArn(), other.findingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSnippetError").add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage())
                .add("FindingArn", findingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("findingArn", FINDING_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSnippetError, T> g) {
        return obj -> g.apply((CodeSnippetError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSnippetError> {
        /**
         * <p>
         * The error code for the error that prevented a code snippet from being retrieved.
         * </p>
         * 
         * @param errorCode
         *        The error code for the error that prevented a code snippet from being retrieved.
         * @see CodeSnippetErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeSnippetErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the error that prevented a code snippet from being retrieved.
         * </p>
         * 
         * @param errorCode
         *        The error code for the error that prevented a code snippet from being retrieved.
         * @see CodeSnippetErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeSnippetErrorCode
         */
        Builder errorCode(CodeSnippetErrorCode errorCode);

        /**
         * <p>
         * The error message received when Amazon Inspector failed to retrieve a code snippet.
         * </p>
         * 
         * @param errorMessage
         *        The error message received when Amazon Inspector failed to retrieve a code snippet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The ARN of the finding that a code snippet couldn't be retrieved for.
         * </p>
         * 
         * @param findingArn
         *        The ARN of the finding that a code snippet couldn't be retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(String findingArn);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private String findingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSnippetError model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            findingArn(model.findingArn);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(CodeSnippetErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getFindingArn() {
            return findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        @Override
        public CodeSnippetError build() {
            return new CodeSnippetError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
