/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * a structure that contains information on the count of resources within a group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Counts implements SdkPojo, Serializable, ToCopyableBuilder<Counts.Builder, Counts> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(Counts::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> GROUP_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupKey").getter(getter(Counts::groupKeyAsString)).setter(setter(Builder::groupKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, GROUP_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final String groupKey;

    private Counts(BuilderImpl builder) {
        this.count = builder.count;
        this.groupKey = builder.groupKey;
    }

    /**
     * <p>
     * The number of resources.
     * </p>
     * 
     * @return The number of resources.
     */
    public final Long count() {
        return count;
    }

    /**
     * <p>
     * The key associated with this group
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupKey} will
     * return {@link GroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupKeyAsString}.
     * </p>
     * 
     * @return The key associated with this group
     * @see GroupKey
     */
    public final GroupKey groupKey() {
        return GroupKey.fromValue(groupKey);
    }

    /**
     * <p>
     * The key associated with this group
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupKey} will
     * return {@link GroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupKeyAsString}.
     * </p>
     * 
     * @return The key associated with this group
     * @see GroupKey
     */
    public final String groupKeyAsString() {
        return groupKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(groupKeyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Counts)) {
            return false;
        }
        Counts other = (Counts) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(groupKeyAsString(), other.groupKeyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Counts").add("Count", count()).add("GroupKey", groupKeyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "groupKey":
            return Optional.ofNullable(clazz.cast(groupKeyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("groupKey", GROUP_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Counts, T> g) {
        return obj -> g.apply((Counts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Counts> {
        /**
         * <p>
         * The number of resources.
         * </p>
         * 
         * @param count
         *        The number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The key associated with this group
         * </p>
         * 
         * @param groupKey
         *        The key associated with this group
         * @see GroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupKey
         */
        Builder groupKey(String groupKey);

        /**
         * <p>
         * The key associated with this group
         * </p>
         * 
         * @param groupKey
         *        The key associated with this group
         * @see GroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupKey
         */
        Builder groupKey(GroupKey groupKey);
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private String groupKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Counts model) {
            count(model.count);
            groupKey(model.groupKey);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final String getGroupKey() {
            return groupKey;
        }

        public final void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        @Override
        public final Builder groupKey(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        @Override
        public final Builder groupKey(GroupKey groupKey) {
            this.groupKey(groupKey == null ? null : groupKey.toString());
            return this;
        }

        @Override
        public Counts build() {
            return new Counts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
