/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCisScanConfigurationRequest extends Inspector2Request implements
        ToCopyableBuilder<CreateCisScanConfigurationRequest.Builder, CreateCisScanConfigurationRequest> {
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(CreateCisScanConfigurationRequest::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CreateCisScanConfigurationRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityLevel").getter(getter(CreateCisScanConfigurationRequest::securityLevelAsString))
            .setter(setter(Builder::securityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCisScanConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CreateCisTargets> TARGETS_FIELD = SdkField.<CreateCisTargets> builder(MarshallingType.SDK_POJO)
            .memberName("targets").getter(getter(CreateCisScanConfigurationRequest::targets)).setter(setter(Builder::targets))
            .constructor(CreateCisTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_NAME_FIELD,
            SCHEDULE_FIELD, SECURITY_LEVEL_FIELD, TAGS_FIELD, TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scanName;

    private final Schedule schedule;

    private final String securityLevel;

    private final Map<String, String> tags;

    private final CreateCisTargets targets;

    private CreateCisScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.scanName = builder.scanName;
        this.schedule = builder.schedule;
        this.securityLevel = builder.securityLevel;
        this.tags = builder.tags;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * The scan name for the CIS scan configuration.
     * </p>
     * 
     * @return The scan name for the CIS scan configuration.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The schedule for the CIS scan configuration.
     * </p>
     * 
     * @return The schedule for the CIS scan configuration.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS assigns
     * to a profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
     *         assigns to a profile.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(securityLevel);
    }

    /**
     * <p>
     * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS assigns
     * to a profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
     *         assigns to a profile.
     * @see CisSecurityLevel
     */
    public final String securityLevelAsString() {
        return securityLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the CIS scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the CIS scan configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The targets for the CIS scan configuration.
     * </p>
     * 
     * @return The targets for the CIS scan configuration.
     */
    public final CreateCisTargets targets() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(securityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCisScanConfigurationRequest)) {
            return false;
        }
        CreateCisScanConfigurationRequest other = (CreateCisScanConfigurationRequest) obj;
        return Objects.equals(scanName(), other.scanName()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(securityLevelAsString(), other.securityLevelAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(targets(), other.targets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCisScanConfigurationRequest").add("ScanName", scanName()).add("Schedule", schedule())
                .add("SecurityLevel", securityLevelAsString()).add("Tags", hasTags() ? tags() : null).add("Targets", targets())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "securityLevel":
            return Optional.ofNullable(clazz.cast(securityLevelAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("securityLevel", SECURITY_LEVEL_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("targets", TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCisScanConfigurationRequest, T> g) {
        return obj -> g.apply((CreateCisScanConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCisScanConfigurationRequest> {
        /**
         * <p>
         * The scan name for the CIS scan configuration.
         * </p>
         * 
         * @param scanName
         *        The scan name for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The schedule for the CIS scan configuration.
         * </p>
         * 
         * @param schedule
         *        The schedule for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule for the CIS scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
         * assigns to a profile.
         * </p>
         * 
         * @param securityLevel
         *        The security level for the CIS scan configuration. Security level refers to the Benchmark levels that
         *        CIS assigns to a profile.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(String securityLevel);

        /**
         * <p>
         * The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS
         * assigns to a profile.
         * </p>
         * 
         * @param securityLevel
         *        The security level for the CIS scan configuration. Security level refers to the Benchmark levels that
         *        CIS assigns to a profile.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(CisSecurityLevel securityLevel);

        /**
         * <p>
         * The tags for the CIS scan configuration.
         * </p>
         * 
         * @param tags
         *        The tags for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The targets for the CIS scan configuration.
         * </p>
         * 
         * @param targets
         *        The targets for the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(CreateCisTargets targets);

        /**
         * <p>
         * The targets for the CIS scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateCisTargets.Builder} avoiding the
         * need to create one manually via {@link CreateCisTargets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateCisTargets.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(CreateCisTargets)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link CreateCisTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(CreateCisTargets)
         */
        default Builder targets(Consumer<CreateCisTargets.Builder> targets) {
            return targets(CreateCisTargets.builder().applyMutation(targets).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String scanName;

        private Schedule schedule;

        private String securityLevel;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private CreateCisTargets targets;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCisScanConfigurationRequest model) {
            super(model);
            scanName(model.scanName);
            schedule(model.schedule);
            securityLevel(model.securityLevel);
            tags(model.tags);
            targets(model.targets);
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSecurityLevel() {
            return securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = CisTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = CisTagMapCopier.copy(tags);
            return this;
        }

        public final CreateCisTargets.Builder getTargets() {
            return targets != null ? targets.toBuilder() : null;
        }

        public final void setTargets(CreateCisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(CreateCisTargets targets) {
            this.targets = targets;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCisScanConfigurationRequest build() {
            return new CreateCisScanConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
