/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the ECR automated re-scan duration setting for your environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcrConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EcrConfiguration.Builder, EcrConfiguration> {
    private static final SdkField<String> PULL_DATE_RESCAN_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullDateRescanDuration").getter(getter(EcrConfiguration::pullDateRescanDurationAsString))
            .setter(setter(Builder::pullDateRescanDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullDateRescanDuration").build())
            .build();

    private static final SdkField<String> RESCAN_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rescanDuration").getter(getter(EcrConfiguration::rescanDurationAsString))
            .setter(setter(Builder::rescanDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rescanDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PULL_DATE_RESCAN_DURATION_FIELD, RESCAN_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pullDateRescanDuration;

    private final String rescanDuration;

    private EcrConfiguration(BuilderImpl builder) {
        this.pullDateRescanDuration = builder.pullDateRescanDuration;
        this.rescanDuration = builder.rescanDuration;
    }

    /**
     * <p>
     * The rescan duration configured for image pull date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullDateRescanDuration} will return {@link EcrPullDateRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pullDateRescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image pull date.
     * @see EcrPullDateRescanDuration
     */
    public final EcrPullDateRescanDuration pullDateRescanDuration() {
        return EcrPullDateRescanDuration.fromValue(pullDateRescanDuration);
    }

    /**
     * <p>
     * The rescan duration configured for image pull date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullDateRescanDuration} will return {@link EcrPullDateRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pullDateRescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image pull date.
     * @see EcrPullDateRescanDuration
     */
    public final String pullDateRescanDurationAsString() {
        return pullDateRescanDuration;
    }

    /**
     * <p>
     * The rescan duration configured for image push date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rescanDuration}
     * will return {@link EcrRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image push date.
     * @see EcrRescanDuration
     */
    public final EcrRescanDuration rescanDuration() {
        return EcrRescanDuration.fromValue(rescanDuration);
    }

    /**
     * <p>
     * The rescan duration configured for image push date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rescanDuration}
     * will return {@link EcrRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image push date.
     * @see EcrRescanDuration
     */
    public final String rescanDurationAsString() {
        return rescanDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pullDateRescanDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rescanDurationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrConfiguration)) {
            return false;
        }
        EcrConfiguration other = (EcrConfiguration) obj;
        return Objects.equals(pullDateRescanDurationAsString(), other.pullDateRescanDurationAsString())
                && Objects.equals(rescanDurationAsString(), other.rescanDurationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcrConfiguration").add("PullDateRescanDuration", pullDateRescanDurationAsString())
                .add("RescanDuration", rescanDurationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullDateRescanDuration":
            return Optional.ofNullable(clazz.cast(pullDateRescanDurationAsString()));
        case "rescanDuration":
            return Optional.ofNullable(clazz.cast(rescanDurationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pullDateRescanDuration", PULL_DATE_RESCAN_DURATION_FIELD);
        map.put("rescanDuration", RESCAN_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcrConfiguration, T> g) {
        return obj -> g.apply((EcrConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcrConfiguration> {
        /**
         * <p>
         * The rescan duration configured for image pull date.
         * </p>
         * 
         * @param pullDateRescanDuration
         *        The rescan duration configured for image pull date.
         * @see EcrPullDateRescanDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrPullDateRescanDuration
         */
        Builder pullDateRescanDuration(String pullDateRescanDuration);

        /**
         * <p>
         * The rescan duration configured for image pull date.
         * </p>
         * 
         * @param pullDateRescanDuration
         *        The rescan duration configured for image pull date.
         * @see EcrPullDateRescanDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrPullDateRescanDuration
         */
        Builder pullDateRescanDuration(EcrPullDateRescanDuration pullDateRescanDuration);

        /**
         * <p>
         * The rescan duration configured for image push date.
         * </p>
         * 
         * @param rescanDuration
         *        The rescan duration configured for image push date.
         * @see EcrRescanDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrRescanDuration
         */
        Builder rescanDuration(String rescanDuration);

        /**
         * <p>
         * The rescan duration configured for image push date.
         * </p>
         * 
         * @param rescanDuration
         *        The rescan duration configured for image push date.
         * @see EcrRescanDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrRescanDuration
         */
        Builder rescanDuration(EcrRescanDuration rescanDuration);
    }

    static final class BuilderImpl implements Builder {
        private String pullDateRescanDuration;

        private String rescanDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(EcrConfiguration model) {
            pullDateRescanDuration(model.pullDateRescanDuration);
            rescanDuration(model.rescanDuration);
        }

        public final String getPullDateRescanDuration() {
            return pullDateRescanDuration;
        }

        public final void setPullDateRescanDuration(String pullDateRescanDuration) {
            this.pullDateRescanDuration = pullDateRescanDuration;
        }

        @Override
        public final Builder pullDateRescanDuration(String pullDateRescanDuration) {
            this.pullDateRescanDuration = pullDateRescanDuration;
            return this;
        }

        @Override
        public final Builder pullDateRescanDuration(EcrPullDateRescanDuration pullDateRescanDuration) {
            this.pullDateRescanDuration(pullDateRescanDuration == null ? null : pullDateRescanDuration.toString());
            return this;
        }

        public final String getRescanDuration() {
            return rescanDuration;
        }

        public final void setRescanDuration(String rescanDuration) {
            this.rescanDuration = rescanDuration;
        }

        @Override
        public final Builder rescanDuration(String rescanDuration) {
            this.rescanDuration = rescanDuration;
            return this;
        }

        @Override
        public final Builder rescanDuration(EcrRescanDuration rescanDuration) {
            this.rescanDuration(rescanDuration == null ? null : rescanDuration.toString());
            return this;
        }

        @Override
        public EcrConfiguration build() {
            return new EcrConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
