/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableDelegatedAdminAccountResponse extends Inspector2Response implements
        ToCopyableBuilder<EnableDelegatedAdminAccountResponse.Builder, EnableDelegatedAdminAccountResponse> {
    private static final SdkField<String> DELEGATED_ADMIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("delegatedAdminAccountId").getter(getter(EnableDelegatedAdminAccountResponse::delegatedAdminAccountId))
            .setter(setter(Builder::delegatedAdminAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdminAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DELEGATED_ADMIN_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String delegatedAdminAccountId;

    private EnableDelegatedAdminAccountResponse(BuilderImpl builder) {
        super(builder);
        this.delegatedAdminAccountId = builder.delegatedAdminAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.
     */
    public final String delegatedAdminAccountId() {
        return delegatedAdminAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(delegatedAdminAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableDelegatedAdminAccountResponse)) {
            return false;
        }
        EnableDelegatedAdminAccountResponse other = (EnableDelegatedAdminAccountResponse) obj;
        return Objects.equals(delegatedAdminAccountId(), other.delegatedAdminAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableDelegatedAdminAccountResponse").add("DelegatedAdminAccountId", delegatedAdminAccountId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegatedAdminAccountId":
            return Optional.ofNullable(clazz.cast(delegatedAdminAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("delegatedAdminAccountId", DELEGATED_ADMIN_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableDelegatedAdminAccountResponse, T> g) {
        return obj -> g.apply((EnableDelegatedAdminAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableDelegatedAdminAccountResponse> {
        /**
         * <p>
         * The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.
         * </p>
         * 
         * @param delegatedAdminAccountId
         *        The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdminAccountId(String delegatedAdminAccountId);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String delegatedAdminAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableDelegatedAdminAccountResponse model) {
            super(model);
            delegatedAdminAccountId(model.delegatedAdminAccountId);
        }

        public final String getDelegatedAdminAccountId() {
            return delegatedAdminAccountId;
        }

        public final void setDelegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
        }

        @Override
        public final Builder delegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
            return this;
        }

        @Override
        public EnableDelegatedAdminAccountResponse build() {
            return new EnableDelegatedAdminAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
