/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the evidence for a vulnerability identified in a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Evidence implements SdkPojo, Serializable, ToCopyableBuilder<Evidence.Builder, Evidence> {
    private static final SdkField<String> EVIDENCE_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceDetail").getter(getter(Evidence::evidenceDetail)).setter(setter(Builder::evidenceDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceDetail").build()).build();

    private static final SdkField<String> EVIDENCE_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceRule").getter(getter(Evidence::evidenceRule)).setter(setter(Builder::evidenceRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceRule").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(Evidence::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_DETAIL_FIELD,
            EVIDENCE_RULE_FIELD, SEVERITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evidenceDetail;

    private final String evidenceRule;

    private final String severity;

    private Evidence(BuilderImpl builder) {
        this.evidenceDetail = builder.evidenceDetail;
        this.evidenceRule = builder.evidenceRule;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * The evidence details.
     * </p>
     * 
     * @return The evidence details.
     */
    public final String evidenceDetail() {
        return evidenceDetail;
    }

    /**
     * <p>
     * The evidence rule.
     * </p>
     * 
     * @return The evidence rule.
     */
    public final String evidenceRule() {
        return evidenceRule;
    }

    /**
     * <p>
     * The evidence severity.
     * </p>
     * 
     * @return The evidence severity.
     */
    public final String severity() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evidenceDetail());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceRule());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence other = (Evidence) obj;
        return Objects.equals(evidenceDetail(), other.evidenceDetail()) && Objects.equals(evidenceRule(), other.evidenceRule())
                && Objects.equals(severity(), other.severity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Evidence").add("EvidenceDetail", evidenceDetail()).add("EvidenceRule", evidenceRule())
                .add("Severity", severity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evidenceDetail":
            return Optional.ofNullable(clazz.cast(evidenceDetail()));
        case "evidenceRule":
            return Optional.ofNullable(clazz.cast(evidenceRule()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("evidenceDetail", EVIDENCE_DETAIL_FIELD);
        map.put("evidenceRule", EVIDENCE_RULE_FIELD);
        map.put("severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Evidence, T> g) {
        return obj -> g.apply((Evidence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Evidence> {
        /**
         * <p>
         * The evidence details.
         * </p>
         * 
         * @param evidenceDetail
         *        The evidence details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceDetail(String evidenceDetail);

        /**
         * <p>
         * The evidence rule.
         * </p>
         * 
         * @param evidenceRule
         *        The evidence rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceRule(String evidenceRule);

        /**
         * <p>
         * The evidence severity.
         * </p>
         * 
         * @param severity
         *        The evidence severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);
    }

    static final class BuilderImpl implements Builder {
        private String evidenceDetail;

        private String evidenceRule;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(Evidence model) {
            evidenceDetail(model.evidenceDetail);
            evidenceRule(model.evidenceRule);
            severity(model.severity);
        }

        public final String getEvidenceDetail() {
            return evidenceDetail;
        }

        public final void setEvidenceDetail(String evidenceDetail) {
            this.evidenceDetail = evidenceDetail;
        }

        @Override
        public final Builder evidenceDetail(String evidenceDetail) {
            this.evidenceDetail = evidenceDetail;
            return this;
        }

        public final String getEvidenceRule() {
            return evidenceRule;
        }

        public final void setEvidenceRule(String evidenceRule) {
            this.evidenceRule = evidenceRule;
        }

        @Override
        public final Builder evidenceRule(String evidenceRule) {
            this.evidenceRule = evidenceRule;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public Evidence build() {
            return new Evidence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
