/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an exploit available for a finding discovered in your environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExploitabilityDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExploitabilityDetails.Builder, ExploitabilityDetails> {
    private static final SdkField<Instant> LAST_KNOWN_EXPLOIT_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastKnownExploitAt").getter(getter(ExploitabilityDetails::lastKnownExploitAt))
            .setter(setter(Builder::lastKnownExploitAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastKnownExploitAt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_KNOWN_EXPLOIT_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastKnownExploitAt;

    private ExploitabilityDetails(BuilderImpl builder) {
        this.lastKnownExploitAt = builder.lastKnownExploitAt;
    }

    /**
     * <p>
     * The date and time of the last exploit associated with a finding discovered in your environment.
     * </p>
     * 
     * @return The date and time of the last exploit associated with a finding discovered in your environment.
     */
    public final Instant lastKnownExploitAt() {
        return lastKnownExploitAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastKnownExploitAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExploitabilityDetails)) {
            return false;
        }
        ExploitabilityDetails other = (ExploitabilityDetails) obj;
        return Objects.equals(lastKnownExploitAt(), other.lastKnownExploitAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExploitabilityDetails").add("LastKnownExploitAt", lastKnownExploitAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastKnownExploitAt":
            return Optional.ofNullable(clazz.cast(lastKnownExploitAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastKnownExploitAt", LAST_KNOWN_EXPLOIT_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExploitabilityDetails, T> g) {
        return obj -> g.apply((ExploitabilityDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExploitabilityDetails> {
        /**
         * <p>
         * The date and time of the last exploit associated with a finding discovered in your environment.
         * </p>
         * 
         * @param lastKnownExploitAt
         *        The date and time of the last exploit associated with a finding discovered in your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastKnownExploitAt(Instant lastKnownExploitAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastKnownExploitAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ExploitabilityDetails model) {
            lastKnownExploitAt(model.lastKnownExploitAt);
        }

        public final Instant getLastKnownExploitAt() {
            return lastKnownExploitAt;
        }

        public final void setLastKnownExploitAt(Instant lastKnownExploitAt) {
            this.lastKnownExploitAt = lastKnownExploitAt;
        }

        @Override
        public final Builder lastKnownExploitAt(Instant lastKnownExploitAt) {
            this.lastKnownExploitAt = lastKnownExploitAt;
            return this;
        }

        @Override
        public ExploitabilityDetails build() {
            return new ExploitabilityDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
