/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with details on why an account failed to enable Amazon Inspector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedAccount implements SdkPojo, Serializable, ToCopyableBuilder<FailedAccount.Builder, FailedAccount> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(FailedAccount::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(FailedAccount::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(FailedAccount::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<ResourceStatus> RESOURCE_STATUS_FIELD = SdkField
            .<ResourceStatus> builder(MarshallingType.SDK_POJO).memberName("resourceStatus")
            .getter(getter(FailedAccount::resourceStatus)).setter(setter(Builder::resourceStatus))
            .constructor(ResourceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceStatus").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FailedAccount::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, RESOURCE_STATUS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String errorCode;

    private final String errorMessage;

    private final ResourceStatus resourceStatus;

    private final String status;

    private FailedAccount(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.resourceStatus = builder.resourceStatus;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The error code explaining why the account failed to enable Amazon Inspector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code explaining why the account failed to enable Amazon Inspector.
     * @see ErrorCode
     */
    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code explaining why the account failed to enable Amazon Inspector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code explaining why the account failed to enable Amazon Inspector.
     * @see ErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The error message received when the account failed to enable Amazon Inspector.
     * </p>
     * 
     * @return The error message received when the account failed to enable Amazon Inspector.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * An object detailing which resources Amazon Inspector is enabled to scan for the account.
     * </p>
     * 
     * @return An object detailing which resources Amazon Inspector is enabled to scan for the account.
     */
    public final ResourceStatus resourceStatus() {
        return resourceStatus;
    }

    /**
     * <p>
     * The status of Amazon Inspector for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector for the account.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of Amazon Inspector for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector for the account.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedAccount)) {
            return false;
        }
        FailedAccount other = (FailedAccount) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(resourceStatus(), other.resourceStatus())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedAccount").add("AccountId", accountId()).add("ErrorCode", errorCodeAsString())
                .add("ErrorMessage", errorMessage()).add("ResourceStatus", resourceStatus()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "resourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatus()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("resourceStatus", RESOURCE_STATUS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedAccount, T> g) {
        return obj -> g.apply((FailedAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedAccount> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The error code explaining why the account failed to enable Amazon Inspector.
         * </p>
         * 
         * @param errorCode
         *        The error code explaining why the account failed to enable Amazon Inspector.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code explaining why the account failed to enable Amazon Inspector.
         * </p>
         * 
         * @param errorCode
         *        The error code explaining why the account failed to enable Amazon Inspector.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);

        /**
         * <p>
         * The error message received when the account failed to enable Amazon Inspector.
         * </p>
         * 
         * @param errorMessage
         *        The error message received when the account failed to enable Amazon Inspector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * An object detailing which resources Amazon Inspector is enabled to scan for the account.
         * </p>
         * 
         * @param resourceStatus
         *        An object detailing which resources Amazon Inspector is enabled to scan for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * An object detailing which resources Amazon Inspector is enabled to scan for the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceStatus.Builder} avoiding the need
         * to create one manually via {@link ResourceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceStatus(ResourceStatus)}.
         * 
         * @param resourceStatus
         *        a consumer that will call methods on {@link ResourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceStatus(ResourceStatus)
         */
        default Builder resourceStatus(Consumer<ResourceStatus.Builder> resourceStatus) {
            return resourceStatus(ResourceStatus.builder().applyMutation(resourceStatus).build());
        }

        /**
         * <p>
         * The status of Amazon Inspector for the account.
         * </p>
         * 
         * @param status
         *        The status of Amazon Inspector for the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of Amazon Inspector for the account.
         * </p>
         * 
         * @param status
         *        The status of Amazon Inspector for the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String errorCode;

        private String errorMessage;

        private ResourceStatus resourceStatus;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedAccount model) {
            accountId(model.accountId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            resourceStatus(model.resourceStatus);
            status(model.status);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final ResourceStatus.Builder getResourceStatus() {
            return resourceStatus != null ? resourceStatus.toBuilder() : null;
        }

        public final void setResourceStatus(ResourceStatus.BuilderImpl resourceStatus) {
            this.resourceStatus = resourceStatus != null ? resourceStatus.build() : null;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public FailedAccount build() {
            return new FailedAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
