/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the vulnerability identified in a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingDetail implements SdkPojo, Serializable, ToCopyableBuilder<FindingDetail.Builder, FindingDetail> {
    private static final SdkField<CisaData> CISA_DATA_FIELD = SdkField.<CisaData> builder(MarshallingType.SDK_POJO)
            .memberName("cisaData").getter(getter(FindingDetail::cisaData)).setter(setter(Builder::cisaData))
            .constructor(CisaData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cisaData").build()).build();

    private static final SdkField<List<String>> CWES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cwes")
            .getter(getter(FindingDetail::cwes))
            .setter(setter(Builder::cwes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cwes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> EPSS_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("epssScore").getter(getter(FindingDetail::epssScore)).setter(setter(Builder::epssScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epssScore").build()).build();

    private static final SdkField<List<Evidence>> EVIDENCES_FIELD = SdkField
            .<List<Evidence>> builder(MarshallingType.LIST)
            .memberName("evidences")
            .getter(getter(FindingDetail::evidences))
            .setter(setter(Builder::evidences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Evidence> builder(MarshallingType.SDK_POJO)
                                            .constructor(Evidence::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExploitObserved> EXPLOIT_OBSERVED_FIELD = SdkField
            .<ExploitObserved> builder(MarshallingType.SDK_POJO).memberName("exploitObserved")
            .getter(getter(FindingDetail::exploitObserved)).setter(setter(Builder::exploitObserved))
            .constructor(ExploitObserved::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitObserved").build()).build();

    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingArn").getter(getter(FindingDetail::findingArn)).setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()).build();

    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("referenceUrls")
            .getter(getter(FindingDetail::referenceUrls))
            .setter(setter(Builder::referenceUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RISK_SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("riskScore").getter(getter(FindingDetail::riskScore)).setter(setter(Builder::riskScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("riskScore").build()).build();

    private static final SdkField<List<String>> TOOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tools")
            .getter(getter(FindingDetail::tools))
            .setter(setter(Builder::tools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TTPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ttps")
            .getter(getter(FindingDetail::ttps))
            .setter(setter(Builder::ttps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CISA_DATA_FIELD, CWES_FIELD,
            EPSS_SCORE_FIELD, EVIDENCES_FIELD, EXPLOIT_OBSERVED_FIELD, FINDING_ARN_FIELD, REFERENCE_URLS_FIELD, RISK_SCORE_FIELD,
            TOOLS_FIELD, TTPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CisaData cisaData;

    private final List<String> cwes;

    private final Double epssScore;

    private final List<Evidence> evidences;

    private final ExploitObserved exploitObserved;

    private final String findingArn;

    private final List<String> referenceUrls;

    private final Integer riskScore;

    private final List<String> tools;

    private final List<String> ttps;

    private FindingDetail(BuilderImpl builder) {
        this.cisaData = builder.cisaData;
        this.cwes = builder.cwes;
        this.epssScore = builder.epssScore;
        this.evidences = builder.evidences;
        this.exploitObserved = builder.exploitObserved;
        this.findingArn = builder.findingArn;
        this.referenceUrls = builder.referenceUrls;
        this.riskScore = builder.riskScore;
        this.tools = builder.tools;
        this.ttps = builder.ttps;
    }

    /**
     * <p>
     * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
     * </p>
     * 
     * @return The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
     */
    public final CisaData cisaData() {
        return cisaData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cwes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCwes() {
        return cwes != null && !(cwes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Common Weakness Enumerations (CWEs) associated with the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCwes} method.
     * </p>
     * 
     * @return The Common Weakness Enumerations (CWEs) associated with the vulnerability.
     */
    public final List<String> cwes() {
        return cwes;
    }

    /**
     * <p>
     * The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
     * </p>
     * 
     * @return The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
     */
    public final Double epssScore() {
        return epssScore;
    }

    /**
     * For responses, this returns true if the service returned a value for the Evidences property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvidences() {
        return evidences != null && !(evidences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information on the evidence of the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvidences} method.
     * </p>
     * 
     * @return Information on the evidence of the vulnerability.
     */
    public final List<Evidence> evidences() {
        return evidences;
    }

    /**
     * <p>
     * Contains information on when this exploit was observed.
     * </p>
     * 
     * @return Contains information on when this exploit was observed.
     */
    public final ExploitObserved exploitObserved() {
        return exploitObserved;
    }

    /**
     * <p>
     * The finding ARN that the vulnerability details are associated with.
     * </p>
     * 
     * @return The finding ARN that the vulnerability details are associated with.
     */
    public final String findingArn() {
        return findingArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceUrls() {
        return referenceUrls != null && !(referenceUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reference URLs for the vulnerability data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceUrls} method.
     * </p>
     * 
     * @return The reference URLs for the vulnerability data.
     */
    public final List<String> referenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * The risk score of the vulnerability.
     * </p>
     * 
     * @return The risk score of the vulnerability.
     */
    public final Integer riskScore() {
        return riskScore;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tools property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTools() {
        return tools != null && !(tools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The known malware tools or kits that can exploit the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTools} method.
     * </p>
     * 
     * @return The known malware tools or kits that can exploit the vulnerability.
     */
    public final List<String> tools() {
        return tools;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ttps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTtps() {
        return ttps != null && !(ttps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTtps} method.
     * </p>
     * 
     * @return The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
     */
    public final List<String> ttps() {
        return ttps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cisaData());
        hashCode = 31 * hashCode + Objects.hashCode(hasCwes() ? cwes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(epssScore());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvidences() ? evidences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(exploitObserved());
        hashCode = 31 * hashCode + Objects.hashCode(findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceUrls() ? referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(riskScore());
        hashCode = 31 * hashCode + Objects.hashCode(hasTools() ? tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTtps() ? ttps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingDetail)) {
            return false;
        }
        FindingDetail other = (FindingDetail) obj;
        return Objects.equals(cisaData(), other.cisaData()) && hasCwes() == other.hasCwes()
                && Objects.equals(cwes(), other.cwes()) && Objects.equals(epssScore(), other.epssScore())
                && hasEvidences() == other.hasEvidences() && Objects.equals(evidences(), other.evidences())
                && Objects.equals(exploitObserved(), other.exploitObserved()) && Objects.equals(findingArn(), other.findingArn())
                && hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(referenceUrls(), other.referenceUrls())
                && Objects.equals(riskScore(), other.riskScore()) && hasTools() == other.hasTools()
                && Objects.equals(tools(), other.tools()) && hasTtps() == other.hasTtps() && Objects.equals(ttps(), other.ttps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingDetail").add("CisaData", cisaData()).add("Cwes", hasCwes() ? cwes() : null)
                .add("EpssScore", epssScore()).add("Evidences", hasEvidences() ? evidences() : null)
                .add("ExploitObserved", exploitObserved()).add("FindingArn", findingArn())
                .add("ReferenceUrls", hasReferenceUrls() ? referenceUrls() : null).add("RiskScore", riskScore())
                .add("Tools", hasTools() ? tools() : null).add("Ttps", hasTtps() ? ttps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cisaData":
            return Optional.ofNullable(clazz.cast(cisaData()));
        case "cwes":
            return Optional.ofNullable(clazz.cast(cwes()));
        case "epssScore":
            return Optional.ofNullable(clazz.cast(epssScore()));
        case "evidences":
            return Optional.ofNullable(clazz.cast(evidences()));
        case "exploitObserved":
            return Optional.ofNullable(clazz.cast(exploitObserved()));
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        case "referenceUrls":
            return Optional.ofNullable(clazz.cast(referenceUrls()));
        case "riskScore":
            return Optional.ofNullable(clazz.cast(riskScore()));
        case "tools":
            return Optional.ofNullable(clazz.cast(tools()));
        case "ttps":
            return Optional.ofNullable(clazz.cast(ttps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cisaData", CISA_DATA_FIELD);
        map.put("cwes", CWES_FIELD);
        map.put("epssScore", EPSS_SCORE_FIELD);
        map.put("evidences", EVIDENCES_FIELD);
        map.put("exploitObserved", EXPLOIT_OBSERVED_FIELD);
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("referenceUrls", REFERENCE_URLS_FIELD);
        map.put("riskScore", RISK_SCORE_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("ttps", TTPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingDetail, T> g) {
        return obj -> g.apply((FindingDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingDetail> {
        /**
         * <p>
         * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
         * </p>
         * 
         * @param cisaData
         *        The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cisaData(CisaData cisaData);

        /**
         * <p>
         * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
         * </p>
         * This is a convenience method that creates an instance of the {@link CisaData.Builder} avoiding the need to
         * create one manually via {@link CisaData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CisaData.Builder#build()} is called immediately and its result is
         * passed to {@link #cisaData(CisaData)}.
         * 
         * @param cisaData
         *        a consumer that will call methods on {@link CisaData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cisaData(CisaData)
         */
        default Builder cisaData(Consumer<CisaData.Builder> cisaData) {
            return cisaData(CisaData.builder().applyMutation(cisaData).build());
        }

        /**
         * <p>
         * The Common Weakness Enumerations (CWEs) associated with the vulnerability.
         * </p>
         * 
         * @param cwes
         *        The Common Weakness Enumerations (CWEs) associated with the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwes(Collection<String> cwes);

        /**
         * <p>
         * The Common Weakness Enumerations (CWEs) associated with the vulnerability.
         * </p>
         * 
         * @param cwes
         *        The Common Weakness Enumerations (CWEs) associated with the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwes(String... cwes);

        /**
         * <p>
         * The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
         * </p>
         * 
         * @param epssScore
         *        The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epssScore(Double epssScore);

        /**
         * <p>
         * Information on the evidence of the vulnerability.
         * </p>
         * 
         * @param evidences
         *        Information on the evidence of the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidences(Collection<Evidence> evidences);

        /**
         * <p>
         * Information on the evidence of the vulnerability.
         * </p>
         * 
         * @param evidences
         *        Information on the evidence of the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidences(Evidence... evidences);

        /**
         * <p>
         * Information on the evidence of the vulnerability.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.Evidence.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.Evidence#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.Evidence.Builder#build()} is called immediately and
         * its result is passed to {@link #evidences(List<Evidence>)}.
         * 
         * @param evidences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.Evidence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evidences(java.util.Collection<Evidence>)
         */
        Builder evidences(Consumer<Evidence.Builder>... evidences);

        /**
         * <p>
         * Contains information on when this exploit was observed.
         * </p>
         * 
         * @param exploitObserved
         *        Contains information on when this exploit was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exploitObserved(ExploitObserved exploitObserved);

        /**
         * <p>
         * Contains information on when this exploit was observed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExploitObserved.Builder} avoiding the
         * need to create one manually via {@link ExploitObserved#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExploitObserved.Builder#build()} is called immediately and its
         * result is passed to {@link #exploitObserved(ExploitObserved)}.
         * 
         * @param exploitObserved
         *        a consumer that will call methods on {@link ExploitObserved.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exploitObserved(ExploitObserved)
         */
        default Builder exploitObserved(Consumer<ExploitObserved.Builder> exploitObserved) {
            return exploitObserved(ExploitObserved.builder().applyMutation(exploitObserved).build());
        }

        /**
         * <p>
         * The finding ARN that the vulnerability details are associated with.
         * </p>
         * 
         * @param findingArn
         *        The finding ARN that the vulnerability details are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(String findingArn);

        /**
         * <p>
         * The reference URLs for the vulnerability data.
         * </p>
         * 
         * @param referenceUrls
         *        The reference URLs for the vulnerability data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(Collection<String> referenceUrls);

        /**
         * <p>
         * The reference URLs for the vulnerability data.
         * </p>
         * 
         * @param referenceUrls
         *        The reference URLs for the vulnerability data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(String... referenceUrls);

        /**
         * <p>
         * The risk score of the vulnerability.
         * </p>
         * 
         * @param riskScore
         *        The risk score of the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskScore(Integer riskScore);

        /**
         * <p>
         * The known malware tools or kits that can exploit the vulnerability.
         * </p>
         * 
         * @param tools
         *        The known malware tools or kits that can exploit the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Collection<String> tools);

        /**
         * <p>
         * The known malware tools or kits that can exploit the vulnerability.
         * </p>
         * 
         * @param tools
         *        The known malware tools or kits that can exploit the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(String... tools);

        /**
         * <p>
         * The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
         * </p>
         * 
         * @param ttps
         *        The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttps(Collection<String> ttps);

        /**
         * <p>
         * The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
         * </p>
         * 
         * @param ttps
         *        The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttps(String... ttps);
    }

    static final class BuilderImpl implements Builder {
        private CisaData cisaData;

        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();

        private Double epssScore;

        private List<Evidence> evidences = DefaultSdkAutoConstructList.getInstance();

        private ExploitObserved exploitObserved;

        private String findingArn;

        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();

        private Integer riskScore;

        private List<String> tools = DefaultSdkAutoConstructList.getInstance();

        private List<String> ttps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingDetail model) {
            cisaData(model.cisaData);
            cwes(model.cwes);
            epssScore(model.epssScore);
            evidences(model.evidences);
            exploitObserved(model.exploitObserved);
            findingArn(model.findingArn);
            referenceUrls(model.referenceUrls);
            riskScore(model.riskScore);
            tools(model.tools);
            ttps(model.ttps);
        }

        public final CisaData.Builder getCisaData() {
            return cisaData != null ? cisaData.toBuilder() : null;
        }

        public final void setCisaData(CisaData.BuilderImpl cisaData) {
            this.cisaData = cisaData != null ? cisaData.build() : null;
        }

        @Override
        public final Builder cisaData(CisaData cisaData) {
            this.cisaData = cisaData;
            return this;
        }

        public final Collection<String> getCwes() {
            if (cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = CwesCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = CwesCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String... cwes) {
            cwes(Arrays.asList(cwes));
            return this;
        }

        public final Double getEpssScore() {
            return epssScore;
        }

        public final void setEpssScore(Double epssScore) {
            this.epssScore = epssScore;
        }

        @Override
        public final Builder epssScore(Double epssScore) {
            this.epssScore = epssScore;
            return this;
        }

        public final List<Evidence.Builder> getEvidences() {
            List<Evidence.Builder> result = EvidenceListCopier.copyToBuilder(this.evidences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvidences(Collection<Evidence.BuilderImpl> evidences) {
            this.evidences = EvidenceListCopier.copyFromBuilder(evidences);
        }

        @Override
        public final Builder evidences(Collection<Evidence> evidences) {
            this.evidences = EvidenceListCopier.copy(evidences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidences(Evidence... evidences) {
            evidences(Arrays.asList(evidences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidences(Consumer<Evidence.Builder>... evidences) {
            evidences(Stream.of(evidences).map(c -> Evidence.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ExploitObserved.Builder getExploitObserved() {
            return exploitObserved != null ? exploitObserved.toBuilder() : null;
        }

        public final void setExploitObserved(ExploitObserved.BuilderImpl exploitObserved) {
            this.exploitObserved = exploitObserved != null ? exploitObserved.build() : null;
        }

        @Override
        public final Builder exploitObserved(ExploitObserved exploitObserved) {
            this.exploitObserved = exploitObserved;
            return this;
        }

        public final String getFindingArn() {
            return findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = VulnerabilityReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = VulnerabilityReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String... referenceUrls) {
            referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final Integer getRiskScore() {
            return riskScore;
        }

        public final void setRiskScore(Integer riskScore) {
            this.riskScore = riskScore;
        }

        @Override
        public final Builder riskScore(Integer riskScore) {
            this.riskScore = riskScore;
            return this;
        }

        public final Collection<String> getTools() {
            if (tools instanceof SdkAutoConstructList) {
                return null;
            }
            return tools;
        }

        public final void setTools(Collection<String> tools) {
            this.tools = ToolsCopier.copy(tools);
        }

        @Override
        public final Builder tools(Collection<String> tools) {
            this.tools = ToolsCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(String... tools) {
            tools(Arrays.asList(tools));
            return this;
        }

        public final Collection<String> getTtps() {
            if (ttps instanceof SdkAutoConstructList) {
                return null;
            }
            return ttps;
        }

        public final void setTtps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
        }

        @Override
        public final Builder ttps(Collection<String> ttps) {
            this.ttps = TtpsCopier.copy(ttps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ttps(String... ttps) {
            ttps(Arrays.asList(ttps));
            return this;
        }

        @Override
        public FindingDetail build() {
            return new FindingDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
