/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCisScanResultDetailsRequest extends Inspector2Request implements
        ToCopyableBuilder<GetCisScanResultDetailsRequest.Builder, GetCisScanResultDetailsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GetCisScanResultDetailsRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<CisScanResultDetailsFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<CisScanResultDetailsFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(GetCisScanResultDetailsRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(CisScanResultDetailsFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetCisScanResultDetailsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetCisScanResultDetailsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(GetCisScanResultDetailsRequest::scanArn)).setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(GetCisScanResultDetailsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(GetCisScanResultDetailsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceId").getter(getter(GetCisScanResultDetailsRequest::targetResourceId))
            .setter(setter(Builder::targetResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            FILTER_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCAN_ARN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD,
            TARGET_RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final CisScanResultDetailsFilterCriteria filterCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private final String scanArn;

    private final String sortBy;

    private final String sortOrder;

    private final String targetResourceId;

    private GetCisScanResultDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.filterCriteria = builder.filterCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scanArn = builder.scanArn;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.targetResourceId = builder.targetResourceId;
    }

    /**
     * <p>
     * The account ID.
     * </p>
     * 
     * @return The account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The filter criteria.
     * </p>
     * 
     * @return The filter criteria.
     */
    public final CisScanResultDetailsFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The maximum number of CIS scan result details to be returned in a single page of results.
     * </p>
     * 
     * @return The maximum number of CIS scan result details to be returned in a single page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token from a previous request that's used to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token from a previous request that's used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The scan ARN.
     * </p>
     * 
     * @return The scan ARN.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * <p>
     * The sort by order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CisScanResultDetailsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sort by order.
     * @see CisScanResultDetailsSortBy
     */
    public final CisScanResultDetailsSortBy sortBy() {
        return CisScanResultDetailsSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The sort by order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CisScanResultDetailsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sort by order.
     * @see CisScanResultDetailsSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link CisSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order.
     * @see CisSortOrder
     */
    public final CisSortOrder sortOrder() {
        return CisSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link CisSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order.
     * @see CisSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The target resource ID.
     * </p>
     * 
     * @return The target resource ID.
     */
    public final String targetResourceId() {
        return targetResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCisScanResultDetailsRequest)) {
            return false;
        }
        GetCisScanResultDetailsRequest other = (GetCisScanResultDetailsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(scanArn(), other.scanArn()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(targetResourceId(), other.targetResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCisScanResultDetailsRequest").add("AccountId", accountId())
                .add("FilterCriteria", filterCriteria()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ScanArn", scanArn()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("TargetResourceId", targetResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "targetResourceId":
            return Optional.ofNullable(clazz.cast(targetResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCisScanResultDetailsRequest, T> g) {
        return obj -> g.apply((GetCisScanResultDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetCisScanResultDetailsRequest> {
        /**
         * <p>
         * The account ID.
         * </p>
         * 
         * @param accountId
         *        The account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The filter criteria.
         * </p>
         * 
         * @param filterCriteria
         *        The filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(CisScanResultDetailsFilterCriteria filterCriteria);

        /**
         * <p>
         * The filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CisScanResultDetailsFilterCriteria.Builder} avoiding the need to create one manually via
         * {@link CisScanResultDetailsFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CisScanResultDetailsFilterCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #filterCriteria(CisScanResultDetailsFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link CisScanResultDetailsFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(CisScanResultDetailsFilterCriteria)
         */
        default Builder filterCriteria(Consumer<CisScanResultDetailsFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(CisScanResultDetailsFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The maximum number of CIS scan result details to be returned in a single page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of CIS scan result details to be returned in a single page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token from a previous request that's used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from a previous request that's used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The scan ARN.
         * </p>
         * 
         * @param scanArn
         *        The scan ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The sort by order.
         * </p>
         * 
         * @param sortBy
         *        The sort by order.
         * @see CisScanResultDetailsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisScanResultDetailsSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The sort by order.
         * </p>
         * 
         * @param sortBy
         *        The sort by order.
         * @see CisScanResultDetailsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisScanResultDetailsSortBy
         */
        Builder sortBy(CisScanResultDetailsSortBy sortBy);

        /**
         * <p>
         * The sort order.
         * </p>
         * 
         * @param sortOrder
         *        The sort order.
         * @see CisSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order.
         * </p>
         * 
         * @param sortOrder
         *        The sort order.
         * @see CisSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSortOrder
         */
        Builder sortOrder(CisSortOrder sortOrder);

        /**
         * <p>
         * The target resource ID.
         * </p>
         * 
         * @param targetResourceId
         *        The target resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceId(String targetResourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String accountId;

        private CisScanResultDetailsFilterCriteria filterCriteria;

        private Integer maxResults;

        private String nextToken;

        private String scanArn;

        private String sortBy;

        private String sortOrder;

        private String targetResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCisScanResultDetailsRequest model) {
            super(model);
            accountId(model.accountId);
            filterCriteria(model.filterCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            scanArn(model.scanArn);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            targetResourceId(model.targetResourceId);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final CisScanResultDetailsFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CisScanResultDetailsFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CisScanResultDetailsFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CisScanResultDetailsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(CisSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getTargetResourceId() {
            return targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCisScanResultDetailsRequest build() {
            return new GetCisScanResultDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
