/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCisScanResultDetailsResponse extends Inspector2Response implements
        ToCopyableBuilder<GetCisScanResultDetailsResponse.Builder, GetCisScanResultDetailsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetCisScanResultDetailsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CisScanResultDetails>> SCAN_RESULT_DETAILS_FIELD = SdkField
            .<List<CisScanResultDetails>> builder(MarshallingType.LIST)
            .memberName("scanResultDetails")
            .getter(getter(GetCisScanResultDetailsResponse::scanResultDetails))
            .setter(setter(Builder::scanResultDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResultDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisScanResultDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisScanResultDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCAN_RESULT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CisScanResultDetails> scanResultDetails;

    private GetCisScanResultDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scanResultDetails = builder.scanResultDetails;
    }

    /**
     * <p>
     * The pagination token from a previous request that's used to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token from a previous request that's used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanResultDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanResultDetails() {
        return scanResultDetails != null && !(scanResultDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scan result details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanResultDetails} method.
     * </p>
     * 
     * @return The scan result details.
     */
    public final List<CisScanResultDetails> scanResultDetails() {
        return scanResultDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScanResultDetails() ? scanResultDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCisScanResultDetailsResponse)) {
            return false;
        }
        GetCisScanResultDetailsResponse other = (GetCisScanResultDetailsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasScanResultDetails() == other.hasScanResultDetails()
                && Objects.equals(scanResultDetails(), other.scanResultDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCisScanResultDetailsResponse").add("NextToken", nextToken())
                .add("ScanResultDetails", hasScanResultDetails() ? scanResultDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "scanResultDetails":
            return Optional.ofNullable(clazz.cast(scanResultDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("scanResultDetails", SCAN_RESULT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCisScanResultDetailsResponse, T> g) {
        return obj -> g.apply((GetCisScanResultDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCisScanResultDetailsResponse> {
        /**
         * <p>
         * The pagination token from a previous request that's used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from a previous request that's used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The scan result details.
         * </p>
         * 
         * @param scanResultDetails
         *        The scan result details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanResultDetails(Collection<CisScanResultDetails> scanResultDetails);

        /**
         * <p>
         * The scan result details.
         * </p>
         * 
         * @param scanResultDetails
         *        The scan result details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanResultDetails(CisScanResultDetails... scanResultDetails);

        /**
         * <p>
         * The scan result details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisScanResultDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisScanResultDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisScanResultDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #scanResultDetails(List<CisScanResultDetails>)}.
         * 
         * @param scanResultDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisScanResultDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanResultDetails(java.util.Collection<CisScanResultDetails>)
         */
        Builder scanResultDetails(Consumer<CisScanResultDetails.Builder>... scanResultDetails);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CisScanResultDetails> scanResultDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCisScanResultDetailsResponse model) {
            super(model);
            nextToken(model.nextToken);
            scanResultDetails(model.scanResultDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CisScanResultDetails.Builder> getScanResultDetails() {
            List<CisScanResultDetails.Builder> result = CisScanResultDetailsListCopier.copyToBuilder(this.scanResultDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanResultDetails(Collection<CisScanResultDetails.BuilderImpl> scanResultDetails) {
            this.scanResultDetails = CisScanResultDetailsListCopier.copyFromBuilder(scanResultDetails);
        }

        @Override
        public final Builder scanResultDetails(Collection<CisScanResultDetails> scanResultDetails) {
            this.scanResultDetails = CisScanResultDetailsListCopier.copy(scanResultDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanResultDetails(CisScanResultDetails... scanResultDetails) {
            scanResultDetails(Arrays.asList(scanResultDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanResultDetails(Consumer<CisScanResultDetails.Builder>... scanResultDetails) {
            scanResultDetails(Stream.of(scanResultDetails).map(c -> CisScanResultDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCisScanResultDetailsResponse build() {
            return new GetCisScanResultDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
